/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractDefaultDateValueUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.cp.eip.sso.util.StringUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class DefaultDateValueUI
extends AbstractDefaultDateValueUI {
    private static final long serialVersionUID = 1L;
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    private int dataType = 2;

    public DefaultDateValueUI() throws Exception {
        this.initLayout();
        this.kDButtonGroup1.add((AbstractButton)this.rbSystem);
        this.kDButtonGroup1.add((AbstractButton)this.rbFix);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateAdd);
        this.kDButtonGroup1.add((AbstractButton)this.rbDateSub);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthBegin);
        this.kDButtonGroup1.add((AbstractButton)this.rbMonthEnd);
        this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
        this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000, 1));
    }

    public DefaultDateValueUI(String value, int dataType) throws Exception {
        this();
        this.dataType = dataType;
        this.initDateFormat();
        if (value.startsWith("getSystemDate()")) {
            this.rbSystem.setSelected(true);
        } else if (value.startsWith("dayBegin")) {
            this.rbMonthBegin.setSelected(true);
        } else if (value.startsWith("dayEnd")) {
            this.rbMonthEnd.setSelected(true);
        } else if (value.startsWith("dateAdd + ")) {
            this.rbDateAdd.setSelected(true);
            value = ExtStringUtil.replace(value, "dateAdd + ", "");
            int lenth = value.length();
            int addNumber = Integer.parseInt(value.substring(0, lenth - 1));
            String unit = value.substring(lenth - 1);
            this.spAdd.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else if (value.startsWith("dateSub - ")) {
            this.rbDateSub.setSelected(true);
            value = ExtStringUtil.replace(value, "dateSub - ", "");
            int lenth = value.length();
            int addNumber = Integer.parseInt(value.substring(0, lenth - 1));
            String unit = value.substring(lenth - 1);
            this.spSub.setModel((SpinnerModel)new SpinnerNumberModel(addNumber, 0, 1000, 1));
        } else {
            this.rbFix.setSelected(true);
            String formatString = "yyyy-MM-dd";
            if (dataType == 4) {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
            Date date = null;
            if (value != null && !value.equals("")) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                    date = sdf.parse(value);
                }
                catch (ParseException e) {}
            } else {
                date = RunReportParam.getServerDate(null);
            }
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    public DefaultDateValueUI(String value, int dataType, boolean isProcedure) throws Exception {
        this(value, dataType);
        if (isProcedure) {
            this.rbSystem.setEnabled(false);
            this.rbDateAdd.setEnabled(false);
            this.rbDateSub.setEnabled(false);
            this.rbMonthBegin.setEnabled(false);
            this.rbMonthEnd.setEnabled(false);
            this.spAdd.setEnabled(false);
            this.spSub.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    private void initDateFormat() {
        if (this.dataType == 4) {
            String datePatternOld = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setTimeEnabled(true);
            String datePatternNew = this.kDDatePicker1.getDatePattern();
            this.kDDatePicker1.setDatePattern(StringUtil.replace((String)datePatternNew, (String)datePatternOld, (String)(datePatternOld + " ")));
            Rectangle rt = this.kDDatePicker1.getBounds();
            this.kDDatePicker1.setBounds(new Rectangle(rt.x, rt.y, rt.width + 55, rt.height));
            Date date = RunReportParam.getServerDate(null);
            this.kDDatePicker1.setValue((Object)date);
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.closeWin();
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
        this.kDDatePicker1.setValue(null);
        this.rbFix.setSelected(true);
    }

    protected void rbFix_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(true);
    }

    protected void rbSystem_itemStateChanged(ItemEvent e) throws Exception {
        this.kDDatePicker1.setEnabled(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getDateSelected() {
        String ret = null;
        if (this.rbSystem.isSelected()) {
            ret = "getSystemDate()";
        } else if (this.rbMonthBegin.isSelected()) {
            ret = "dayBegin";
        } else if (this.rbMonthEnd.isSelected()) {
            ret = "dayEnd";
        } else if (this.rbDateAdd.isSelected()) {
            ret = "dateAdd + " + this.spAdd.getIntegerVlaue() + "D";
        } else if (this.rbDateSub.isSelected()) {
            ret = "dateSub - " + this.spSub.getIntegerVlaue() + "D";
        } else {
            ret = CtrlReportUtil.getObjectString(this.kDDatePicker1.getText());
            if (!ret.equals("")) {
                String formatString = "yyyy-MM-dd";
                if (this.dataType == 4) {
                    formatString = "yyyy-MM-dd HH:mm:ss";
                }
                String pattern = this.kDDatePicker1.getDatePattern();
                ret = CtrlReportUtil.formatDate(pattern, formatString, ret);
            }
        }
        return ret;
    }
}

