/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.wizard.process.PKIncludedTablePanel;
import com.kingdee.bos.ctrl.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.Align;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class OutputFieldsUI
extends BaseTabUIImp {
    private static final Logger log = LogUtil.getPackageLogger(OutputFieldsUI.class);
    private WizardPanel wizardPanel = new WizardPanel();
    private static OutputFieldsUI outputFieldsUI = null;
    private static CtrlDesignQueryModel model = null;
    private String errMsg = null;
    public static String resPath = "com.kingdee.eas.base.reportmeta.ctrlreport.ReportsResource";

    private OutputFieldsUI() {
    }

    public static final OutputFieldsUI getInstance() {
        if (outputFieldsUI == null) {
            model = DesignUI.getInstance().getModel();
            outputFieldsUI = new OutputFieldsUI();
        }
        return outputFieldsUI;
    }

    public static final void destroy() {
        outputFieldsUI = null;
    }

    public KDPanel getPanel() {
        return this.wizardPanel;
    }

    public void syncModel2Ui() {
        Outputs outputs;
        IQuery quer;
        SQLCustomType type = DesignUI.getInstance().getCustomType();
        if ((type.equals(SQLCustomType.SQL) || type == SQLCustomType.SEMANTIC_SQL) && (quer = model.getQuery()).getQueryType() == QueryType.SQL_WIZARD) {
            try {
                OutputFieldsUI.setOutputColumns(model, false);
            }
            catch (CtrlReportException e) {
                MessageUtil.showDetailAndOK(null, e.getMessage(), e);
            }
        }
        if ((outputs = model.getCommonQuery().getOutputs()) != null && outputs.size() > 0) {
            this.wizardPanel.fieldsPanel.setFields((List)outputs.get(0));
        }
        this.wizardPanel.setDynamicField(new Boolean(CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.isDynamicField))));
    }

    public void syncUi2Model() {
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs == null) {
            outputs = new Outputs();
        }
        outputs.clear();
        OutputColumns list = this.wizardPanel.fieldsPanel.getFields();
        outputs.add((Object)list);
        IQuery query = model.getQuery();
        IColumnList clist = query.getColumns();
        block0: for (int i = 0; i < list.size(); ++i) {
            Column col = (Column)list.get(i);
            for (int j = 0; j < clist.size(); ++j) {
                Column ccol = (Column)clist.get(j);
                if (!col.getName().equals(ccol.getName())) continue;
                Set set = col.getProperties().keySet();
                for (String key : set) {
                    if (!key.equals("align") && !key.equals("decimalPlace")) continue;
                    ccol.getProperties().put(key, col.getProperty(key));
                }
                continue block0;
            }
        }
        model.getCommonQuery().setOutputs(outputs);
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        Map map = commonQuery.getProperties();
        map.put(CtrlDesignUtil.isDynamicField, String.valueOf(this.wizardPanel.isDynamicField()));
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static HashMap getNameAlisaMapFromModel(CtrlDesignQueryModel model) {
        HashMap<String, Column> map = new HashMap<String, Column>();
        if (model != null) {
            Outputs outputs = model.getCommonQuery().getOutputs();
            OutputColumns ocs = null;
            if (outputs != null && !outputs.isEmpty()) {
                ocs = (OutputColumns)outputs.get(0);
                for (int i = 0; i < ocs.size(); ++i) {
                    Column oc = (Column)ocs.get(i);
                    map.put(oc.getName().toUpperCase(), oc);
                }
            }
        }
        return map;
    }

    public static final void setOutputColumns(CtrlDesignQueryModel model, boolean isSave) throws CtrlReportException {
        OutputFieldsUI.setOutputColumns(model, null, isSave);
    }

    public static final void setOutputColumns(CtrlDesignQueryModel model, ResultSet rs, boolean isSave) throws CtrlReportException {
        boolean isSQLDataset = true;
        SQLCustomType type = DesignUI.getInstance().getCustomType();
        if (type == null) {
            type = SQLCustomType.SQL;
        }
        if (!type.equals(SQLCustomType.SQL) && type != SQLCustomType.SEMANTIC_SQL) {
            isSQLDataset = false;
        }
        IQuery quer = model.getQuery();
        IColumnList fieldColumns = quer.getColumns();
        OutputColumns newOutputColumns = new OutputColumns();
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs == null) {
            outputs = new Outputs();
            model.getCommonQuery().setOutputs(outputs);
        }
        if (quer.getQueryType() == QueryType.SQL_WIZARD && isSQLDataset) {
            OutputFieldsUI.fieldListToOutputList((List)fieldColumns, (List)newOutputColumns);
            CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)quer;
            ksqlQuery.setGoodOutput("true");
        }
        outputs.clear();
        outputs.add((Object)newOutputColumns);
    }

    protected static final void fieldListToOutputList(List fieldList, List outputList) {
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                Column filedColumn = (Column)fieldList.get(i);
                Column outputColumn = new Column();
                outputColumn.copy((IDefObj)filedColumn);
                outputList.add(i, outputColumn);
            }
        }
    }

    public static final void getItemCell(ICell cell, IDefObj def, String keyName) {
        Object item = cell.getValue();
        if (item != null) {
            Map properties = def.getProperties();
            properties.put(keyName, item);
        }
    }

    public static final void setItemCell(ICell cell, IDefObj def, String keyName) {
        if (def == null) {
            return;
        }
        if (StringUtils.isEmpty((String)keyName)) {
            return;
        }
        Map properties = def.getProperties();
        cell.setValue(properties.containsKey(keyName) ? properties.get(keyName) : null);
    }

    public static final void getMultiLangItemListFromCell(ICell cell, IDefObj def, String keyName) {
        MultiLangItemList itemList = (MultiLangItemList)cell.getValue();
        if (itemList != null) {
            Map properties = def.getProperties();
            MultiLangItem[] items = itemList.getItems();
            for (int n = 0; n < items.length; ++n) {
                MultiLangItem mli = items[n];
                String val = CtrlReportUtil.getObjectString(mli.getData());
                String localString = CtrlReportUtil.bosToEasLang(mli.getLang().getLocale().toString());
                properties.put(keyName + "." + localString, val);
            }
            properties.put(keyName, "#1");
        }
    }

    public static final void setMultiLangItemListToCell(ICell cell, IDefObj def, KDBizMultiLangBox bmlbAlias, String keyName) {
        int icount = bmlbAlias.getItemCount();
        MultiLangItem[] items = new MultiLangItem[icount];
        for (int m = 0; m < icount; ++m) {
            MultiLangItem mli = (MultiLangItem)bmlbAlias.getItemAt(m);
            Locale l = mli.getLang().getLocale();
            String localString = CtrlReportUtil.bosToEasLang(l.toString());
            Map properties = def.getProperties();
            String currentName = CtrlReportUtil.getObjectString(properties.get(keyName + "." + localString));
            items[m] = new MultiLangItem(mli.getLang(), (Object)currentName);
        }
        String strLocal = SysContext.getSysContext().getLocale().toString().toUpperCase();
        MultiLangItemList itemList = new MultiLangItemList(items);
        for (int n = 0; n < items.length; ++n) {
            MultiLangItem mli = items[n];
            String currentLocalString = mli.getLang().getLocale().toString();
            if (!currentLocalString.toUpperCase().equals(strLocal)) continue;
            itemList.setCurrentItem(mli);
            break;
        }
        cell.setValue((Object)itemList);
    }

    public static class OutputFieldsPanel
    extends PKIncludedTablePanel {
        private static final long serialVersionUID = 8779079108460391930L;
        private static int COL_NAME = 0;
        public static int COL_ALIAS = 1;
        private static int COL_DATA_TYPE = 2;
        private static int COL_ALIGN = 3;
        private static int COL_DECIMALPLACE = 4;
        protected List externalPs;
        protected List externalEnv;
        protected List readOnlyColumns;
        protected KDBizMultiLangBox bmlbAlias;

        public OutputFieldsPanel() {
            super(0, true);
            this.initTable();
        }

        private void initTable() {
            this.table.addColumns(5);
            IRow headRow = this.table.addHeadRow();
            headRow.getCell(COL_NAME).setValue((Object)Process2Resource.getString((String)"res_2"));
            this.table.getColumn(COL_NAME).setWidth(150);
            headRow.getCell(COL_ALIAS).setValue((Object)Process2Resource.getString((String)"res_3"));
            this.table.getColumn(COL_ALIAS).setWidth(220);
            headRow.getCell(COL_DATA_TYPE).setValue((Object)Process2Resource.getString((String)"res_4"));
            this.table.getColumn(COL_DATA_TYPE).setWidth(80);
            headRow.getCell(COL_ALIGN).setValue((Object)EASResource.getString((String)resPath, (String)"alignment"));
            headRow.getCell(COL_DECIMALPLACE).setValue((Object)EASResource.getString((String)resPath, (String)"decimalPlaces"));
            this.bmlbAlias = new KDBizMultiLangBox();
            this.bmlbAlias.setMaxLength(32);
            this.table.getColumn(COL_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.bmlbAlias));
            this.bmlbAlias.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
            KDComboBox align = new KDComboBox();
            align.addItems(Align.getEnumList().toArray());
            KDComboBox decimal = new KDComboBox();
            decimal.addItems((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
            this.table.getColumn(COL_ALIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)align));
            this.table.getColumn(COL_DECIMALPLACE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)decimal));
            this.table.getColumn(COL_NAME).getStyleAttributes().setLocked(true);
            this.table.getColumn(COL_DATA_TYPE).getStyleAttributes().setLocked(true);
            this.table.getColumn(COL_NAME).getStyleAttributes().setFontColor(Color.GRAY);
            this.table.getColumn(COL_DATA_TYPE).getStyleAttributes().setFontColor(Color.GRAY);
            this.setPkColumn(COL_NAME);
            this.table.getSelectManager().setSelectMode(1);
        }

        public void setFields(List ocs) {
            QueryType queryType = model.getQuery().getQueryType();
            boolean isProcedure = false;
            SQLCustomType type = DesignUI.getInstance().getCustomType();
            if (!type.equals(SQLCustomType.SQL)) {
                isProcedure = true;
            }
            if (queryType == QueryType.SQL_WIZARD && !isProcedure) {
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setLocked(true);
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setFontColor(Color.GRAY);
            } else {
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setLocked(false);
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setFontColor(Color.BLACK);
            }
            this.table.removeRows();
            this.readOnlyColumns = new ArrayList();
            for (int i = 0; i < ocs.size(); ++i) {
                Column oc = (Column)ocs.get(i);
                IRow newRow = this.table.addRow();
                newRow.getCell(COL_NAME).setValue((Object)oc.getName());
                newRow.getCell(COL_ALIAS).setValue((Object)oc.getAlias());
                newRow.getCell(COL_DATA_TYPE).setValue((Object)oc.getDataType());
                OutputFieldsUI.setMultiLangItemListToCell(newRow.getCell(COL_ALIAS), (IDefObj)oc, this.bmlbAlias, "alias");
                Map properties = oc.getProperties();
                if (properties.containsKey("align")) {
                    OutputFieldsUI.setItemCell(newRow.getCell(COL_ALIGN), (IDefObj)oc, "align");
                } else if (oc.getDataType().equals(DataType.DECIMAL)) {
                    newRow.getCell(COL_ALIGN).setValue((Object)Align.right);
                } else {
                    newRow.getCell(COL_ALIGN).setValue((Object)Align.left);
                }
                if (oc.getDataType().equals(DataType.DECIMAL)) {
                    if (properties.containsKey("decimalPlace")) {
                        OutputFieldsUI.setItemCell(newRow.getCell(COL_DECIMALPLACE), (IDefObj)oc, "decimalPlace");
                        continue;
                    }
                    newRow.getCell(COL_DECIMALPLACE).setValue((Object)4);
                    continue;
                }
                newRow.getCell(COL_DECIMALPLACE).setValue(null);
                newRow.getCell(COL_DECIMALPLACE).getStyleAttributes().setLocked(true);
            }
            if (this.table.getRowCount() > 0) {
                this.table.getEditManager().editCellAt(0, 1);
            }
        }

        public OutputColumns getFields() {
            OutputColumns list = new OutputColumns();
            int rows = this.table.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.table.getRow(i);
                Column oc = new Column();
                oc.setName((String)row.getCell(COL_NAME).getValue());
                oc.setDataType((DataType)row.getCell(COL_DATA_TYPE).getValue());
                OutputFieldsUI.getMultiLangItemListFromCell(row.getCell(COL_ALIAS), (IDefObj)oc, "alias");
                OutputFieldsUI.getItemCell(row.getCell(COL_ALIGN), (IDefObj)oc, "align");
                OutputFieldsUI.getItemCell(row.getCell(COL_DECIMALPLACE), (IDefObj)oc, "decimalPlace");
                list.add((Object)oc);
            }
            return list;
        }
    }

    class WizardPanel
    extends KDPanel {
        private static final long serialVersionUID = -7629640026263253278L;
        private OutputFieldsPanel fieldsPanel = new OutputFieldsPanel();
        KDCheckBox cbDynamic;

        public WizardPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.fieldsPanel), "Center");
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)new FlowLayout(0));
            KDLabel lbMsg = new KDLabel(MessageUtil.getMsgInfo("label432"));
            lbMsg.setPreferredSize(new Dimension(180, 19));
            lbMsg.setForeground(new Color(0, 0, 255));
            panel.add((Component)lbMsg);
            this.cbDynamic = new KDCheckBox();
            this.cbDynamic.setText("\u662f\u5426\u52a8\u6001\u8f93\u51fa\u5b57\u6bb5\uff08\u8f93\u51fa\u5b57\u6bb5\u968f\u8fc7\u6ee4\u6761\u4ef6\u52a8\u6001\u53d8\u5316\uff0c\u52fe\u9009\u65f6\uff0c\u5b57\u6bb5\u7684\u522b\u540d\u5c31\u662f\u5b57\u6bb5\u540d\uff09");
            this.cbDynamic.setPreferredSize(new Dimension(550, 19));
            panel.add((Component)this.cbDynamic);
            this.add((Component)panel, "South");
        }

        public KDTable getTable() {
            return this.fieldsPanel.getTable();
        }

        public void setDynamicField(boolean dynamicField) {
            this.cbDynamic.setSelected(dynamicField);
        }

        public boolean isDynamicField() {
            return this.cbDynamic.isSelected();
        }
    }
}

