/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.PopupQueryTypeUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PopupF7QueryTree
extends KDDialog
implements KDPromptSelector {
    private static final long serialVersionUID = -2641793053008447576L;
    private KDTreeView kDTreeView1;
    private KDTree kDTree1;
    private KDWorkButton wbFilter;
    protected KDSeparator kDSeparator2;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    private HashMap mapFilter;
    private DefaultKingdeeTreeNode newRootOriSelected = null;
    private boolean isOk = false;
    String fullName = null;

    private PopupF7QueryTree() {
    }

    private PopupF7QueryTree(Frame owner) {
        super(owner, true);
        this.initDialog();
    }

    private PopupF7QueryTree(Dialog owner) {
        super(owner, true);
        this.initDialog();
    }

    public static PopupF7QueryTree getInstance() {
        Window owner = ComponentUtil.getCurrentActiveWindow();
        if (owner instanceof Dialog) {
            return new PopupF7QueryTree((Dialog)owner);
        }
        if (owner instanceof Frame || owner == null) {
            return new PopupF7QueryTree((Frame)owner);
        }
        return new PopupF7QueryTree((Frame)owner);
    }

    private void initDialog() {
        this.initCtrl();
        KDPanel panTemp = new KDPanel();
        this.initUIContentLayout(panTemp);
        this.installListener();
        this.initTree();
        this.setSize(panTemp.getWidth(), panTemp.getHeight());
        this.setLocationRelativeTo(null);
        this.setTitle(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label44"));
    }

    private void initCtrl() {
        this.kDTreeView1 = new KDTreeView();
        this.kDTreeView1.setMinimumSize(new Dimension(10, 10));
        this.kDTreeView1.setName("kDTreeView1");
        this.kDSeparator2 = new KDSeparator();
        this.kDSeparator2.setName("kDSeparator2");
        this.btnOk = new KDButton();
        this.btnOk.setName("kDButton1");
        this.btnOk.setText(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label42"));
        this.btnCancel = new KDButton();
        this.btnCancel.setName("kDButton2");
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label43"));
        this.wbFilter = new KDWorkButton((Icon)Resource.ICON_FILTER);
        this.wbFilter.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label45"));
        this.kDTreeView1.getControlPane().add((Component)this.wbFilter);
        this.kDTree1 = new KDTree();
        this.kDTree1.setName("kDTree1");
        this.kDTreeView1.setTree(this.kDTree1);
        this.mapFilter = new HashMap();
        this.mapFilter.put("name", "");
        this.mapFilter.put("alias", "");
        this.mapFilter.put("f7", "true");
    }

    private void initUIContentLayout(KDPanel panTemp) {
        panTemp.setBounds(new Rectangle(10, 10, 480, 520));
        panTemp.setLayout((LayoutManager)new KDLayout());
        panTemp.setOpaque(false);
        panTemp.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 480, 520));
        this.kDTreeView1.setBounds(new Rectangle(4, 4, 472, 473));
        panTemp.add((Component)this.kDTreeView1, (Object)new KDLayout.Constraints(4, 4, 472, 473, 418));
        this.kDSeparator2.setBounds(new Rectangle(-1, 483, 483, 10));
        panTemp.add((Component)this.kDSeparator2, (Object)new KDLayout.Constraints(-1, 483, 483, 10, 14));
        this.btnOk.setBounds(new Rectangle(319, 490, 73, 21));
        panTemp.add((Component)this.btnOk, (Object)new KDLayout.Constraints(319, 490, 73, 21, 10));
        this.btnCancel.setBounds(new Rectangle(401, 490, 73, 21));
        panTemp.add((Component)this.btnCancel, (Object)new KDLayout.Constraints(401, 490, 73, 21, 10));
        this.getContentPane().add((Component)panTemp, "Center");
    }

    private void installListener() {
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PopupF7QueryTree.this.kDTree1_mouseClicked(e);
            }
        });
        this.wbFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupF7QueryTree.this.btnFilter_actionPerformed();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupF7QueryTree.this.btnOk_actionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupF7QueryTree.this.btnCancel_actionPerformed();
            }
        });
    }

    private void initTree() {
        DefaultKingdeeTreeNode nodeRoot = CtrlDesignFinal.getF7QueryInfoRoot();
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(true);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setAutoscrolls(true);
        this.executeFilter();
    }

    private void kDTree1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.addQueryInfo();
        }
    }

    private void btnFilter_actionPerformed() {
        try {
            PopupQueryTypeUI typeUI = new PopupQueryTypeUI(this.mapFilter);
            ReportDialog.showDialog((CoreUIObject)typeUI, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label45"), true, false);
            if (typeUI.isOk()) {
                this.mapFilter = typeUI.getMapData();
                this.executeFilter();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeFilter() {
        FilterNode filterNode = FilterNode.getInstance();
        filterNode.setCondition(this.mapFilter);
        DefaultKingdeeTreeNode oldRoot = CtrlDesignFinal.getF7QueryInfoRoot();
        DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
        newRoot.setText(oldRoot.getText());
        newRoot.setCustomIcon(oldRoot.getCustomIcon());
        newRoot.setAllowsChildren(oldRoot.getAllowsChildren());
        newRoot.setUserObject(oldRoot.getUserObject());
        TreePath path = this.kDTree1.getSelectionPath();
        DefaultKingdeeTreeNode nodeOriSelected = null;
        String strOriSelected = null;
        if (path != null) {
            nodeOriSelected = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            IBriefViewTreeNode bvOriSelected = (IBriefViewTreeNode)nodeOriSelected.getUserObject();
            strOriSelected = bvOriSelected.getFullName();
        }
        this.newRootOriSelected = null;
        this.doFilter(oldRoot, newRoot, strOriSelected);
        ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)newRoot);
        this.kDTree1.setSelectionNode(this.newRootOriSelected);
    }

    private void doFilter(DefaultKingdeeTreeNode oldRoot, DefaultKingdeeTreeNode newRoot, String strOriSelected) {
        int nodeCount = oldRoot.getChildCount();
        for (int j = 0; j < nodeCount; ++j) {
            DefaultKingdeeTreeNode newNode;
            DefaultKingdeeTreeNode oldNode = (DefaultKingdeeTreeNode)oldRoot.getChildAt(j);
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)oldNode.getUserObject();
            if (bvNode.isPackage()) {
                newNode = new DefaultKingdeeTreeNode();
                newNode.setText(oldNode.getText());
                newNode.setCustomIcon(oldNode.getCustomIcon());
                newNode.setAllowsChildren(oldNode.getAllowsChildren());
                newNode.setUserObject(oldNode.getUserObject());
                newRoot.add((MutableTreeNode)newNode);
                if (bvNode.getFullName().equals(strOriSelected)) {
                    this.newRootOriSelected = newNode;
                }
                this.doFilter(oldNode, newNode, strOriSelected);
                continue;
            }
            if (FilterNode.getInstance().isHiden(bvNode)) continue;
            newNode = new DefaultKingdeeTreeNode();
            newNode.setText(oldNode.getText());
            newNode.setCustomIcon(oldNode.getCustomIcon());
            newNode.setAllowsChildren(oldNode.getAllowsChildren());
            newNode.setUserObject(oldNode.getUserObject());
            newRoot.add((MutableTreeNode)newNode);
            if (!bvNode.getFullName().equals(strOriSelected)) continue;
            this.newRootOriSelected = newNode;
        }
        if (newRoot.isLeaf() && !newRoot.isRoot()) {
            newRoot.removeFromParent();
        }
    }

    private void addQueryInfo() {
        this.fullName = null;
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
            if (bvNode.isPackage()) {
                return;
            }
            this.fullName = bvNode.getFullName();
            this.closeWin(true);
        }
    }

    private void btnOk_actionPerformed() {
        this.addQueryInfo();
    }

    private void btnCancel_actionPerformed() {
        this.closeWin(false);
    }

    private void closeWin(boolean flag) {
        this.isOk = flag;
        this.dispose();
    }

    public Object getData() {
        return this.fullName;
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    private static class FilterNode {
        String name;
        String alias;
        boolean f7;
        private static final FilterNode instance = new FilterNode();

        private FilterNode() {
        }

        public static final FilterNode getInstance() {
            return instance;
        }

        public void setCondition(HashMap mapFilter) {
            this.name = CtrlReportUtil.getObjectString(mapFilter.get("name")).toLowerCase();
            this.alias = CtrlReportUtil.getObjectString(mapFilter.get("alias")).toLowerCase();
            this.f7 = new Boolean(CtrlReportUtil.getObjectString(mapFilter.get("f7")));
        }

        public boolean isHiden(IBriefViewTreeNode bvNode) {
            String nodeName = CtrlReportUtil.getObjectString(bvNode.getName()).toLowerCase();
            String nodeAlias = CtrlReportUtil.getObjectString(bvNode.getAlias()).toLowerCase();
            if (this.name.length() > 0 && nodeName.indexOf(this.name) == -1) {
                return true;
            }
            if (this.alias.length() > 0 && nodeAlias.indexOf(this.alias) == -1) {
                return true;
            }
            return this.f7 && nodeName.indexOf("f7") == -1 && nodeAlias.indexOf("f7") == -1;
        }
    }
}

