/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.BlobBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractPreviewKSQLPanelUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.CurrentSQLUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.ReportCommonFilterUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PreviewKSQLPanelUI
extends AbstractPreviewKSQLPanelUI {
    private static final long serialVersionUID = -4330303623770370806L;
    private static final Logger logger = CoreUIObject.getLogger(PreviewKSQLPanelUI.class);
    private boolean isinitLayout = false;
    private String solutionID;
    private String parameterXmlString;
    private int shareType;
    private boolean isShowPreviewUI = true;
    private HashMap logMap = new HashMap();
    private static CtrlDesignQueryModel model = null;

    public PreviewKSQLPanelUI() throws Exception {
        model = DesignUI.getInstance().getModel();
        this.spnTop.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
        this.initLayout();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void btnSQL_actionPerformed(ActionEvent e) throws Exception {
        CurrentSQLUI ui = new CurrentSQLUI();
        ui.setLogMap(this.logMap);
        ReportDialog.showDialog((CoreUIObject)ui, MessageUtil.getMsgInfo("label257"), true);
    }

    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.preview(true, false);
    }

    protected void btnSettingArgs_actionPerformed(ActionEvent e) throws Exception {
        this.preview(false, false);
    }

    private boolean isContineSearch() throws Exception {
        boolean isContinue = true;
        String paramRelationFullName = CtrlReportUtil.getObjectString(model.getCommonQuery().getProperty(CtrlDesignUtil.ParamRelationFullName));
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        DefaultArgInput argUI = new DefaultArgInput(paramRelationFullName, sourceReportOrgID);
        argUI.createParametersUI(model.getCommonQuery().getParameters());
        ReportCommonFilterUI commonFilterUI = new ReportCommonFilterUI((JPanel)((Object)argUI), DesignUI.getInstance().getEditID(), this.solutionID, this.parameterXmlString, this.shareType);
        ReportDialog.showDialog((CoreUIObject)commonFilterUI, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label35"), true, false, SwingUtilities.getWindowAncestor((Component)((Object)this)));
        if (commonFilterUI.isOk()) {
            this.solutionID = commonFilterUI.getSolutionID();
            this.parameterXmlString = commonFilterUI.getParameterXmlString();
            this.shareType = commonFilterUI.getShareType();
        } else {
            isContinue = false;
        }
        return isContinue;
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    private void clearRows() {
        this.tblContent.removeColumns();
    }

    public static final int addResultSet(KDTable tblContent, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        PreviewKSQLPanelUI.setTaleHeader(tblContent, rs, model);
        return PreviewKSQLPanelUI.bindResultSet(tblContent, rs);
    }

    public boolean showFilterDialog() throws Exception {
        boolean isContinue = true;
        List lstParam = model.getCommonQuery().getParameters();
        if (null != lstParam && !lstParam.isEmpty()) {
            isContinue = this.isContineSearch();
        }
        return isContinue;
    }

    public boolean preview(boolean isRefresh, boolean isFromDesign) {
        try {
            SQLCustomType customType;
            if (!isRefresh && !this.showFilterDialog()) {
                if (isFromDesign) {
                    this.isShowPreviewUI = false;
                }
                return false;
            }
            HashMap mapNull = new HashMap();
            List currentList = model.getCommonQuery().getParameters();
            if (null != currentList) {
                for (DesignParameter pCurrent : currentList) {
                    String currentParamName = pCurrent.getName();
                    if (!pCurrent.isAllowNull()) continue;
                    mapNull.put(currentParamName, null);
                }
            }
            HashMap mapDesignParameter = RunReportParam.ChangWhereValueToMapParams(this.parameterXmlString);
            Iterator it = mapDesignParameter.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                DesignParameter pDesign = (DesignParameter)((Object)mapDesignParameter.get(name));
                boolean isAllowNull = true;
                if (!mapNull.containsKey(name)) {
                    isAllowNull = false;
                }
                pDesign.setAllowNull(isAllowNull);
            }
            InnerParam.putClientDefalutListParamsMap(mapDesignParameter);
            this.clearRows();
            int rowCount = this.getTopNumber();
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            IRowSet rs = null;
            try {
                HashMap mapResult = CtrlDesignDataExecutor.execute(null, model, mapDesignParameter, this.logMap, 0, rowCount, false, null);
                rs = (IRowSet)mapResult.get("6xx8xxRowset");
            }
            catch (CtrlReportException e) {
                if (isFromDesign) {
                    this.getUIContext().put("report_ui_error", e);
                } else {
                    MessageUtil.showDetailAndOK(null, e.getMessage(), e);
                }
                return false;
            }
            PreviewKSQLPanelUI.addResultSet(this.tblContent, (ResultSet)rs, model);
            HashMap mapRepeatName = new HashMap();
            ResultSetMetaData rsmd = rs.getMetaData();
            String repeatName = null;
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i + 1).toUpperCase();
                if (mapRepeatName.containsKey(name)) {
                    repeatName = name;
                    break;
                }
                mapRepeatName.put(name, null);
            }
            if ((customType = DesignUI.getInstance().getCustomType()).equals(SQLCustomType.PROCEDURE) || customType.equals(SQLCustomType.JAVA)) {
                OutputFieldsUI.setOutputColumns(model, (ResultSet)rs, false);
            } else {
                IQuery quer = model.getQuery();
                if (quer.getQueryType() == QueryType.SQL_CUSTOM) {
                    OutputFieldsUI.setOutputColumns(model, (ResultSet)rs, false);
                }
            }
            if (rs != null) {
                rs.close();
            }
            this.isTextErrVisible(false);
            if (repeatName != null) {
                String msg1 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label170");
                String msg2 = EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label171");
                String msg = msg1 + repeatName + msg2;
                this.lbMsg.setText(msg);
            }
        }
        catch (Exception e) {
            if (isFromDesign) {
                this.getUIContext().put("report_ui_error", CtrlReportException.makeException(MessageUtil.getMsgInfo("label186"), e));
            }
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label186"), e);
        }
        return true;
    }

    public static OutputColumns parseRSMD(ResultSetMetaData rsmd) throws SQLException {
        OutputColumns columns = new OutputColumns();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String name = rsmd.getColumnName(i + 1);
            DataType dt = DataType.fromJdbcType((int)rsmd.getColumnType(i + 1));
            Column oc = new Column();
            oc.setName(name);
            PreviewKSQLPanelUI.setDefMulLangMap((IDefObj)oc, "alias", name);
            oc.setDataType(dt);
            columns.add((Object)oc);
        }
        return columns;
    }

    public static final void setDefMulLangMap(IDefObj def, String keyName, String currentName) {
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int size = lc.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo li = lc.get(i);
            String localString = li.getLocaleString();
            ((DefObj)def).setProperty(keyName + "." + localString, (Object)currentName);
        }
        ((DefObj)def).setProperty(keyName, (Object)"#1");
    }

    public static final void setTaleHeader(KDTable table, ResultSet rs, CtrlDesignQueryModel model) throws Exception {
        int cols = rs.getMetaData().getColumnCount();
        table.removeColumns();
        table.addColumns(cols);
        HashMap oldNameAlisaMap = OutputFieldsUI.getNameAlisaMapFromModel(model);
        String[] colFields = new String[cols];
        IRow headRow = table.addHeadRow();
        for (int i = 0; i < cols; ++i) {
            String rowHeader = rs.getMetaData().getColumnName(i + 1);
            if (oldNameAlisaMap.containsKey(rowHeader.toUpperCase())) {
                Column oc = (Column)oldNameAlisaMap.get(rowHeader.toUpperCase());
                rowHeader = oc.getAlias();
            }
            headRow.getCell(i).setValue((Object)rowHeader);
            colFields[i] = rowHeader;
        }
        table.putBindContents("member", colFields);
        table.checkParsed();
    }

    public static final int bindResultSet(KDTable table, ResultSet rs) throws SQLException {
        int bindRow = 0;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int row = 0;
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            IRow irow = table.addRow();
            for (int col = 0; col < cols; ++col) {
                Object value = rs.getObject(col + 1);
                int type = rsmd.getColumnType(col + 1);
                if (type == 2004) {
                    value = BlobBO.readBlob(rs, col + 1);
                }
                value = RunReportParam.getOracleDateValue(value);
                table.getCell(row, col).setValue(value);
                map.put(rsmd.getColumnName(col + 1).toLowerCase(), value);
            }
            irow.setUserObject(map);
            ++row;
            ++bindRow;
        }
        return bindRow;
    }

    private void isTextErrVisible(boolean isShowErr) {
        this.kDScrollPane1.setVisible(isShowErr);
        this.tblContent.setVisible(!isShowErr);
    }

    public boolean isShowPreviewUI() {
        return this.isShowPreviewUI;
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }
}

