/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.IPopupSelector;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TableManager;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractProcedureNameSelectedUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProcedureNameSelectedUI
extends AbstractProcedureNameSelectedUI
implements IPopupSelector {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ProcedureNameSelectedUI.class);
    boolean isinitLayout = false;
    boolean isCanceled = false;
    ArrayList lstSelected = new ArrayList();
    int dbType = -1;
    private KDTSortManager sm = null;

    public ProcedureNameSelectedUI() throws Exception {
        this.table.checkParsed();
    }

    public ProcedureNameSelectedUI(int dbType) throws Exception {
        this();
        this.dbType = dbType;
    }

    public void onLoad() throws Exception {
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    protected void initTable() {
        this.lstSelected.clear();
        this.table.getSelectManager().setSelectMode(2);
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.table);
            this.sm.setSortAuto(true);
        }
        this.table.getColumn(0).setSortable(true);
        this.table.getColumn(1).setSortable(true);
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ProcedureNameSelectedUI.this.doTableClicked(e);
            }
        });
        try {
            String outDB = CtrlReportUtil.getObjectString(((CtrlDesignKsqlQuery)DesignUI.getInstance().getModel().getQuery()).getOutDB());
            ArrayList lst = KSQLReportBO.getUserProceList(outDB, this.dbType);
            this.table.removeRows();
            for (HashMap map : lst) {
                IRow irow = this.table.addRow();
                irow.getStyleAttributes().setLocked(true);
                irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("owner")));
                irow.getCell(1).setValue((Object)CtrlReportUtil.getObjectString(map.get("procedurename")).toLowerCase());
                irow.setUserObject((Object)map);
            }
        }
        catch (BOSException e1) {
            logger.debug((Object)e1);
        }
    }

    protected void doTableClicked(KDTMouseEvent e) {
        try {
            if (e.getClickCount() == 2 && e.getType() == 1) {
                this.btnConfirm_actionPerformed(null);
            }
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.table);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        for (int i = 0; i < lstIndex.size(); ++i) {
            int rowIndex = Integer.parseInt(lstIndex.get(i).toString());
            Object obj = this.table.getRow(rowIndex).getUserObject();
            this.lstSelected.add(obj);
        }
        this.isCanceled = false;
        this.closeWin();
    }

    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.closeWin();
    }

    protected void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public Component getComponentSelector() {
        return this;
    }

    public Object getData() {
        Iterator it = this.lstSelected.iterator();
        if (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            return CtrlReportUtil.getObjectString(map.get("procedurename"));
        }
        return null;
    }

    public int getHeightSelector() {
        return this.getHeight();
    }

    public KDToolBar getToolBarSelector() {
        return null;
    }

    public int getWidthSelector() {
        return this.getWidth();
    }

    public void initLayoutSelector() {
        this.initLayout();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void onLoadSelector() throws Exception {
        this.onLoad();
    }

    public void showSelector() {
        this.initTable();
    }

    public void setParamMap(HashMap paramMap) {
    }
}

