/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.wizard.common.CustomTextEditor;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class SqlUI
extends BaseTabUIImp {
    private static SqlUI sqlUI = null;
    private static CtrlDesignQueryModel model = null;
    private ContentPane contentPane = new ContentPane();

    private SqlUI() {
        this.contentPane.addUpdateSQLListener(new UpdateSQLHandler());
    }

    public static final SqlUI getInstance() {
        if (sqlUI == null) {
            model = DesignUI.getInstance().getModel();
            sqlUI = new SqlUI();
        }
        return sqlUI;
    }

    public static final void destroy() {
        sqlUI = null;
    }

    public static void refreshFromModel(boolean isRefreshFromModel) {
        if (sqlUI != null) {
            sqlUI.setRefreshFromModel(isRefreshFromModel);
        }
    }

    public KDPanel getPanel() {
        return this.contentPane;
    }

    public void syncUi2Model() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
        ksqlQuery.setRegular(!this.contentPane.isCustom());
        ksqlQuery.setDistinct(this.contentPane.isDistinct());
        if (this.contentPane.isCustom()) {
            ksqlQuery.setContent(this.contentPane.getEditorData());
        }
    }

    public boolean isSqlCustom() {
        return this.contentPane.isCustom();
    }

    public void syncModel2Ui() {
        if (DesignUI.getInstance().isNoFoundQuery()) {
            this.contentPane.showValue(model.getQuery());
            return;
        }
        try {
            this.updateSQL();
        }
        catch (BOSException e) {
            MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label258") + "\r\n" + e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.contentPane.showValue(model.getQuery());
    }

    private void updateSQL() throws BOSException {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
        if (ksqlQuery.isRegular()) {
            String sql = CtrlDesignQueryModel.makeSQL(model);
            model.getQuery().setContent(sql);
        }
    }

    static class ContentPane
    extends KDPanel {
        private static final long serialVersionUID = -9018141010951919050L;
        private ResultEditor editor;
        private KDCheckBox chkCustom;
        private KDCheckBox chkDistinct;
        private KDPanel panCard;
        private CardLayout cardLayout;

        public ContentPane() {
            this.init();
            this.installListener();
        }

        private void init() {
            this.setOpaque(false);
            this.chkCustom = new KDCheckBox(QueryResource.getString((String)"res_7"));
            this.chkDistinct = new KDCheckBox(QueryResource.getString((String)"res_9"));
            this.cardLayout = new CardLayout();
            this.panCard = new KDPanel((LayoutManager)this.cardLayout);
            this.panCard.setOpaque(false);
            this.panCard.add((Component)this.chkDistinct, (Object)"wizard");
            this.editor = new ResultEditor((JTextComponent)new ScriptQLStyledEditor());
            this.editor.getWizardButton().setVisible(false);
            this.editor.addButton((JComponent)this.panCard);
            TableLayout tl = TableLayout.splitRow((int)2);
            tl.defaultStyle().setHeight(20);
            tl.rowStyle(0).setPriY(1);
            KDPanel bottomPanel = new KDPanel();
            bottomPanel.setLayout((LayoutManager)new FlowLayout(0, 0, 0));
            bottomPanel.add((Component)this.chkCustom);
            bottomPanel.add((Component)new KDLabel("   "));
            this.setLayout((LayoutManager)tl);
            this.add((Component)((Object)this.editor), tl.cell(0));
            this.add((Component)bottomPanel, tl.cell(1));
            this.syncSelfDef(false);
        }

        private void installListener() {
            this.chkDistinct.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ContentPane.this.chkDistinct.isSelected()) {
                        ContentPane.this.addDistinct();
                    } else {
                        ContentPane.this.removeDistinct();
                    }
                }
            });
            this.chkCustom.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!ContentPane.this.chkCustom.isSelected()) {
                        if (WindowUtil.msgboxYesNo((Component)((Object)ContentPane.this), (Object)QueryResource.getString((String)"res_11"), (String)QueryResource.getString((String)"res_7"))) {
                            CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
                            ksqlQuery.setRegular(true);
                            ContentPane.this.editor.setContent(ContentPane.this.fireUpdateSQLEvent());
                        } else {
                            ContentPane.this.chkCustom.setSelected(true);
                        }
                        if (ContentPane.this.chkDistinct.isSelected()) {
                            ContentPane.this.addDistinct();
                        } else {
                            ContentPane.this.removeDistinct();
                        }
                    }
                    ContentPane.this.syncSelfDef(ContentPane.this.chkCustom.isSelected());
                }
            });
        }

        private void addDistinct() {
            String sql = this.editor.getContent();
            if (sql.indexOf("SELECT") != 0) {
                return;
            }
            sql = "SELECT DISTINCT" + sql.substring(6);
            this.editor.setContent(sql);
        }

        private void removeDistinct() {
            String sql = this.editor.getContent();
            sql = sql.replaceFirst("DISTINCT", "");
            this.editor.setContent(sql);
        }

        private void syncSelfDef(boolean isSelfDef) {
            if (isSelfDef) {
                this.cardLayout.show((Container)this.panCard, "custom");
            } else {
                this.cardLayout.show((Container)this.panCard, "wizard");
            }
            this.editor.setResultEditable(isSelfDef);
        }

        public void setEditorData(String content) {
            this.editor.setContent(content);
        }

        public String getEditorData() {
            return this.editor.getContent();
        }

        public void showValue(IQuery query) {
            this.editor.setContent(query.getContent());
            this.chkDistinct.setSelected(query.isDistinct());
            this.chkCustom.setSelected(query.getQueryType() == QueryType.SQL_CUSTOM);
            this.syncSelfDef(this.chkCustom.isSelected());
        }

        public boolean isDistinct() {
            return this.chkDistinct.isSelected();
        }

        public boolean isCustom() {
            return this.chkCustom.isSelected();
        }

        public void addUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.add(UpdateSQLListener.class, l);
        }

        public void removeUpdateSQLListener(UpdateSQLListener l) {
            this.listenerList.remove(UpdateSQLListener.class, l);
        }

        protected String fireUpdateSQLEvent() {
            UpdateSQLEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != UpdateSQLListener.class) continue;
                if (event == null) {
                    event = new UpdateSQLEvent((Object)this);
                }
                return ((UpdateSQLListener)listeners[i + 1]).update(event);
            }
            return "";
        }

        public class UpdateSQLEvent
        extends EventObject {
            private static final long serialVersionUID = 8383157176869550273L;

            public UpdateSQLEvent(Object source) {
                super(source);
            }
        }

        public static interface UpdateSQLListener
        extends EventListener {
            public String update(UpdateSQLEvent var1);
        }

        private class ResultEditor
        extends CustomTextEditor {
            private static final long serialVersionUID = -8296250629667563404L;

            public ResultEditor(JTextComponent txtComp) {
                super(txtComp);
                this.setTitle("SQL:");
            }

            public ResultEditor() {
                this.setTitle("SQL:");
            }

            public FormulaWizardEditor getFormulaEditor() {
                return this.formula;
            }
        }
    }

    private class UpdateSQLHandler
    implements ContentPane.UpdateSQLListener {
        private UpdateSQLHandler() {
        }

        public String update(ContentPane.UpdateSQLEvent event) {
            try {
                return CtrlDesignQueryModel.makeSQL(model);
            }
            catch (BOSException e) {
                MessageUtil.showDetailAndOK(null, MessageUtil.getMsgInfo("label258") + "\r\n" + e.getMessage(), (Exception)((Object)e));
                return "";
            }
        }
    }
}

