/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.dispatch;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputCtrlImpl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DispatchF7ParamPicker
extends CoreUI
implements KDPromptSelector,
DataChangeListener {
    private KDRadioButton sysSelectButton;
    private KDRadioButton valSelectButton;
    private KDBizPromptBox sysPromptBox;
    private KDBizPromptBox valPromptBox;
    private KDButtonGroup buttonGroup;
    private KDButton enterBtn;
    private KDButton cancleBtn;
    private boolean isCancle = true;
    private ReportDialog dialog;
    private Logger logger = Logger.getLogger(DispatchF7ParamPicker.class);

    public DispatchF7ParamPicker(DesignParameter p, String sourceReportOrgID, ExecutionContext exeCtx) throws Exception {
        this.valPromptBox = DefaultArgInput.getPromptBoxCtrl(p, (KDPanel)this, sourceReportOrgID, exeCtx);
        InputCtrlImpl inputCtrl = (InputCtrlImpl)p.getInputCtrl();
        int sourceDefaultF7Type = inputCtrl.getDefaultF7Type();
        inputCtrl.setDefaultF7Type(1);
        this.sysPromptBox = DefaultArgInput.getPromptBoxCtrl(p, (KDPanel)this, sourceReportOrgID, exeCtx, 2);
        inputCtrl.setDefaultF7Type(sourceDefaultF7Type);
        this.init();
    }

    private void init() {
        this.buttonGroup = new KDButtonGroup();
        this.sysSelectButton = new KDRadioButton("\u4f7f\u7528\u7cfb\u7edf\u53d8\u91cf");
        this.valSelectButton = new KDRadioButton("\u4f7f\u7528F7\u53d6\u503c");
        this.enterBtn = new KDButton("\u786e\u5b9a");
        this.cancleBtn = new KDButton("\u53d6\u6d88");
        this.buttonGroup.add((AbstractButton)this.sysSelectButton);
        this.buttonGroup.add((AbstractButton)this.valSelectButton);
        this.sysSelectButton.setSelected(true);
        this.valPromptBox.setEnabled(false);
    }

    public void initLayout() {
        TableLayout2 layout = new TableLayout2(5, 6);
        layout.setFixedHeight(1, 20);
        layout.setFixedHeight(2, 20);
        layout.setRowSpacing(1, 30);
        layout.setRatableHeight(new int[]{0, 3, 4}, 20);
        layout.setFixedHeight(4, 30);
        layout.setFixedWidth(new int[]{0, 5}, 13);
        layout.setFixedWidth(1, 100);
        layout.setFixedWidth(2, 25);
        layout.setFixedWidth(3, 70);
        layout.setFixedWidth(4, 70);
        layout.setColSpacing(3, 10);
        this.setLayout((LayoutManager)layout);
        this.setSize(300, 200);
        this.add((Component)this.sysSelectButton, TableLayout2.param((int)1, (int)1));
        this.add((Component)this.valSelectButton, TableLayout2.param((int)2, (int)1));
        this.add((Component)this.sysPromptBox, TableLayout2.param((int)1, (int)2, (int)1, (int)4));
        this.add((Component)this.valPromptBox, TableLayout2.param((int)2, (int)2, (int)2, (int)4));
        this.add((Component)this.enterBtn, TableLayout2.param((int)4, (int)3));
        this.add((Component)this.cancleBtn, TableLayout2.param((int)4, (int)4));
    }

    public void initListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == DispatchF7ParamPicker.this.enterBtn) {
                    DispatchF7ParamPicker.this.action_EnterBtn();
                } else if (source == DispatchF7ParamPicker.this.cancleBtn) {
                    DispatchF7ParamPicker.this.action_CancleBtn();
                } else if (source == DispatchF7ParamPicker.this.sysSelectButton) {
                    DispatchF7ParamPicker.this.action_sysSelectBtn();
                } else if (source == DispatchF7ParamPicker.this.valSelectButton) {
                    DispatchF7ParamPicker.this.action_valSelectBtn();
                }
            }
        };
        this.enterBtn.addActionListener(listener);
        this.cancleBtn.addActionListener(listener);
        this.sysSelectButton.addActionListener(listener);
        this.valSelectButton.addActionListener(listener);
    }

    private void action_EnterBtn() {
        this.isCancle = false;
        this.closeWin();
    }

    private void action_CancleBtn() {
        this.isCancle = true;
        this.closeWin();
    }

    private void action_sysSelectBtn() {
        this.switchValueSelector(true);
    }

    private void action_valSelectBtn() {
        this.switchValueSelector(false);
    }

    private void switchValueSelector(boolean isSys) {
        this.sysPromptBox.setEnabled(isSys);
        this.valPromptBox.setEnabled(!isSys);
    }

    public Object getData() {
        return this.sysSelectButton.isSelected() ? this.sysPromptBox.getData() : this.valPromptBox.getData();
    }

    public boolean isCanceled() {
        return this.isCancle;
    }

    public void show() {
        if (this.dialog == null) {
            try {
                ReportDialog.showDialog((CoreUIObject)this, "\u8bbe\u7f6eF7\u53c2\u6570", true);
            }
            catch (Exception e) {
                this.logger.error((Object)"F7\u9009\u62e9\u5668\u521b\u5efa\u5931\u8d25", (Throwable)e);
            }
        } else {
            this.dialog.setVisible(true);
        }
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public void dataChanged(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue instanceof DefObj[]) {
            DefObj[] valueArray = (DefObj[])newValue;
            if (valueArray.length == 0) {
                return;
            }
            DefObj aValue = valueArray[0];
            if (null != aValue) {
                boolean isSysParamter = aValue.getName().startsWith("@Ext");
                this.sysSelectButton.setSelected(isSysParamter);
                this.valSelectButton.setSelected(!isSysParamter);
                if (isSysParamter) {
                    this.action_sysSelectBtn();
                    this.sysPromptBox.setData(newValue);
                } else {
                    this.action_valSelectBtn();
                    this.valPromptBox.setData(newValue);
                }
            }
        }
    }
}

