/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.code.AInputStream;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.CustKSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.common.EASBizException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class CtrlDesignInputStream
extends AInputStream {
    private static Logger log = LogUtil.getPackageLogger(CtrlDesignInputStream.class);
    private String fid;
    private String systemid;
    private String dbsourcename;
    private String orgid;
    private Context ctx;
    private boolean isFound = true;
    KSQLReportInfo info;
    byte[] dataModel;
    private boolean isSys = true;

    public CtrlDesignInputStream(String fid, boolean isSys) {
        this.fid = fid;
        this.isSys = isSys;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Context ctx, String systemid, String dbsourcename, String orgid, String fid, boolean isSys) {
        this.ctx = ctx;
        this.systemid = systemid;
        this.dbsourcename = dbsourcename;
        this.orgid = orgid;
        this.fid = fid;
        this.isSys = isSys;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Context ctx, byte[] data, boolean isSys) {
        this.ctx = ctx;
        this.dataModel = data;
        this.isSys = isSys;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public void reset() throws IOException {
        byte[] data = null;
        if (null != this.dataModel) {
            data = this.dataModel;
        } else {
            try {
                CustKSQLReportInfo custInfo = null;
                if (this.isSys && (null == this.systemid || this.systemid.equals(""))) {
                    this.info = KSQLReportBO.getKSQLReportInfo(this.ctx, this.fid, this.orgid);
                } else if (this.isSys) {
                    this.info = KSQLReportBO.getKSQLReportInfo(this.ctx, this.systemid, this.dbsourcename, this.orgid, this.fid);
                } else {
                    try {
                        custInfo = CustKSQLReportFactory.getRemoteInstance().getCustKSQLReportInfo((IObjectPK)new ObjectUuidPK(this.fid));
                    }
                    catch (EASBizException e) {
                        this.isFound = false;
                        log.error((Object)e);
                    }
                }
                if (this.isSys && this.info == null) {
                    this.isFound = false;
                    return;
                }
                if (!this.isSys && custInfo == null) {
                    this.isFound = false;
                    return;
                }
                data = this.isSys ? this.info.getContent() : custInfo.getContent();
            }
            catch (BOSException e) {
                this.isFound = false;
                log.error((Object)e);
            }
        }
        this.setProvider(new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInputObject(CtrlDesignQueryModel model) {
        Element xml = null;
        try {
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
        }
        catch (Exception exception) {
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        CtrlDesignUtil.toObject(model, xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlString() {
        Element xml = null;
        try {
            String xmlstr;
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
            XMLOutputter outter = new XMLOutputter("\t", true, "UTF-8");
            String string = xmlstr = outter.outputString(xml);
            return string;
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        return null;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public void setOrgid(String orgid) {
        this.orgid = orgid;
    }
}

