/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.ExtLicenseException;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.ILicenseSrv;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class LicenseService
implements ILicenseSrv {
    private Logger _logger = Logger.getLogger(LicenseService.class);
    private ILicenseSrvAgent _agent = LicenseSrvAgent.getLocalInstance();
    private String _className;
    private Context _ctx;

    public LicenseService() throws LicenseException {
    }

    public LicenseService(Context ctx) throws LicenseException {
        this._ctx = ctx;
    }

    public LicenseService getInstance(Context ctx) throws LicenseException {
        return new LicenseService(ctx);
    }

    public void releaseLicense() throws ExtLicenseException {
        try {
            this._agent.releaseLicense(this._ctx.getContextID(), this._className);
        }
        catch (LicenseException e) {
            this._logger.error((Object)("\u8c03\u7528\u7cfb\u7edf\u5e95\u5c42License\u670d\u52a1\u8fdb\u884crelease\u64cd\u4f5c\u5931\u8d25(\u5176\u4e2dctx:" + this._ctx.getContextID() + ";\u6a21\u677f\u540d\u79f0\uff1a" + this._className + ")"));
            throw new ExtLicenseException(e.getMessage());
        }
    }

    public LicenseUserInfo getLicenseUserInfo() {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(this._ctx.getContextID());
        info.setUserID(this._ctx.getCaller().toString());
        info.setUserIP(this._ctx.getClientHostIP());
        info.setUserLoginAis(this._ctx.getAIS());
        info.setUserName(this._ctx.getUserName());
        info.setUserLoginTime(new Date());
        info.setUserCompany(ContextUtil.getCurrentOrgUnit((Context)this._ctx).getName());
        return info;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void checkLicense() throws ExtLicenseException {
        int flag = 4;
        try {
            flag = this._agent.requestLicense(this.getLicenseUserInfo(), this._className);
        }
        catch (LicenseException e) {
            this._logger.error((Object)("\u8c03\u7528\u7cfb\u7edf\u5e95\u5c42License\u670d\u52a1\u8fdb\u884ccheck\u64cd\u4f5c\u5931\u8d25(\u5176\u4e2dctx:" + this._ctx.getContextID() + ";\u6a21\u677f\u540d\u79f0\uff1a" + this._className + ")"));
            throw new ExtLicenseException(e.getMessage());
        }
        switch (flag) {
            case 4: {
                throw new ExtLicenseException("\u6ca1\u6709License\u8bbf\u95ee\u8be5\u8d44\u6e90");
            }
            case 2: {
                throw new ExtLicenseException("\u6ca1\u6709License\u8bbf\u95ee\u8be5\u8d44\u6e90");
            }
        }
    }

    public void setContext(Context ctx) {
        this._ctx = ctx;
    }
}

