/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.IOrderList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.semantic.common.client.ClientUtil;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticDataType;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ParseFilter;
import java.util.HashSet;
import java.util.Set;

public class Semantic2Model {
    private static final String MAPPINGID = "mappingId";

    public static void trans(SemanticUsetimeModel semanticModel, AbstractSemanticEntity[] metas, CtrlDesignQueryModel model) {
        String pName;
        AbstractSemanticEntity entity;
        int i;
        ITableList tables = model.getQuery().getTables();
        tables.clear();
        IJoinList joins = model.getQuery().getJoins();
        joins.clear();
        IColumnList columns = model.getQuery().getColumns();
        columns.clear();
        if (semanticModel == null) {
            model.getCommonQuery().setSemanticModel(new SemanticUsetimeModel(null));
            return;
        }
        HashSet repeatFieldsName = new HashSet();
        HashSet repeatFieldsAlias = new HashSet();
        Semantic2Model.searchRepeatedFieldName(metas, repeatFieldsName, repeatFieldsAlias);
        model.getCommonQuery().setSemanticModel(semanticModel);
        AbstractSemanticEntity[] entities = semanticModel.getEntities();
        HashSet<String> repeatedTableName = new HashSet<String>();
        HashSet<String> nameExist = new HashSet<String>();
        for (i = 0; i < entities.length; ++i) {
            entity = entities[i];
            pName = entity.getPhysicalName();
            if (nameExist.contains(pName)) {
                repeatedTableName.add(pName);
                continue;
            }
            nameExist.add(pName);
        }
        int idx = 1;
        for (i = 0; i < entities.length; ++i) {
            Column col;
            int j;
            entity = entities[i];
            pName = entity.getPhysicalName();
            String tableName = repeatedTableName.contains(pName) ? "T" + idx++ : pName;
            String tableAlias = entity.getLogicalName();
            Table table = new Table(tableName, tableAlias);
            table.setExpr(pName);
            tables.add((Object)table);
            String id = UID.create16();
            entity.setProperty(MAPPINGID, (Object)id);
            table.setProperty(MAPPINGID, (Object)id);
            int c = entity.getFieldCount();
            for (j = 0; j < c; ++j) {
                SemanticField field = entity.getField(j);
                col = Semantic2Model.createColumn((AbstractSemanticField)field, repeatFieldsName, repeatFieldsAlias, tableName, tableAlias);
                col.setExpr(Semantic2Model.connectWithDot(tableName, field.getPhysicalName()));
                columns.add((Object)col);
            }
            c = entity.getExprFieldCount();
            for (j = 0; j < c; ++j) {
                SemanticExprField expr = entity.getExprField(j);
                col = Semantic2Model.createColumn((AbstractSemanticField)expr, repeatFieldsName, repeatFieldsAlias, tableName, tableAlias);
                col.setExpr(expr.getExpr());
                columns.add((Object)col);
            }
        }
    }

    private static Column createColumn(AbstractSemanticField field, Set repeatFieldsName, Set repeatFieldsAlias, String tableName, String tableAlias) {
        String fieldName = field.getPhysicalName();
        String checkingName = fieldName = ClientUtil.cutLangPostfix((String)fieldName);
        int idx = 1;
        while (repeatFieldsName.contains(checkingName)) {
            checkingName = fieldName + idx++;
        }
        repeatFieldsName.add(checkingName);
        String filedAlias = field.getLogicalName();
        if (repeatFieldsAlias.contains(filedAlias)) {
            filedAlias = Semantic2Model.connectWithDot(tableAlias, filedAlias);
            idx = 1;
            String checkingAlias = filedAlias;
            while (repeatFieldsAlias.contains(checkingAlias)) {
                checkingAlias = filedAlias + idx++;
            }
            repeatFieldsAlias.add(checkingAlias);
            filedAlias = checkingAlias;
        }
        Column col = new Column();
        col.setDataType(Semantic2Model.transDataType(field.getDataType()));
        col.setName(checkingName);
        col.setAlias(filedAlias);
        return col;
    }

    private static void searchRepeatedFieldName(AbstractSemanticEntity[] metas, Set pNames, Set lNames) {
        HashSet<String> forLName = new HashSet<String>();
        for (int i = 0; i < metas.length; ++i) {
            String lName;
            int j;
            AbstractSemanticEntity entity = metas[i];
            int c = entity.getFieldCount();
            for (j = 0; j < c; ++j) {
                SemanticField field = entity.getField(j);
                lName = field.getLogicalName();
                if (forLName.contains(lName)) {
                    lNames.add(lName);
                    continue;
                }
                forLName.add(lName);
            }
            c = entity.getExprFieldCount();
            for (j = 0; j < c; ++j) {
                SemanticExprField expr = entity.getExprField(j);
                lName = expr.getLogicalName();
                if (forLName.contains(lName)) {
                    lNames.add(lName);
                    continue;
                }
                forLName.add(lName);
            }
        }
    }

    private static String connectWithDot(String a, String b) {
        StringBuffer sb = new StringBuffer();
        sb.append(a);
        sb.append(".");
        sb.append(b);
        return sb.toString();
    }

    private static DataType transDataType(SemanticDataType semanticType) {
        if (semanticType == SemanticDataType.INT) {
            return DataType.INTEGER;
        }
        if (semanticType == SemanticDataType.DECIMAL) {
            return DataType.DECIMAL;
        }
        if (semanticType == SemanticDataType.DATETIME || semanticType == SemanticDataType.DATE || semanticType == SemanticDataType.TIME) {
            return DataType.DATETIME;
        }
        if (semanticType == SemanticDataType.BLOB) {
            return DataType.BLOB;
        }
        if (semanticType == SemanticDataType.CLOB || semanticType == SemanticDataType.NCLOB) {
            return DataType.CLOB;
        }
        if (semanticType == SemanticDataType.BINARY || semanticType == SemanticDataType.VARBINARY) {
            return DataType.BINARY;
        }
        if (semanticType == SemanticDataType.CHAR || semanticType == SemanticDataType.NCHAR || semanticType == SemanticDataType.VARCHAR || semanticType == SemanticDataType.NVARCHAR) {
            return DataType.STRING;
        }
        if (semanticType == SemanticDataType.Unsure) {
            return DataType.NULL;
        }
        throw new IllegalArgumentException("Unknow");
    }

    public static class SemanticSqlMaker {
        public static String makeQuery(IQuery qry, SemanticUsetimeModel semanticModel) {
            if (qry.getQueryType() == QueryType.SQL_CUSTOM) {
                return qry.getContent();
            }
            StringBuffer sql = new StringBuffer();
            if (semanticModel.getEntityCount() == 0) {
                return "";
            }
            sql.append("SELECT");
            if (qry.isDistinct()) {
                sql.append(" DISTINCT");
            }
            sql.append(SemanticSqlMaker.makeSelect(qry.getColumns()));
            sql.append(StringUtil.RETURN);
            sql.append("FROM ");
            sql.append(SemanticSqlMaker.makeFrom(semanticModel, qry.getTables()));
            String s = SemanticSqlMaker.makeWhere(qry.getFilter());
            if (!StringUtil.isEmptyString((String)s)) {
                sql.append(StringUtil.RETURN);
                sql.append(StringUtil.RETURN);
                sql.append("WHERE ");
                sql.append(s);
            }
            if (!StringUtil.isEmptyString((String)(s = SemanticSqlMaker.makeOrderBy(qry.getOrders())))) {
                sql.append(StringUtil.RETURN);
                sql.append("ORDER BY");
                sql.append(s);
            }
            return sql.toString();
        }

        private static String makeSelect(IColumnList cols) {
            int z = cols.size();
            if (z == 0) {
                return StringUtil.RETURN + " *";
            }
            StringBuffer select = new StringBuffer();
            for (int i = 0; i < z; ++i) {
                if (i > 0) {
                    select.append(",");
                }
                select.append(StringUtil.RETURN);
                select.append(" ");
                select.append(SemanticSqlMaker.makeSelectColumn((Column)cols.get(i)));
            }
            return select.toString();
        }

        private static String makeSelectColumn(Column col) {
            StringBuffer sb = new StringBuffer();
            sb.append(col.getExpr());
            sb.append(" AS ");
            sb.append('\"');
            sb.append(col.getName());
            sb.append('\"');
            return sb.toString();
        }

        private static String makeFrom(SemanticUsetimeModel semanticModel, ITableList tables) {
            StringBuffer sb = new StringBuffer();
            AbstractSemanticEntity rootEntity = semanticModel.getRootEntity();
            if (rootEntity.getRelationsCount() == 0) {
                sb.append(SemanticSqlMaker.getEntityString(rootEntity, tables));
            } else {
                SemanticSqlMaker.makeFromRecursion(rootEntity, sb, tables);
            }
            return sb.toString();
        }

        private static void makeFromRecursion(AbstractSemanticEntity entity, StringBuffer sb, ITableList tables) {
            int c = entity.getRelationsCount();
            for (int i = 0; i < c; ++i) {
                SemanticRelation relation = entity.getRelation(i);
                if (sb.length() == 0) {
                    sb.append(SemanticSqlMaker.getEntityString(relation.getClient(), tables));
                }
                sb.append(StringUtil.RETURN);
                sb.append(SemanticSqlMaker.transJoinType(relation.getJoinType()));
                sb.append(" ");
                sb.append(SemanticSqlMaker.getEntityString(relation.getSupplier(), tables));
                int conditionCount = relation.getConditionCount();
                if (conditionCount > 0) {
                    sb.append(StringUtil.RETURN);
                    sb.append(" ON ");
                    if (relation.isCustomExpr()) {
                        sb.append(((SemanticRelation.CustomExpr)relation.getCondition(0)).getExpr());
                    } else {
                        String parentTableName = SemanticSqlMaker.getMappingTable(tables, relation.getClient()).getName();
                        String childTableName = SemanticSqlMaker.getMappingTable(tables, relation.getSupplier()).getName();
                        for (int j = 0; j < conditionCount; ++j) {
                            if (j > 0) {
                                sb.append(" AND ");
                            }
                            SemanticRelation.JoinLine line = (SemanticRelation.JoinLine)relation.getCondition(j);
                            sb.append(parentTableName);
                            sb.append(".");
                            sb.append(line.getClientField());
                            sb.append(" = ");
                            sb.append(childTableName);
                            sb.append(".");
                            sb.append(line.getSupplierField());
                        }
                    }
                }
                SemanticSqlMaker.makeFromRecursion(relation.getSupplier(), sb, tables);
            }
        }

        private static String getEntityString(AbstractSemanticEntity entity, ITableList tables) {
            if (entity instanceof SemanticView) {
                SemanticView view = (SemanticView)entity;
                if (view.isDbView()) {
                    return view.getPhysicalName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                sb.append(view.getSQL());
                sb.append(")");
                sb.append(" AS ");
                sb.append(view.getPhysicalName());
                return sb.toString();
            }
            Table t = SemanticSqlMaker.getMappingTable(tables, entity);
            if (StringUtil.equals((String)t.getName(), (String)t.getExpr())) {
                return entity.getPhysicalName();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(t.getExpr());
            sb.append(" AS ");
            sb.append(t.getName());
            return sb.toString();
        }

        private static Table getMappingTable(ITableList list, AbstractSemanticEntity entity) {
            String id = (String)entity.getProperty(Semantic2Model.MAPPINGID);
            for (int i = list.size() - 1; i >= 0; --i) {
                Table t = (Table)list.get(i);
                if (!StringUtil.equals((String)id, (String)((String)t.getProperty(Semantic2Model.MAPPINGID)))) continue;
                return t;
            }
            throw new RuntimeException("Imposible");
        }

        private static String transJoinType(SemanticRelation.JoinType semanticType) {
            if (semanticType == SemanticRelation.JoinType.INNER) {
                return "INNER JOIN";
            }
            if (semanticType == SemanticRelation.JoinType.LEFT) {
                return "LEFT JOIN";
            }
            if (semanticType == SemanticRelation.JoinType.RIGHT) {
                return "RIGHT JOIN";
            }
            if (semanticType == SemanticRelation.JoinType.FULL) {
                return "FULL JOIN";
            }
            throw new IllegalArgumentException("Unknow");
        }

        private static String makeWhere(Condition cnd) {
            if (cnd == null) {
                return null;
            }
            CtrlDesignCondition cdcnd = (CtrlDesignCondition)cnd;
            if (null != cdcnd.getDynamicExpr()) {
                String de = cdcnd.getDynamicExpr();
                cdcnd.setDynamicExpr(null);
                return de;
            }
            String whereString = ParseFilter.getWhereString((DesignedFilterList)cdcnd.getExtObj());
            return whereString;
        }

        private static String makeOrderBy(IOrderList ords) {
            int z = ords.size();
            if (z == 0) {
                return null;
            }
            StringBuffer select = new StringBuffer();
            for (int i = 0; i < z; ++i) {
                if (i > 0) {
                    select.append(", ");
                }
                select.append(StringUtil.RETURN);
                select.append(" ");
                select.append(SemanticSqlMaker.makeOrderColumn((Order)ords.get(i)));
            }
            return select.toString();
        }

        private static String makeOrderColumn(Order ord) {
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            sb.append(ord.getExpr());
            sb.append('\"');
            sb.append(ord.isAscending() ? " ASC" : " DESC");
            return sb.toString();
        }
    }
}

