/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.arg.component;

import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.DesignParamUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.SystemVarType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.ArgInputComponentFactory;
import com.kingdee.eas.common.client.SysContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KDComboBoxCreator {
    public static KDComboBox getComboBoxCtrl(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx) throws Exception {
        KDComboBox kDComboBox = new KDComboBox();
        boolean isNeedAddSysParameter = runtimeType != 0;
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (null == inputCtrl) {
            return kDComboBox;
        }
        ArgInputComponentFactory.setCommonProperties((IKDTextComponent)kDComboBox, p);
        int bind = inputCtrl.getDataBind();
        if (bind == 0) {
            KDComboBoxCreator.getComboBoxCtrl_INTDB(kDComboBox, inputCtrl, sourceReportOrgID, exeCtx);
        } else if (bind == 6) {
            KDComboBoxCreator.getComboBoxCtrl_INTSYSTEM(kDComboBox, inputCtrl);
        } else if (bind == 1) {
            Iterator itemDataIter = inputCtrl.getSelfList().iterator();
            KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, null, null);
        }
        if (p.getDefaultValue() != null) {
            int size = kDComboBox.getItemCount();
            String defaultValue = ArgInputComponentFactory.pertreateParameter(p.getDefaultValue(), runtimeType);
            for (int i = 0; i < size; ++i) {
                DefObj defObj = (DefObj)kDComboBox.getItemAt(i);
                if (!defObj.getName().equals(defaultValue)) continue;
                kDComboBox.setSelectedItem((Object)defObj);
                break;
            }
        }
        if (isNeedAddSysParameter) {
            DesignParamUI.addSystemParameter(p, kDComboBox, p.getInputType() == InputType.LIST);
        }
        return kDComboBox;
    }

    private static final void getComboBoxCtrl_INTSYSTEM(KDComboBox kDComboBox, IInputCtrl inputCtrl) {
        String displayKey = inputCtrl.getDefDisplay().getName();
        String valueKey = inputCtrl.getDefValue().getName();
        DefObj def = inputCtrl.getDefDbsource();
        String systemVarType = def.getName();
        int currentBizOrgValue = SystemVarType.ExtRptCurrentBizOrg.intValue();
        if (!Integer.toString(currentBizOrgValue).equals(systemVarType)) {
            return;
        }
        ArrayList lst = OrgRangeManage.getOrgRangeDataList(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        Iterator itemDataIter = lst.iterator();
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static final void getComboBoxCtrl_INTDB(KDComboBox kDComboBox, IInputCtrl inputCtrl, String sourceReportOrgID, ExecutionContext exeCtx) throws Exception {
        String displayKey = "alias";
        String valueKey = "value";
        String dataSetType = inputCtrl.getDataSetType();
        boolean isKSQL = !"6".equals(dataSetType);
        DefObj def = inputCtrl.getDefDbsource();
        String fid = def.getName();
        String dbsourceName = def.getAlias();
        if (isKSQL) {
            displayKey = inputCtrl.getDefDisplay().getName();
            valueKey = inputCtrl.getDefValue().getName();
            String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
            if (!systemid.equals("")) {
                fid = fid + "\\" + systemid + "\\" + dbsourceName;
            }
        }
        String orgID = ArgInputComponentFactory.getCurrentOrgId(sourceReportOrgID);
        String orgName = ArgInputComponentFactory.getCurrentOrgName();
        HashMap<String, String> models = null;
        if (null != exeCtx) {
            models = new HashMap<String, String>();
            String systemID = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
            String embedMetaData = (String)exeCtx.getDataSetCacheObject((Object)SqlDSModelDrill.getKey(dbsourceName, systemID));
            models.put(SqlDSModelDrill.getKey(dbsourceName, systemID), embedMetaData);
        }
        Iterator itemDataIter = RunReportParam.getBizDataList(null, isKSQL, fid, orgID, orgName, models).iterator();
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static void buildComboBox(KDComboBox kDComboBox, Iterator itemDataIter, String valueKey, String displayKey) {
        String defName = "";
        String defAlias = "";
        if (itemDataIter.hasNext()) {
            kDComboBox.addItem((Object)KDComboBoxCreator.addItemToComboBox(kDComboBox, defName, defAlias));
        }
        while (itemDataIter.hasNext()) {
            DefObj item;
            Object dataItem = itemDataIter.next();
            DefObj defObj = item = dataItem instanceof DefObj ? (DefObj)dataItem : null;
            if (null == item && !StringUtils.isEmpty((String)valueKey)) {
                Map mapItem = (Map)dataItem;
                defName = CtrlReportUtil.getObjectString(mapItem.get(valueKey));
                defAlias = CtrlReportUtil.getObjectString(mapItem.get(displayKey));
                item = KDComboBoxCreator.addItemToComboBox(kDComboBox, defName, defAlias);
            }
            if (null == item) continue;
            kDComboBox.addItem((Object)item);
        }
    }

    private static DefObj addItemToComboBox(KDComboBox kDComboBox, String name, String alias) {
        DefObj item = new DefObj();
        item.setName(name);
        item.setAlias(alias);
        return item;
    }
}

