/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.dispatch.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Clob;
import java.util.Date;
import java.util.HashMap;

public class DispatchCommonUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String clob2String(Object data) throws IOException {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Clob) {
            Clob c = (Clob)data;
            StringBuffer sb = new StringBuffer(1024);
            Reader instream = null;
            try {
                if (c.length() > 0L) {
                    instream = c.getCharacterStream();
                    char[] buffer = new char[(int)c.length()];
                    int length = 0;
                    while ((length = instream.read(buffer)) != -1) {
                        sb.append(buffer);
                    }
                }
            }
            finally {
                if (instream != null) {
                    instream.close();
                }
                return sb.toString();
            }
        }
        return (String)data;
    }

    public static final boolean isSelectRecord(KDTable table) {
        boolean isSelect = true;
        int size = table.getSelectManager().size();
        if (size == 0) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55");
            isSelect = false;
        }
        return isSelect;
    }

    public static synchronized HashMap putSystemParam(HashMap mapSwitchOrg, String userID, String userName) {
        String systemTimeMillis = "-1";
        HashMap mapDesignParma = new HashMap();
        if (null != mapSwitchOrg.get(OrgType.Admin)) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)mapSwitchOrg.get(OrgType.Admin);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitID", adminInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitName", adminInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.CostCenter)) {
            CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)mapSwitchOrg.get(OrgType.CostCenter);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitID", costCenterInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitName", costCenterInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.ControlUnit)) {
            CtrlUnitInfo cuInfo = (CtrlUnitInfo)mapSwitchOrg.get(OrgType.ControlUnit);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitID", cuInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitName", cuInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Company)) {
            CompanyOrgUnitInfo fiInfo = (CompanyOrgUnitInfo)mapSwitchOrg.get(OrgType.Company);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitID", fiInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitName", fiInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get("CurOU")) {
            FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)mapSwitchOrg.get("CurOU");
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitID", ouInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitName", ouInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.ProfitCenter)) {
            ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)mapSwitchOrg.get(OrgType.ProfitCenter);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitID", profitCenterInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitName", profitCenterInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Purchase)) {
            PurchaseOrgUnitInfo purchaseOrgInfo = (PurchaseOrgUnitInfo)mapSwitchOrg.get(OrgType.Purchase);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitID", purchaseOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitName", purchaseOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Sale)) {
            SaleOrgUnitInfo saleOrgInfo = (SaleOrgUnitInfo)mapSwitchOrg.get(OrgType.Sale);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitID", saleOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitName", saleOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Storage)) {
            StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)mapSwitchOrg.get(OrgType.Storage);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitID", storageOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitName", storageOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitName", systemTimeMillis);
        }
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserInfoID", userID);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserInfoName", userName);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserPersonID", systemTimeMillis);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserPersonName", systemTimeMillis);
        if (null != mapSwitchOrg.get(OrgType.HRO)) {
            HROrgUnitInfo hrOrgInfo = (HROrgUnitInfo)mapSwitchOrg.get(OrgType.HRO);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitID", hrOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitName", hrOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Transport)) {
            TransportOrgUnitInfo transportOrgInfo = (TransportOrgUnitInfo)mapSwitchOrg.get(OrgType.Transport);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitID", transportOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitName", transportOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitName", systemTimeMillis);
        }
        return mapDesignParma;
    }

    public static synchronized String getFormatedDate(String format) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String displayDate = "";
        if (StringUtil.isEmptyString((String)format)) {
            return displayDate;
        }
        int position = format.lastIndexOf(".");
        String className = format.substring(0, position);
        String methodName = format.substring(position + 1, format.length());
        Class<?> realClass = Class.forName(className);
        displayDate = (String)realClass.getMethod(methodName, Date.class).invoke(realClass, new Date());
        return displayDate;
    }

    public static synchronized void exportToXls(String fileName, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        Book dstBook = null;
        if (book != null) {
            for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
                Sheet sheet = book.getSheet(sh);
                boolean isSecurity = SheetBaseMath.isSecuritySheet((Sheet)sheet);
                if (!isSecurity) continue;
                if (dstBook == null) {
                    dstBook = BookIOUtil.unpack((byte[])BookIOUtil.pack((Book)book));
                    dstBook.setCalculate(false);
                }
                AlgorithmUtil.delHideRowsAndCols((int[])sheet.getSecHidedRows(), (int[])sheet.getSecHidedCols(), (Sheet)dstBook.getSheet(sh));
                int sheetCount = dstBook.getSheetCount();
                int layerSize = 0;
                for (int i = 0; i < sheetCount; ++i) {
                    EmbedhLayer layer = dstBook.getSheet(i).getEmbedments(false);
                    if (layer == null) continue;
                    layerSize = layer.size();
                    layer.selectAllEmbeds();
                    layer.removeSelectedEmbeds();
                    for (int j = 0; j < layerSize; ++j) {
                        layer.addEmbed(book.getSheet(i).getEmbedments(false).getEmbed(i));
                    }
                }
            }
        }
        if (dstBook == null) {
            dstBook = book;
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)dstBook, (String[])new String[]{dstBook.getSheet(0).getSheetName()});
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        em.exportToExcel(kdsbook, fileName);
    }

    public static synchronized Book execute(Context ctx, String reportID, HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        WebParamAdapter wpa = new WebParamAdapter(ctx, reportID);
        wpa.setSchedule(true);
        wpa.executeBook(mapDesignParam);
        Book book = wpa.getBook();
        return book;
    }

    public static synchronized boolean isExportXls(int saveType, String excelPath, String snapName, StringBuffer errorMsg) throws IOException {
        if (StringUtil.isEmptyString((String)excelPath)) {
            return false;
        }
        String[] dicArray = excelPath.split("/|\\\\");
        if (dicArray.length < 1) {
            errorMsg.append("\r\n\u5bfc\u51faEXCEL\u8def\u5f84\u4e0d\u6b63\u786e,\u4e0d\u80fd\u5bfc\u51faEXCEL\u3002");
            return false;
        }
        boolean isCover = true;
        if (saveType == 1) {
            isCover = false;
        }
        String separator = File.separator;
        StringBuffer curDict = new StringBuffer();
        File f = null;
        int size = dicArray.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                curDict.append(dicArray[i]).append(separator);
                f = new File(curDict.toString());
                if (f.exists()) continue;
                errorMsg.append("\r\n\u5bfc\u51faEXCEl\u8def\u5f84\u7684\u78c1\u76d8\u4e0d\u5b58\u5728,\u4e0d\u80fd\u5bfc\u51faEXCEL\u3002");
                return false;
            }
            curDict.append(dicArray[i]).append(separator);
            f = new File(curDict.toString());
            if (f.exists()) continue;
            f.mkdir();
        }
        curDict.append(snapName).append(".xls");
        f = new File(curDict.toString());
        if (isCover) {
            f.delete();
        }
        return true;
    }

    public static boolean containSpecialChar(String value) {
        if (StringUtil.isEmptyString((String)value)) {
            return false;
        }
        return value.indexOf("/") > -1 || value.indexOf("\\") > -1 || value.indexOf(":") > -1 || value.indexOf("*") > -1 || value.indexOf("?") > -1 || value.indexOf("\"") > -1 || value.indexOf("<") > -1 || value.indexOf(">") > -1 || value.indexOf("|") > -1;
    }
}

