/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.ds.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.snapshot.ds.model.SumPropsModel;
import com.kingdee.eas.base.reportmeta.snapshot.manage.util.SumPeriodUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class DefObjVersusSumPropsModel {
    public static final SimpleDateFormat NANO_SECOND = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    public static final String SPLIT = ";";
    private static Logger _log = Logger.getLogger(DefObjVersusSumPropsModel.class);

    public static DefObj toDefObj(SumPropsModel model) {
        DefObj obj = new DefObj();
        obj.setName(DefObjVersusSumPropsModel.getValue(model));
        String display = DefObjVersusSumPropsModel.getDisplayValue(model);
        if (StringUtil.isEmptyString((String)display)) {
            display = "\u7a7a";
        }
        obj.setAlias(display);
        return obj;
    }

    public static SumPropsModel fromDefObj(DefObj obj) {
        int reportPeriod;
        Timestamp endDate;
        Timestamp beginDate;
        int weekBegin;
        block3: {
            String value = obj.getName();
            String[] parts = value.split(SPLIT);
            weekBegin = -1;
            beginDate = null;
            endDate = null;
            reportPeriod = Integer.parseInt(parts[0]);
            if (reportPeriod != -1) {
                try {
                    beginDate = new Timestamp(NANO_SECOND.parse(parts[1]).getTime());
                    endDate = new Timestamp(NANO_SECOND.parse(parts[2]).getTime());
                    weekBegin = Integer.parseInt(parts[3]);
                }
                catch (ParseException e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)"DefObjVersusSumPropsModel @ fromDefObj @ fromDefObj", (Throwable)e);
                }
            }
        }
        SumPropsModel model = new SumPropsModel();
        model.setReportPeriod(reportPeriod);
        model.setWeekBegin(weekBegin);
        model.setBeginDate(beginDate);
        model.setEndDate(endDate);
        model.setWeekBegin(weekBegin);
        return model;
    }

    private static String getValue(SumPropsModel model) {
        StringBuffer display = new StringBuffer();
        display.append(model.getReportPeriod()).append(SPLIT);
        if (model.getBeginDate() == null) {
            display.append("").append(SPLIT);
        } else {
            display.append(NANO_SECOND.format(model.getBeginDate())).append(SPLIT);
        }
        if (model.getEndDate() == null) {
            display.append("").append(SPLIT);
        } else {
            display.append(NANO_SECOND.format(model.getEndDate())).append(SPLIT);
        }
        display.append(model.getWeekBegin());
        return display.toString();
    }

    private static String getDisplayValue(SumPropsModel model) {
        return SumPeriodUtil.revertToString(model.getBeginDate(), model.getEndDate(), model.getWeekBegin(), ReportSnapType.getDataType(model.getReportPeriod()));
    }
}

