/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseException;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseService;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.AbstractManageUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.AbstractManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.CommonFolderManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.IManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.MailboxManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.mview.PersonalFolderManageView;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.tree.SSManageTree;
import com.kingdee.eas.base.reportmeta.snapshot.manage.consta.FolderType;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.Action;

public class SnapshotManageUI
extends AbstractManageUI {
    private SSManageTree _treeMgr;
    protected static final String TITLE = "\u5feb\u7167\u4e2d\u5fc3";
    protected KDPanel _panel;
    protected IManageView _manageView;
    protected KDWorkButton _btnClose;
    private static String _snapLic = "";

    public void onLoad() throws Exception {
        this.licVerify();
        super.onLoad();
        this.setUITitle(TITLE);
        this.init();
    }

    protected void init() {
        this._treeMgr = new SSManageTree((Component)((Object)this));
        KDSplitPane sppLeftRight = new KDSplitPane(1);
        sppLeftRight.setDividerLocation(260);
        sppLeftRight.setLeftComponent(this._treeMgr.getUI());
        this._manageView = ManageViewFactory.getView(this._treeMgr.getCurrentFolderType(), this);
        this.initManageView();
        this._panel.setMinimumSize(new Dimension(0, 0));
        sppLeftRight.setRightComponent((Component)this._panel);
        sppLeftRight.setOneTouchExpandable(true);
        this._treeMgr.buildTree();
        this.setLayout(new BorderLayout());
        this.add((Component)sppLeftRight, "Center");
        this._treeMgr.setFolderChangeObserver(new FolderTypeChangeObserver());
        this._treeMgr.setSelectionObserver(new TreeSelectionObserver());
    }

    protected void initManageView() {
        int i;
        KDWorkButton[] workBtns = null;
        Action[] actions = null;
        if (this._panel == null) {
            this._panel = new KDPanel((LayoutManager)new BorderLayout());
        }
        if (this._manageView == null) {
            this._panel.removeAll();
        } else {
            if (this._btnClose == null) {
                this._btnClose = (KDWorkButton)this.toolBar.getComponent(1);
            }
            this._panel.removeAll();
            if (this._manageView.getUI() != null) {
                this._panel.add((Component)this._manageView.getUI(), (Object)"Center");
            }
            workBtns = this._manageView.getWorkButtons();
            actions = this._manageView.getManageActions();
            this._panel.revalidate();
        }
        this.toolBar.removeAllToolBarComponents();
        if (workBtns != null) {
            for (i = 0; i < workBtns.length; ++i) {
                this.toolBar.add((Component)workBtns[i]);
            }
        }
        if (actions != null) {
            for (i = 0; i < actions.length; ++i) {
                if (actions[i] == IManageView.SEPARATOR_ACTION) {
                    this.toolBar.addSeparator();
                    continue;
                }
                KDWorkButton btn = new KDWorkButton(actions[i]);
                btn.setToolTipText(btn.getText());
                this.toolBar.add((Component)btn);
            }
            this.toolBar.addSeparator();
        }
        if (this._btnClose != null) {
            this.toolBar.add((Component)this._btnClose);
        }
        this.revalidate();
        this.repaint();
        this.updateToolBar();
    }

    public void updateToolBar() {
        Container c = this.toolBar.getParent();
        if (c != null) {
            c.validate();
            c.repaint();
        }
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportStudioUI");
    }

    public IManageView getManageView() {
        return this._manageView;
    }

    public SSManageTree getTreeMgr() {
        return this._treeMgr;
    }

    private void licVerify() {
        if ("".equals(_snapLic)) {
            EXTLicenseService licSrsv = new EXTLicenseService(null);
            try {
                _snapLic = String.valueOf(licSrsv.sysLicenseContain("BOS_RPTC_SNAPCENTER"));
            }
            catch (EXTLicenseException e) {
                MessageUtil.showDetailAndOK(null, "\u68c0\u67e5License\u5931\u8d25", e);
                this.selfDestruction();
            }
        }
        if (!new Boolean(_snapLic).booleanValue()) {
            String content = "\u6ca1\u6709\u5408\u6cd5\u7684\u8bb8\u53ef\u4e14\u5df2\u8fc7\u8bd5\u7528\u671f";
            StringBuffer detail = new StringBuffer();
            detail.append("\u7533\u8bf7License\u7684\u7c7b\u540d\u79f0\uff1a\u5feb\u7167\u4e2d\u5fc3[");
            detail.append(((Object)((Object)this)).getClass().getName() + "]\n");
            detail.append("\u5bf9\u5e94\u7684\u6a21\u5757\u540d\u79f0\uff1a\u62a5\u8868\u5feb\u7167\u4e2d\u5fc3[BOS_RPTC_SNAPCENTER]\n");
            detail.append("\u5bf9\u5e94\u7684\u5b50\u7cfb\u7edf\u540d\u79f0\uff1aBOS\u62a5\u8868\u4e2d\u5fc3[BOS_RPTC_G]\n");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)content, (String)detail.toString(), (int)0);
            this.selfDestruction();
        }
    }

    private void selfDestruction() {
        this.abort();
    }

    private class TreeSelectionObserver
    implements SSManageTree.ITreeSelectionObserver {
        private TreeSelectionObserver() {
        }

        public void update(int folderType, Object userObject) {
            HashMap<String, Object> filterObj = new HashMap<String, Object>();
            filterObj.put("USER OBJECT", userObject);
            if (SnapshotManageUI.this._manageView instanceof AbstractManageView) {
                ((AbstractManageView)SnapshotManageUI.this._manageView).clearAllMap();
            }
            SnapshotManageUI.this._manageView.loadListData(filterObj);
        }
    }

    private class FolderTypeChangeObserver
    implements SSManageTree.IFolderTypeChangeObserver {
        private FolderTypeChangeObserver() {
        }

        public void update(int folderType) {
            if (SnapshotManageUI.this._manageView instanceof AbstractManageView) {
                ((AbstractManageView)SnapshotManageUI.this._manageView).clearAllMap();
            }
            SnapshotManageUI.this._manageView = ManageViewFactory.getView(folderType, SnapshotManageUI.this);
            SnapshotManageUI.this.initManageView();
        }
    }

    private static class ManageViewFactory {
        private ManageViewFactory() {
        }

        public static IManageView getView(int folderType, SnapshotManageUI manageUI) {
            if (folderType == FolderType.PERSONAL_FOLDER) {
                return new PersonalFolderManageView(manageUI);
            }
            if (folderType == FolderType.COMMON_FOLDER) {
                return new CommonFolderManageView(manageUI);
            }
            if (folderType == FolderType.MAILBOX) {
                return new MailboxManageView(manageUI);
            }
            return null;
        }
    }
}

