/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.sssave;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.PersonalFolderException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PersonalFolder;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.IPersonalFolderService;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.PersonalFolderService;
import com.kingdee.eas.base.reportmeta.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class PersonalTreeLoader
extends AbstractUILongTask {
    private IPersonalFolderService _srsv;
    private KDTree _tree;
    private Window _window;

    public PersonalTreeLoader(KDTree tree, Window targetWindow, int mode) {
        super(targetWindow, mode);
        this._tree = tree;
        this._window = targetWindow;
    }

    public void doTask() {
        try {
            this._srsv = PersonalFolderService.getInst();
            PersonalFolder folder = this._srsv.loadMyFolder();
            final DefaultKingdeeTreeNode root = this.createMyTreeNode(folder);
            this._tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DefaultKingdeeTreeNode node;
                    if (e.getClickCount() == 2 && (node = (DefaultKingdeeTreeNode)PersonalTreeLoader.this._tree.getLastSelectedPathComponent()) != null) {
                        PersonalTreeLoader.this._window.setVisible(false);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
                    PersonalTreeLoader.this._tree.setModel((TreeModel)model);
                    PersonalTreeLoader.this._tree.setRootVisible(true);
                    PersonalTreeLoader.this._tree.expandAllNodes(true, (TreeNode)root);
                    PersonalTreeLoader.this._tree.repaint();
                }
            });
        }
        catch (PersonalFolderException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExtMsgBox.showError(PersonalTreeLoader.this._window, "\u52a0\u8f7d\u4e2a\u4eba\u6587\u4ef6\u5939\u5931\u8d25", e.toString());
                }
            });
        }
    }

    DefaultKingdeeTreeNode createMyTreeNode(PersonalFolder foler) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)foler);
        newNode.setText(foler.getName());
        newNode.setUserObject((Object)foler);
        Vector children = foler.getChildren();
        if (null != children && children.size() > 0) {
            Iterator itor = children.iterator();
            while (itor.hasNext()) {
                newNode.add((MutableTreeNode)this.createMyTreeNode((PersonalFolder)itor.next()));
            }
        }
        if (newNode.getChildCount() == 0) {
            newNode.setCustomIcon(SSIcons.FILE_NORMAL_ICON);
        }
        return newNode;
    }

    public void finished() {
        super.finished();
    }
}

