/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.icon.SSIcons;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup.CustomListCellRender;
import com.kingdee.eas.base.reportmeta.snapshot.manage.client.usergroup.SSUserGroupEditUI;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.ug.UserGroupInfo;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.snapshot.manage.service.mailbox.SSExpressDeliveryService;
import com.kingdee.eas.base.reportmeta.sumreport.client.common.AbstractUILongTask;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SSUserGroupListUI
extends KDDialog {
    private Window _window;
    private KDList _groups;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private List _groupsData;
    private boolean _elemInsDel;

    public SSUserGroupListUI(Dialog owner) {
        super(owner, true);
        this._window = owner;
        this.initUI();
        this.installListener();
        this.loadData();
    }

    private void loadData() {
        new GroupsLoader((Window)((Object)this), 0).start();
    }

    public SSUserGroupListUI(Frame owner) {
        super(owner, true);
        this._window = owner;
        this.initUI();
        this.installListener();
        this.loadData();
    }

    private void initUI() {
        this.setDefaultCloseOperation(1);
        this.setTitle("\u7528\u6237\u7ec4");
        this._groups = new KDList(new DefaultListModel());
        this._groups.setAutoscrolls(true);
        this._groups.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText("\u4fee\u6539");
        this._btnEdit.setIcon((Icon)SSIcons.createIcon("tben_Edit.gif"));
        this._btnEdit.setEnabled(false);
        this._btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupListUI.this.actionEdit();
            }
        });
        KDWorkButton btnNew = new KDWorkButton();
        btnNew.setText("\u65b0\u5efa");
        btnNew.setIcon((Icon)SSIcons.createIcon("tbtn_New.gif"));
        btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupListUI.this.actionNew();
            }
        });
        this._btnDel = new KDWorkButton();
        this._btnDel.setText("\u5220\u9664");
        this._btnDel.setIcon((Icon)SSIcons.createIcon("tbtn_Delete.gif"));
        this._btnDel.setEnabled(false);
        this._btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupListUI.this.actionDel();
            }
        });
        KDWorkButton btnQuit = new KDWorkButton();
        btnQuit.setText(null);
        btnQuit.setIcon((Icon)SSIcons.createIcon("tbtn_quit.gif"));
        btnQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSUserGroupListUI.this.setVisible(false);
            }
        });
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)btnNew);
        toolBar.add((Component)this._btnEdit);
        toolBar.add((Component)this._btnDel);
        toolBar.addSeparator();
        toolBar.add((Component)btnQuit);
        this.addToolBar((JToolBar)toolBar);
        KDPanel board = new KDPanel((LayoutManager)new BorderLayout());
        board.setCustomInsets(new Insets(10, 10, 10, 10));
        KDScrollPane groupPane = new KDScrollPane((Component)this._groups);
        board.add((Component)groupPane, (Object)"Center");
        this.setContentPane((Container)board);
        this.setSize(300, 450);
    }

    private void installListener() {
        this._groups.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    SSUserGroupListUI.this.actionEdit();
                }
            }
        });
        this._groups.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SSUserGroupListUI.this._groups.getSelectedIndices().length == 0) {
                    SSUserGroupListUI.this._btnEdit.setEnabled(false);
                    SSUserGroupListUI.this._btnDel.setEnabled(false);
                    return;
                }
                SSUserGroupListUI.this._btnEdit.setEnabled(true);
                SSUserGroupListUI.this._btnDel.setEnabled(true);
            }
        });
    }

    private void actionEdit() {
        UserGroupInfo userGroup = (UserGroupInfo)this._groups.getSelectedValue();
        SSUserGroupEditUI newUI = new SSUserGroupEditUI(userGroup, (Dialog)((Object)this));
        newUI.setTitle("\u7ef4\u62a4\u7528\u6237\u7ec4");
        newUI.setLocationRelativeTo(null);
        newUI.setVisible(true);
        this._elemInsDel = true;
    }

    private void actionNew() {
        UserGroupInfo userGroup;
        SSUserGroupEditUI newUI = new SSUserGroupEditUI(null, (Dialog)((Object)this));
        newUI.setTitle("\u65b0\u5efa\u7528\u6237\u7ec4");
        newUI.setLocationRelativeTo(null);
        newUI.setVisible(true);
        if (!newUI.isCancel() && (userGroup = newUI.getEntity()) != null) {
            this._elemInsDel = true;
            this._groupsData.add(userGroup);
            DefaultListModel model = (DefaultListModel)this._groups.getModel();
            model.addElement(userGroup);
        }
    }

    private void actionDel() {
        if (ExtMsgBox.showConfirm2((Component)((Object)this), "\u786e\u8ba4\u5220\u9664\u9009\u62e9\u7684\u7528\u6237\u7ec4\u5417\uff1f") == 0) {
            try {
                ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
                Object[] selObjs = this._groups.getSelectedValues();
                serv.deleteUserGroups(selObjs);
                DefaultListModel model = (DefaultListModel)this._groups.getModel();
                for (int i = 0; i < selObjs.length; ++i) {
                    model.removeElement(selObjs[i]);
                    this._groupsData.remove(selObjs[i]);
                }
                this._elemInsDel = true;
            }
            catch (ShortcutMailboxException e) {
                ExtMsgBox.showError((Component)((Object)this), "\u5220\u9664\u7528\u6237\u7ec4\u5931\u8d25", e.toString());
            }
        }
    }

    public List getGroupsData() {
        return this._groupsData;
    }

    public boolean isElemInsDel() {
        return this._elemInsDel;
    }

    public void setElemInsDel(boolean elemInsDel) {
        this._elemInsDel = elemInsDel;
    }

    private class GroupsLoader
    extends AbstractUILongTask {
        public GroupsLoader(Window targetWindow, int mode) {
            super(targetWindow, mode);
        }

        public void doTask() {
            try {
                ISSExpressDeliveryService serv = SSExpressDeliveryService.getInst();
                SSUserGroupListUI.this._groupsData = serv.queryGroups();
                if (SSUserGroupListUI.this._groupsData != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DefaultListModel model = (DefaultListModel)SSUserGroupListUI.this._groups.getModel();
                            int size = SSUserGroupListUI.this._groupsData.size();
                            for (int i = 0; i < size; ++i) {
                                model.addElement(SSUserGroupListUI.this._groupsData.get(i));
                            }
                        }
                    });
                }
            }
            catch (ShortcutMailboxException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExtMsgBox.showError(SSUserGroupListUI.this._window, "\u83b7\u5f97\u7528\u6237\u7ec4\u5217\u8868\u5931\u8d25", e.toString());
                    }
                });
            }
        }
    }
}

