/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportQuery;
import com.kingdee.eas.base.reportmeta.ctrlreport.permission.IReportPermission;
import com.kingdee.eas.base.reportmeta.sumreport.client.BaseTaskListUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.execution.SNRRExecutor;
import com.kingdee.eas.base.reportmeta.sumreport.client.filterui.SumTaskFilterUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.ExecuteContext;
import com.kingdee.eas.base.reportmeta.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.base.reportmeta.sumreport.util.ControlDataLoadUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class SumTaskListUI
extends BaseTaskListUI {
    protected static final int COL_TASKNAME = 0;
    protected static final int COL_SUMRANGE = 1;
    protected static final int COL_SUMUNIT = 2;
    protected static final int COL_REPORTNAME = 3;
    protected static final int COL_STATE = 4;
    protected static final int COL_MAKER = 5;
    protected static final int COL_MAKETIME = 6;
    protected static final int COL_AUDITOR = 7;
    protected static final int COL_AUDITTIME = 8;
    protected static final int COL_UPLOADER = 9;
    protected static final int COL_UPLOADTIME = 10;
    private boolean isHasMakePerm = true;

    public SumTaskListUI() throws Exception {
        this.setUITitle("\u6c47\u603b\u4efb\u52a1\u5217\u8868");
    }

    protected void initBtnMenu() throws Exception {
        super.initBtnMenu();
        this._btnNew.setText("\u751f\u6210\u6c47\u603b\u62a5\u8868");
        this._btnView.setText("\u67e5\u770b\u6c47\u603b\u62a5\u8868");
    }

    protected void initTable() {
        int[] columnWidth = new int[]{128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128};
        String[] columnName = new String[]{"\u4efb\u52a1\u540d\u79f0", "\u6c47\u603b\u8303\u56f4", "\u6c47\u603b\u5355\u5143", "\u62a5\u8868\u540d\u79f0", "\u72b6\u6001", "\u7f16\u5236\u4eba", "\u7f16\u5236\u65f6\u95f4", "\u5ba1\u6279\u4eba", "\u5ba1\u6279\u65f6\u95f4", "\u4e0a\u62a5\u4eba", "\u4e0a\u62a5\u65f6\u95f4"};
        ControlDataLoadUtil.initTableHeader(this._table, 11, columnWidth, columnName);
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        String dateFormate = "yyyy-MM-dd  HH:mm";
        this._table.getColumn(6).getStyleAttributes().setNumberFormat(dateFormate);
        this._table.getColumn(8).getStyleAttributes().setNumberFormat(dateFormate);
        this._table.getColumn(10).getStyleAttributes().setNumberFormat(dateFormate);
    }

    protected void setButtonState() {
        switch (this._info.getState()) {
            case 0: {
                if (!this.isHasMakePerm) {
                    this._btnNew.setEnabled(false);
                    this._btnView.setText("\u67e5\u770b\u6c47\u603b\u62a5\u8868");
                } else {
                    this._btnNew.setEnabled(true);
                    this._btnView.setText("\u7f16\u8f91\u6c47\u603b\u62a5\u8868");
                }
                if (!this._info.isHavedSnapshot()) {
                    this._btnView.setEnabled(false);
                    break;
                }
                this._btnView.setEnabled(true);
                break;
            }
            case 1: {
                this._btnNew.setEnabled(false);
                this._btnView.setEnabled(true);
                this._btnView.setText("\u67e5\u770b\u6c47\u603b\u62a5\u8868");
                break;
            }
            default: {
                this._btnNew.setEnabled(false);
                this._btnView.setEnabled(true);
                this._btnView.setText("\u67e5\u770b\u6c47\u603b\u62a5\u8868");
            }
        }
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportStudioUI");
    }

    protected void actionRefresh(List uploadReportList) {
        this._table.removeRows();
        if (uploadReportList == null || uploadReportList.size() == 0) {
            return;
        }
        int size = uploadReportList.size();
        for (int i = 0; i < size; ++i) {
            Map rowData = (Map)uploadReportList.get(i);
            TaskDetailInfo info = new TaskDetailInfo();
            IRow row = this._table.addRow();
            row.getCell(0).setValue(rowData.get("taskname"));
            info.setTaskName((String)rowData.get("taskname"));
            row.getCell(1).setValue(rowData.get("rangename"));
            row.getCell(2).setValue(rowData.get("unitname"));
            row.getCell(3).setValue(rowData.get("reportname"));
            info.setReportName((String)rowData.get("reportname"));
            this.setState(rowData.get("detailstate"), row, info, 4);
            row.getCell(5).setValue(rowData.get("makername"));
            row.getCell(6).setValue(rowData.get("detailmaketime"));
            row.getCell(7).setValue(rowData.get("approvername"));
            row.getCell(8).setValue(rowData.get("detailapprovetime"));
            row.getCell(9).setValue(rowData.get("uploadername"));
            row.getCell(10).setValue(rowData.get("detailuploadtime"));
            if (rowData.get("snapid") != null) {
                info.setHavedSnapshot(true);
            } else {
                info.setHavedSnapshot(false);
            }
            Number idFlag = (Number)rowData.get("fidflag");
            info.setIdFlag(idFlag.intValue());
            info.setTaskDistributeID((String)rowData.get("taskid"));
            info.setId((String)rowData.get("detailid"));
            info.setUnitOrOrgID((String)rowData.get("unitororgid"));
            info.setBeginDate((Timestamp)rowData.get("taskbegindate"));
            info.setEndDate((Timestamp)rowData.get("taskenddate"));
            info.setReportID((String)rowData.get("freportid"));
            info.setParentID((String)rowData.get("parentid"));
            row.setUserObject((Object)info);
        }
    }

    protected void actionQuery() {
        try {
            Frame owner = (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (this.filter == null) {
                this.filter = new SumTaskFilterUI(owner, "\u6c47\u603b\u4efb\u52a1\u8fc7\u6ee4", true, false, this, "actionFilter");
            }
            this.filter.setLocationRelativeTo(null);
            this.filter.setVisible(true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionFilter(String filterWhereSql) {
        try {
            this._filterWhereSql = filterWhereSql;
            List uploadReportList = this.sumTaskUploadService.getSumReportList(this.curOrgID, this.localString, filterWhereSql);
            this.actionRefresh(uploadReportList);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void actionNew() {
        if (!this.isSelectRecord()) {
            return;
        }
        ExecuteContext ctx = new ExecuteContext();
        ctx.setActivityInfo(this._info);
        ctx.setEditable(true);
        ctx.setIsUpload(false);
        ctx.setIsTemplate(true);
        ctx.setObserver(this);
        EASUtil.showUIOnNewTab(SNRRExecutor.class.getName(), (Map)ctx.getContext(), this);
        this._btnNew.getModel().setRollover(false);
    }

    protected void actionView() {
        if (!this.isSelectRecord()) {
            return;
        }
        ExecuteContext ctx = new ExecuteContext();
        ctx.setActivityInfo(this._info);
        ctx.setEditable(true);
        ctx.setIsUpload(false);
        ctx.setIsTemplate(false);
        EASUtil.showUIOnNewTab(SNRRExecutor.class.getName(), (Map)ctx.getContext(), this);
        this._btnView.getModel().setRollover(false);
    }

    public void onLoad() throws Exception {
        this.licVerify();
        this.checkFunctionPermission();
        super.onLoad();
    }

    protected void checkFunctionPermission() throws Exception {
        boolean isHasPerm;
        IReportPermission permission = CtrlReportQuery.getIReportPermissionInstance();
        this.isHasMakePerm = permission.isPermissionByItemName("ext_Sum_Make");
        boolean isHasApprovPerm = permission.isPermissionByItemName("ext_Sum_Approve");
        boolean isHasUploadPerm = permission.isPermissionByItemName("ext_Sum_Upload");
        boolean bl = isHasPerm = this.isHasMakePerm || isHasApprovPerm || isHasUploadPerm;
        if (!isHasPerm) {
            ExtMsgBox.showInfo("\u6ca1\u6709\u6c47\u603b\u4efb\u52a1\u5217\u8868\u7684\u6743\u9650");
            this.abort();
        }
        if (!this.isHasMakePerm) {
            this._btnNew.setEnabled(false);
        }
    }
}

