/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.execution.action;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportQuery;
import com.kingdee.eas.base.reportmeta.ctrlreport.permission.IReportPermission;
import com.kingdee.eas.base.reportmeta.sumreport.client.execution.SNRRExecutor;
import com.kingdee.eas.base.reportmeta.sumreport.data.ExecuteContext;
import com.kingdee.eas.base.reportmeta.sumreport.model.SNRRExecutorObserver;
import com.kingdee.eas.base.reportmeta.sumreport.service.ExecutorService;
import java.net.SocketException;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class AbstractAction
extends javax.swing.AbstractAction {
    protected static final Logger log = LogUtil.getPackageLogger(AbstractAction.class);
    protected static final String NONE_PERMISSION = "NONE_PERMISSION";
    protected SNRRExecutor _executor;
    protected ExecutorService _srsv;
    protected Vector obs;
    protected static IReportPermission _permissionSrsv;

    public AbstractAction(SNRRExecutor executor) {
        this._executor = executor;
        this._srsv = new ExecutorService();
        this.checkPermission();
        this.obs = new Vector(1);
    }

    protected void setText(String text) {
        this.putValue("Name", text);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setQuickKey(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
    }

    protected ExecuteContext getContext() {
        return this._executor.getContext();
    }

    protected void dealSessionException(Exception ex) {
        Throwable ori = ex.getCause();
        if (ori instanceof IllegalStateException) {
            throw (IllegalStateException)ori;
        }
        if (ori instanceof SocketException) {
            throw new IllegalStateException(ori.getCause().toString());
        }
    }

    protected void checkPermission() {
        try {
            String name = this.getPermissionItemName();
            if (NONE_PERMISSION.equals(name)) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(_permissionSrsv != null ? _permissionSrsv.isPermissionByItemName(name) : false);
        }
        catch (Exception e) {
            log.info((Object)"\u5224\u65ad\u6743\u9650\u5931\u8d25", (Throwable)e);
            this.setEnabled(false);
        }
    }

    protected abstract String getPermissionItemName();

    public synchronized void addObserver(SNRRExecutorObserver o) {
        if (o != null && !this.obs.contains(o)) {
            this.obs.addElement(o);
        }
    }

    public synchronized void deleteObserver(SNRRExecutorObserver o) {
        this.obs.removeElement(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers() {
        Object[] arrLocal;
        AbstractAction abstractAction = this;
        synchronized (abstractAction) {
            arrLocal = this.obs.toArray();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((SNRRExecutorObserver)arrLocal[i]).update(this);
        }
    }

    static {
        try {
            _permissionSrsv = CtrlReportQuery.getIReportPermissionInstance();
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u5f97\u6743\u9650\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

