/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.filterui;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.CommonReportF7;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.UploadApproverLoad;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.UploadMakerLoad;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.UploadSumRangeDataLoad;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.UploadSumReportDataLoad;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.UploadUploaderLoad;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.model.CommonReportInfo;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.f7.f7dataLoad.model.UploadUserInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BaseTaskFilterUI
extends KDDialog {
    protected KDLabelContainer lblTemplate;
    protected KDLabelContainer lblMaker;
    protected KDLabelContainer lblAuditor;
    protected KDLabelContainer lblUploader;
    protected KDBizPromptBox bizTemplate;
    protected KDBizPromptBox bizMaker;
    protected KDBizPromptBox bizAuditor;
    protected KDBizPromptBox bizUploader;
    protected KDCheckBox cbxDistributed;
    protected KDCheckBox cbxMade;
    protected KDCheckBox cbxAudited;
    protected KDCheckBox cbxUploaded;
    protected KDCheckBox cbxReceived;
    protected KDLabelContainer lblSumRange;
    protected KDLabelContainer lblSumUnit;
    public KDBizPromptBox bizSumRange;
    public KDBizPromptBox bizSumUnit;
    protected KDSeparator kdSeparator;
    protected KDButton _btnOk;
    protected KDButton _btnCancel;
    protected KDContainer stateContainer;
    protected String returnWhereSql;
    protected Object _listUI;
    protected String _methodName;
    protected Frame _owner;
    private Logger _logger = Logger.getLogger(BaseTaskFilterUI.class);

    public BaseTaskFilterUI(Frame owner, String title, boolean modal, boolean isResizable, Object listUI, String methodName) throws Exception {
        super(owner, title, modal);
        this.setResizable(isResizable);
        this._listUI = listUI;
        this._methodName = methodName;
        this._owner = owner;
        this.init();
        this.initUserOneUserF7();
        this.initLayout();
    }

    protected void init() throws Exception {
        this.lblTemplate = new KDLabelContainer();
        this.bizMaker = new KDBizPromptBox();
        this.lblMaker = new KDLabelContainer();
        this.lblAuditor = new KDLabelContainer();
        this.bizAuditor = new KDBizPromptBox();
        this.lblUploader = new KDLabelContainer();
        this.bizUploader = new KDBizPromptBox();
        this.bizTemplate = new KDBizPromptBox();
        this.stateContainer = new KDContainer();
        this.cbxDistributed = new KDCheckBox();
        this.cbxMade = new KDCheckBox();
        this.cbxAudited = new KDCheckBox();
        this.cbxUploaded = new KDCheckBox();
        this.cbxReceived = new KDCheckBox();
        this.lblSumRange = new KDLabelContainer();
        this.lblSumUnit = new KDLabelContainer();
        this.bizSumRange = new KDBizPromptBox();
        this.bizSumUnit = new KDBizPromptBox();
        this.bizSumRange.setEditable(false);
        this.bizSumUnit.setEditable(false);
        this.lblSumRange.setBoundLabelText("\u6c47\u603b\u8303\u56f4");
        this.lblSumRange.setBoundLabelLength(60);
        this.lblSumRange.setBoundLabelUnderline(true);
        this.lblSumUnit.setBoundLabelText("\u6c47\u603b\u5355\u5143");
        this.lblSumUnit.setBoundLabelLength(60);
        this.lblSumUnit.setBoundLabelUnderline(true);
        this.kdSeparator = new KDSeparator();
        this._btnOk = new KDButton();
        this._btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseTaskFilterUI.this.okActionPerform(e);
            }
        });
        this._btnCancel = new KDButton();
        this._btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseTaskFilterUI.this.cancelActionPerform(e);
            }
        });
        this.lblTemplate.setBoundLabelText("\u6a21\u677f\uff1a");
        this.lblTemplate.setBoundLabelLength(60);
        this.lblTemplate.setBoundLabelUnderline(true);
        this.bizMaker.setEditable(false);
        this.lblMaker.setBoundLabelText("\u7f16\u5236\u4eba\uff1a");
        this.lblMaker.setBoundLabelLength(60);
        this.lblMaker.setBoundLabelUnderline(true);
        this.lblAuditor.setBoundLabelText("\u5ba1\u6279\u4eba \uff1a");
        this.lblAuditor.setBoundLabelLength(60);
        this.lblAuditor.setBoundLabelUnderline(true);
        this.bizAuditor.setEditable(false);
        this.lblUploader.setBoundLabelText("\u4e0a\u62a5\u4eba\uff1a");
        this.lblUploader.setBoundLabelLength(60);
        this.lblUploader.setBoundLabelUnderline(true);
        this.bizUploader.setEditable(false);
        this.bizTemplate.setEditable(false);
        this.stateContainer.setTitle("\u72b6\u6001");
        this.stateContainer.setToolTipText("\u72b6\u6001");
        this.stateContainer.setOpaque(false);
        this.cbxDistributed.setText("\u5df2\u5206\u914d");
        this.cbxMade.setText("\u5df2\u7f16\u5236");
        this.cbxAudited.setText("\u5df2\u5ba1\u6279");
        this.cbxUploaded.setText("\u5df2\u4e0a\u62a5");
        this.cbxReceived.setText("\u5df2\u63a5\u6536");
        this._btnOk.setText("\u786e\u5b9a");
        this._btnCancel.setText("\u53d6\u6d88");
        this.cbxDistributed.setSelected(true);
        this.cbxMade.setSelected(true);
        this.cbxAudited.setSelected(true);
        this.cbxUploaded.setSelected(true);
    }

    protected abstract void initLayout();

    protected void initUserOneUserF7() throws Exception {
        String name = this._listUI.getClass().getName();
        this.bizMaker.setSelector((KDPromptSelector)new CommonReportF7(this._owner, "\u7f16\u5236\u4eba\u67e5\u8be2", true, false, new UploadMakerLoad(name), (KDPromptBox)this.bizMaker));
        this.bizAuditor.setSelector((KDPromptSelector)new CommonReportF7(this._owner, "\u5ba1\u6279\u4eba\u67e5\u8be2", true, false, new UploadApproverLoad(name), (KDPromptBox)this.bizAuditor));
        this.bizUploader.setSelector((KDPromptSelector)new CommonReportF7(this._owner, "\u4e0a\u62a5\u4eba\u67e5\u8be2", true, false, new UploadUploaderLoad(name), (KDPromptBox)this.bizUploader));
        this.bizTemplate.setSelector((KDPromptSelector)new CommonReportF7(this._owner, "\u62a5\u8868\u6a21\u677f\u67e5\u8be2", true, false, new UploadSumReportDataLoad(), (KDPromptBox)this.bizTemplate));
        this.bizSumRange.setSelector((KDPromptSelector)new CommonReportF7(this._owner, "\u6c47\u603b\u8303\u56f4\u67e5\u8be2", true, false, new UploadSumRangeDataLoad(), (KDPromptBox)this.bizSumRange));
    }

    protected abstract boolean validateBeforePerform();

    protected void okActionPerform(ActionEvent e) {
        boolean isPass = this.validateBeforePerform();
        if (!isPass) {
            return;
        }
        StringBuffer whereSql = this.assembleWhereCondition();
        String resultSql = "";
        if (whereSql != null) {
            resultSql = whereSql.toString();
        }
        try {
            this._listUI.getClass().getMethod(this._methodName, String.class).invoke(this._listUI, resultSql);
        }
        catch (IllegalArgumentException e1) {
            this._logger.error((Object)e1);
        }
        catch (SecurityException e1) {
            this._logger.error((Object)e1);
        }
        catch (IllegalAccessException e1) {
            this._logger.error((Object)e1);
        }
        catch (InvocationTargetException e1) {
            this._logger.error((Object)e1);
        }
        catch (NoSuchMethodException e1) {
            this._logger.error((Object)e1);
        }
        this.cancelActionPerform(e);
    }

    protected StringBuffer assembleWhereCondition() {
        List templateInfoList = (List)this.bizTemplate.getData();
        List auditorList = (List)this.bizAuditor.getData();
        List makerList = (List)this.bizMaker.getData();
        List uploaderlist = (List)this.bizUploader.getData();
        StringBuffer whereSql = new StringBuffer();
        this.createTemplateWhereSql(templateInfoList, whereSql);
        this.createUserWhereSql(auditorList, whereSql, "detail.fapproverid");
        this.createUserWhereSql(makerList, whereSql, "detail.fmakerid");
        this.createUserWhereSql(uploaderlist, whereSql, "detail.fuploaduserid");
        this.createStateSql("detail.fstate", whereSql);
        return whereSql;
    }

    protected void createTemplateWhereSql(List templateInfoList, StringBuffer whereSql) {
        if (templateInfoList == null || templateInfoList.size() == 0) {
            return;
        }
        StringBuffer templateSql = new StringBuffer();
        templateSql.append(" and report.fid in ( ");
        int size = templateInfoList.size();
        for (int i = 0; i < size; ++i) {
            CommonReportInfo templateInfo = (CommonReportInfo)templateInfoList.get(i);
            if (StringUtil.isEmptyString((String)templateInfo.reportId)) continue;
            templateSql.append("'").append(templateInfo.reportId).append("'").append(",");
        }
        this.deleteLastCharAddToSql(templateSql, whereSql);
    }

    protected void createUserWhereSql(List userList, StringBuffer whereSql, String columnName) {
        if (userList == null || userList.size() == 0) {
            return;
        }
        StringBuffer userSql = new StringBuffer();
        userSql.append(" and ").append(columnName).append(" in (");
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            UploadUserInfo userInfo = (UploadUserInfo)userList.get(i);
            if (StringUtil.isEmptyString((String)userInfo.getId())) continue;
            userSql.append("'").append(userInfo.getId().toString()).append("'").append(",");
        }
        this.deleteLastCharAddToSql(userSql, whereSql);
    }

    protected void createSumRangeWhereSql(List dataList, StringBuffer whereSql, String columnName) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        StringBuffer sumRangeSql = new StringBuffer();
        sumRangeSql.append(" and ").append(columnName).append(" in (");
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            SumRangeInfo sumRangeInfo = (SumRangeInfo)dataList.get(i);
            if (StringUtil.isEmptyString((String)sumRangeInfo.getId())) continue;
            sumRangeSql.append("'").append(sumRangeInfo.getId()).append("'").append(",");
        }
        this.deleteLastCharAddToSql(sumRangeSql, whereSql);
    }

    protected void createSumUnitWhereSql(List dataList, StringBuffer whereSql, String columnName) {
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        StringBuffer sumUnitSql = new StringBuffer();
        sumUnitSql.append(" and ").append(columnName).append(" in (");
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            SumUnitInfo sumUnitInfo = (SumUnitInfo)dataList.get(i);
            if (StringUtil.isEmptyString((String)sumUnitInfo.getId())) continue;
            sumUnitSql.append("'").append(sumUnitInfo.getId()).append("'").append(",");
        }
        this.deleteLastCharAddToSql(sumUnitSql, whereSql);
    }

    protected void createStateSql(String columnName, StringBuffer whereSql) {
        StringBuffer stateSql = new StringBuffer();
        if (this.cbxDistributed.isSelected()) {
            stateSql.append("0").append(",");
        }
        if (this.cbxMade.isSelected()) {
            stateSql.append("1").append(",");
        }
        if (this.cbxAudited.isSelected()) {
            stateSql.append("2").append(",");
        }
        if (this.cbxUploaded.isSelected()) {
            stateSql.append("3").append(",");
        }
        if (this.cbxReceived.isSelected()) {
            stateSql.append("4").append(",");
        }
        if (stateSql.length() > 0) {
            stateSql.deleteCharAt(stateSql.length() - 1);
            whereSql.append(" and ").append(columnName).append(" in ( ").append(stateSql).append(" )");
        }
    }

    protected void deleteLastCharAddToSql(StringBuffer needAddedSql, StringBuffer whereSql) {
        if (needAddedSql != null && needAddedSql.length() > 0) {
            needAddedSql.deleteCharAt(needAddedSql.length() - 1);
            whereSql.append(needAddedSql).append(" ) ");
        }
    }

    protected void cancelActionPerform(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

