/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.IExport;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.KDFileChooserProvider;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class AbstractBaseExportXML
implements IExport {
    Logger log = Logger.getLogger(AbstractBaseExportXML.class);
    protected ISumRangeService _service;
    protected CoreUI parentUI;
    protected List sumRangeInfoList;

    public AbstractBaseExportXML(List sumRangeInfoList, CoreUI parentUI) {
        this.parentUI = parentUI;
        this.sumRangeInfoList = sumRangeInfoList;
    }

    public void exportData() {
        new Thread(new Runnable(){

            public void run() {
                List sumRangeList = null;
                try {
                    sumRangeList = AbstractBaseExportXML.this._service.getSumRangeUnitList(AbstractBaseExportXML.this.sumRangeInfoList);
                }
                catch (BOSException e) {
                    AbstractBaseExportXML.this.showSynchroMsg("\u83b7\u53d6\u6c47\u603b\u8303\u56f4\u4fe1\u606f\u5931\u8d25");
                    AbstractBaseExportXML.this.log.error((Object)e);
                    return;
                }
                List sumUnitOrgList = null;
                try {
                    sumUnitOrgList = AbstractBaseExportXML.this.getSumUnitOrgList(AbstractBaseExportXML.this.sumRangeInfoList);
                }
                catch (BOSException e) {
                    AbstractBaseExportXML.this.showSynchroMsg("\u83b7\u53d6\u5f53\u524d \u6c47\u603b\u8303\u56f4\u4e0b\u7684 \u5f15\u5165\u7ec4\u7ec7\u7ec4\u7ec7\u5931\u8d25");
                    AbstractBaseExportXML.this.log.error((Object)e);
                    return;
                }
                Document document = DocumentHelper.createDocument();
                Element root = document.addElement("ROOT");
                Element sumRange = root.addElement("SUMRANGE");
                AbstractBaseExportXML.this.assmbleSumRange(sumRangeList, sumRange);
                AbstractBaseExportXML.this.assembelSumUnitXML(sumRangeList, sumRange, sumUnitOrgList);
                AbstractBaseExportXML.this.doExport(document);
            }
        }).start();
    }

    private void showSynchroMsg(final String errorMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtMsgBox.showInfo(errorMsg);
            }
        });
    }

    protected List getSumUnitOrgList(List sumRangeInfoList) throws BOSException {
        List sumUnitOrgList = null;
        if (sumRangeInfoList != null && sumRangeInfoList.size() > 0) {
            SumRangeInfo sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(0);
            sumUnitOrgList = this._service.getSumUnitOrgListByRangeID(sumRangeInfo.getId(), "l2");
        }
        return sumUnitOrgList;
    }

    protected void assmbleSumRange(List sumRangeList, Element sumRange) {
        if (sumRangeList == null || sumRangeList.size() == 0) {
            return;
        }
        Map sumUnitInfoMap = (Map)sumRangeList.get(0);
        sumRange.addAttribute("sumRangeNumber", this.removeQuotes((String)sumUnitInfoMap.get("rangenumber")));
        Element number = sumRange.addElement("Number");
        number.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangenumber")));
        Element name_l1 = sumRange.addElement("Name");
        name_l1.addAttribute("locale", "l1");
        name_l1.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangename_l1")));
        Element name_l2 = sumRange.addElement("Name");
        name_l2.addAttribute("locale", "l2");
        name_l2.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangename_l2")));
        Element name_l3 = sumRange.addElement("Name");
        name_l3.addAttribute("locale", "l3");
        name_l3.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangename_l3")));
        Element description_l1 = sumRange.addElement("Des");
        description_l1.addAttribute("locale", "l1");
        description_l1.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangefdes_l1")));
        Element description_l2 = sumRange.addElement("Des");
        description_l2.addAttribute("locale", "l2");
        description_l2.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangefdes_l2")));
        Element description_l3 = sumRange.addElement("Des");
        description_l3.addAttribute("locale", "l3");
        description_l3.setText(this.removeQuotes((String)sumUnitInfoMap.get("rangefdes_l3")));
    }

    protected void assembelSumUnitXML(List sumRangeList, Element root, List sumUnitOrgList) {
        if (sumRangeList == null || sumRangeList.size() == 0) {
            return;
        }
        Map sumUnitInfoMap = null;
        int size = sumRangeList.size();
        for (int i = 0; i < size; ++i) {
            sumUnitInfoMap = (Map)sumRangeList.get(i);
            if (StringUtil.isEmptyString((String)((String)sumUnitInfoMap.get("unitid")))) continue;
            Element unitRoot = root.addElement("SUMUNITINFO");
            unitRoot.addAttribute("sumRangeNumber", root.attributeValue("sumRangeNumber"));
            Element unitId = unitRoot.addElement("Id");
            unitId.setText(this.getDisplayText((String)sumUnitInfoMap.get("unitid")));
            Element unitParentID = unitRoot.addElement("ParentID");
            String parentId = this.getDisplayText((String)sumUnitInfoMap.get("fparentid"));
            parentId = "null".equals(parentId) || "NULL".equals(parentId) ? "" : parentId;
            unitParentID.setText(parentId);
            Element unitNumber = unitRoot.addElement("Number");
            unitNumber.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitnumber")));
            Element unitLongNumber = unitRoot.addElement("LongNumber");
            unitLongNumber.setText(this.removeQuotes((String)sumUnitInfoMap.get("flongnumber")));
            Element unitName_l1 = unitRoot.addElement("Name");
            unitName_l1.addAttribute("locale", "l1");
            unitName_l1.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfname_l1")));
            Element unitName_l2 = unitRoot.addElement("Name");
            unitName_l2.addAttribute("locale", "l2");
            unitName_l2.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfname_l2")));
            Element unitName_l3 = unitRoot.addElement("Name");
            unitName_l3.addAttribute("locale", "l3");
            unitName_l3.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfname_l3")));
            Element unitDes_l1 = unitRoot.addElement("Des");
            unitDes_l1.addAttribute("locale", "l1");
            unitDes_l1.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfdes_l1")));
            Element unitDes_l2 = unitRoot.addElement("Des");
            unitDes_l2.addAttribute("locale", "l2");
            unitDes_l2.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfdes_l2")));
            Element unitDes_l3 = unitRoot.addElement("Des");
            unitDes_l3.addAttribute("locale", "l3");
            unitDes_l3.setText(this.removeQuotes((String)sumUnitInfoMap.get("unitfdes_l3")));
            Element unitLevel = unitRoot.addElement("Level");
            Number level = (Number)sumUnitInfoMap.get("flevel");
            if (level == null) {
                unitLevel.setText("");
            } else {
                unitLevel.setText(level.toString());
            }
            Element orgNumber = unitRoot.addElement("OrgNumber");
            orgNumber.setText(this.removeQuotes((String)sumUnitInfoMap.get("orgnumber")));
            this.assembleSumUnitOrg((String)sumUnitInfoMap.get("unitid"), sumUnitOrgList, unitRoot);
        }
    }

    protected void assembleSumUnitOrg(String unitId, List sumUnitOrgList, Element unitRoot) {
        if (sumUnitOrgList == null || sumUnitOrgList.size() == 0) {
            return;
        }
        for (int i = sumUnitOrgList.size() - 1; i >= 0; --i) {
            Map sumUnitInfoMap = (Map)sumUnitOrgList.get(i);
            String sumUnitId = (String)sumUnitInfoMap.get("fsumunitid");
            if (StringUtil.isEmptyString((String)sumUnitId) || StringUtil.isEmptyString((String)unitId) || !sumUnitId.equals(unitId)) continue;
            Element sumUnitOrgRoot = unitRoot.addElement("SUMUNITORG");
            sumUnitOrgRoot.addAttribute("sumRangeNumber", unitRoot.attributeValue("sumRangeNumber"));
            Element orgNumber = sumUnitOrgRoot.addElement("OrgNumber");
            orgNumber.setText((String)sumUnitInfoMap.get("orgnumber"));
            Element sumUnitID = sumUnitOrgRoot.addElement("SumUnitID");
            sumUnitID.setText(sumUnitId);
            Element longNumber = sumUnitOrgRoot.addElement("LongNumber");
            longNumber.setText((String)sumUnitInfoMap.get("flongnumber"));
            Element orgName = sumUnitOrgRoot.addElement("OrgName");
            orgName.setText((String)sumUnitInfoMap.get("orgname"));
            sumUnitOrgList.remove(i);
        }
    }

    protected String getDisplayText(String text) {
        return text == null ? "" : text;
    }

    protected String removeQuotes(String text) {
        if ((text = this.getDisplayText(text)).indexOf("'") != -1) {
            text = text.replaceAll("'", "''");
        }
        return text;
    }

    protected void doExport(final Document document) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                KDFileChooser chooser;
                int r;
                String fileName = null;
                if (AbstractBaseExportXML.this.sumRangeInfoList != null && AbstractBaseExportXML.this.sumRangeInfoList.size() > 0) {
                    SumRangeInfo info = (SumRangeInfo)AbstractBaseExportXML.this.sumRangeInfoList.get(0);
                    String locale = SysContext.getSysContext().getLocale().getLanguage();
                    fileName = info.getName(locale);
                }
                if ((r = (chooser = new KDFileChooserProvider(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label42"), EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label51"), 0, "xml", 0).initFileChooser(fileName)).showSaveDialog((Component)AbstractBaseExportXML.this.parentUI)) != 0) return;
                String selectFilePath = chooser.getSelectedFile().getAbsolutePath().trim();
                if (selectFilePath.equals("")) {
                    ExtMsgBox.showInfo(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label55"));
                    return;
                }
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding("GBK");
                String fileType = chooser.getFileFilter().getDescription();
                File file = new File(selectFilePath + fileType);
                if (file.exists()) {
                    if (ExtMsgBox.showConfirm2("\u662f\u5426\u8986\u76d6\u5f53\u524d\u6587\u4ef6") != 0) return;
                    file.delete();
                } else {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        ExtMsgBox.showError("\u751f\u6210\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25");
                        AbstractBaseExportXML.this.log.error((Object)e);
                        return;
                    }
                }
                try {
                    XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), format);
                    writer.write(document);
                    writer.close();
                }
                catch (IOException e) {
                    ExtMsgBox.showError("\u751f\u6210\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25");
                    AbstractBaseExportXML.this.log.error((Object)e);
                    return;
                }
                MessageUtil.showInfo("\u5bfc\u51fa\u6210\u529f", false);
            }
        });
    }
}

