/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.IImport;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport.KDFileChooserProvider;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractBaseImportXML
implements IImport {
    Logger log = Logger.getLogger(AbstractBaseImportXML.class);
    protected CoreUI parentUI;
    protected ISumRangeService _service;
    protected int whichSubClass;
    protected KDFrame _owner;
    protected SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public AbstractBaseImportXML(CoreUI parentUI, int whichSubClass, KDFrame owner) {
        this.parentUI = parentUI;
        this._owner = owner;
        this.whichSubClass = whichSubClass;
    }

    public void importData() {
        KDFileChooser chooser = new KDFileChooserProvider(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label42"), "\u8bf7\u9009\u62e9\u4e00\u4e2a\u5bfc\u5165\u6587\u4ef6", 0, "xml", 0).initFileChooser(null);
        if (0 != chooser.showOpenDialog((Component)this.parentUI)) {
            return;
        }
        String selectFilePath = chooser.getSelectedFile().getAbsolutePath().trim();
        if (selectFilePath.equals("")) {
            ExtMsgBox.showInfo("\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u5230\u6587\u4ef6");
            return;
        }
        SAXReader reader = new SAXReader();
        File file = new File(selectFilePath);
        if (!file.exists()) {
            ExtMsgBox.showInfo("\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        if (file.length() == 0L) {
            String msg = "\u6ca1\u6709\u6570\u636e\u53ef\u4ee5\u5bfc\u5165\uff01";
            ExtMsgBox.showDetailAndOK((Component)this.parentUI, msg, msg, 2);
            return;
        }
        Document document = null;
        try {
            document = reader.read(file);
        }
        catch (Exception e) {
            String msg = "\u6587\u4ef6\u4e0d\u80fd\u5bfc\u5165\u3002\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u6216\u6587\u4ef6\u5185\u90e8\u683c\u5f0f\u662f\u5426\u9519\u8bef\uff01\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f\u5217\u793a\u5982\u4e0b\uff1a\n\n\n" + e.getMessage();
            ExtMsgBox.showDetailAndOK((Component)this.parentUI, "\u6587\u4ef6\u4e0d\u80fd\u5bfc\u5165\u3002\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u6216\u6587\u4ef6\u5185\u90e8\u683c\u5f0f\u662f\u5426\u9519\u8bef\uff01\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f", msg, 2);
            return;
        }
        this.doImport(document);
    }

    private void doImport(final Document document) {
        new Thread(new Runnable(){

            public void run() {
                Element root = document.getRootElement();
                HashMap sumRangeInfoMap = new HashMap();
                Object sumRangeInfo = null;
                try {
                    AbstractBaseImportXML.this.parseXMLAssembleSumRangeInfo(root, sumRangeInfoMap, sumRangeInfo);
                }
                catch (IllegalArgumentException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (SecurityException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (IllegalAccessException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (InvocationTargetException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (NoSuchMethodException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (NoSuchFieldException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                catch (ParseException e) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff01\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
                    AbstractBaseImportXML.this.log.error((Object)e);
                    return;
                }
                if (sumRangeInfoMap == null || sumRangeInfoMap.size() == 0) {
                    AbstractBaseImportXML.this.showSynchroMsg("\u6ca1\u6709\u6570\u636e\u53ef\u4ee5\u5bfc\u5165\uff01");
                    return;
                }
                AbstractBaseImportXML.this.getImportResult(sumRangeInfoMap);
            }
        }).start();
    }

    private void getImportResult(Map sumRangeInfoMap) {
        ArrayList sumRangeInfoList = new ArrayList();
        for (Object info : sumRangeInfoMap.values()) {
            if (info == null || sumRangeInfoList.contains(info)) continue;
            sumRangeInfoList.add(info);
        }
        StringBuffer errorMsgFromServ = new StringBuffer();
        boolean isAllSuccess = true;
        try {
            isAllSuccess = this._service.getExistSumRangeMsg(sumRangeInfoList, errorMsgFromServ, this.whichSubClass, this._owner);
        }
        catch (BOSException e) {
            this.showSynchroMsg("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7");
            this.log.error((Object)e);
            return;
        }
        this.showResultMessage(errorMsgFromServ.toString(), isAllSuccess);
    }

    private void showSynchroMsg(final String errorMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtMsgBox.showInfo(errorMsg);
            }
        });
    }

    private void showResultMessage(final String errorMsg, final boolean isSuccess) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (!isSuccess) {
                        ExtMsgBox.showDetailAndOK((Component)AbstractBaseImportXML.this.parentUI, "\u90e8\u5206\u6216\u5168\u90e8\u6570\u636e\u5bfc\u5165\u4e0d\u6210\u529f\uff0c\u5177\u4f53\u6587\u4ef6\u5bfc\u5165\u7ed3\u679c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f", errorMsg, 2);
                    }
                    try {
                        AbstractBaseImportXML.this.parentUI.getClass().getMethod("actionRefresh", null).invoke((Object)AbstractBaseImportXML.this.parentUI, null);
                    }
                    catch (IllegalArgumentException e) {
                        AbstractBaseImportXML.this.log.error((Object)e);
                    }
                    catch (SecurityException e) {
                        AbstractBaseImportXML.this.log.error((Object)e);
                    }
                    catch (IllegalAccessException e) {
                        AbstractBaseImportXML.this.log.error((Object)e);
                    }
                    catch (InvocationTargetException e) {
                        AbstractBaseImportXML.this.log.error((Object)e);
                    }
                    catch (NoSuchMethodException e) {
                        AbstractBaseImportXML.this.log.error((Object)e);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            this.log.error((Object)e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)e);
        }
    }

    private void parseXMLAssembleSumRangeInfo(Element root, Map sumRangeInfoMap, Object info) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException, ParseException {
        SumRangeInfo sumRangeInfo = null;
        String sumRangeNumber = null;
        ArrayList<Object> unitList = null;
        ArrayList<Object> orgList = null;
        List elements = root.elements();
        if (elements.size() == 0) {
            if (!(root.getName().toUpperCase().startsWith("SUMRANGE") || root.getName().toUpperCase().startsWith("SUMUNITINFO") || root.getName().toUpperCase().startsWith("SUMUNITORG"))) {
                this.invokeSetMethodByName(info, root);
            }
        } else {
            for (Element elem : elements) {
                if ("SUMRANGE".equals(elem.getName())) {
                    info = new SumRangeInfo();
                    sumRangeNumber = elem.attributeValue("sumRangeNumber");
                    if (!StringUtil.isEmptyString((String)sumRangeNumber) && !sumRangeInfoMap.containsKey(sumRangeNumber)) {
                        sumRangeInfoMap.put(sumRangeNumber, info);
                    }
                } else if ("SUMUNITINFO".equals(elem.getName())) {
                    info = new SumUnitInfo();
                    if ((sumRangeInfo = this.getSumRangeInfoFromMap(sumRangeInfoMap, sumRangeInfo, elem)) != null) {
                        unitList = sumRangeInfo.getUnitList() == null ? new ArrayList<Object>() : sumRangeInfo.getUnitList();
                        unitList.add(info);
                    }
                } else if ("SUMUNITORG".equals(elem.getName())) {
                    info = new SumUnitOrgInfo();
                    if ((sumRangeInfo = this.getSumRangeInfoFromMap(sumRangeInfoMap, sumRangeInfo, elem)) != null) {
                        orgList = sumRangeInfo.getOrgList() == null ? new ArrayList<Object>() : sumRangeInfo.getOrgList();
                        orgList.add(info);
                    }
                }
                this.parseXMLAssembleSumRangeInfo(elem, sumRangeInfoMap, info);
            }
        }
    }

    private SumRangeInfo getSumRangeInfoFromMap(Map sumRangeInfoMap, SumRangeInfo sumRangeInfo, Element elem) {
        String sumRangeNumber = elem.attributeValue("sumRangeNumber");
        sumRangeInfo = sumRangeInfoMap.containsKey(sumRangeNumber) ? (SumRangeInfo)sumRangeInfoMap.get(sumRangeNumber) : new SumRangeInfo();
        return sumRangeInfo;
    }

    private void invokeSetMethodByName(Object info, Element elem) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException {
        Class[] classObj;
        Object[] value;
        if (info == null) {
            return;
        }
        if (elem.getName().toUpperCase().startsWith("USINGFLAG") || elem.getName().toUpperCase().startsWith("LEVEL")) {
            value = new Object[]{Integer.decode(elem.getTextTrim())};
            classObj = new Class[]{Integer.TYPE};
        } else if (elem.getName().toUpperCase().startsWith("NAME") || elem.getName().toUpperCase().startsWith("DES")) {
            value = new Object[]{elem.getTextTrim(), elem.attributeValue("locale")};
            classObj = new Class[]{String.class, String.class};
        } else if (elem.getName().toUpperCase().startsWith("BEGINDATE") || elem.getName().toUpperCase().startsWith("ENDDATE")) {
            Timestamp date = null;
            if (!StringUtil.isEmptyString((String)elem.getTextTrim())) {
                date = new Timestamp(this.format.parse(elem.getTextTrim()).getTime());
            }
            value = new Object[]{date};
            classObj = new Class[]{Timestamp.class};
        } else {
            value = new Object[]{elem.getTextTrim()};
            classObj = new Class[]{String.class};
        }
        this.invokeSetMethod(info.getClass(), info, value, classObj, "set" + elem.getName());
    }

    private void invokeSetMethod(Class curClass, Object info, Object[] value, Class[] classObj, String nodeName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        curClass.getMethod(nodeName, classObj).invoke(info, value);
    }
}

