/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.importexport;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeFileChooserUI;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class KDFileChooserProvider {
    public String approveButtonText;
    public String title;
    public int dialogType;
    public String showFileType;
    public int fileSelectMode;
    public static final String POINT = ".";

    public KDFileChooserProvider() {
        this(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label42"), "", 0, "xml", 0);
    }

    public KDFileChooserProvider(String approveButtonText, String title, int dialogType, String showFileType, int fileSelectMode) {
        this.approveButtonText = approveButtonText;
        this.title = title;
        this.dialogType = dialogType;
        this.showFileType = showFileType;
        this.fileSelectMode = fileSelectMode;
    }

    public KDFileChooser initFileChooser(final String defaultFileName) {
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogType(this.dialogType);
        chooser.setFileSelectionMode(this.fileSelectMode);
        if (!StringUtil.isEmptyString((String)defaultFileName)) {
            chooser.setSelectedFile(new File(defaultFileName));
        }
        chooser.setDialogTitle(this.title);
        chooser.setApproveButtonText(this.approveButtonText);
        chooser.setApproveButtonToolTipText(this.approveButtonText);
        FileFilter[] ff = chooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            chooser.removeChoosableFileFilter(ff[i]);
        }
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                boolean returnValue = false;
                if (f != null) {
                    returnValue = defaultFileName != null && f.getName().equals(defaultFileName) ? true : KDFileChooserProvider.this.showFileType.equals(CtrlUtil.File.getExtension((File)f)) || f.isDirectory();
                }
                return returnValue;
            }

            public String getDescription() {
                return KDFileChooserProvider.POINT + KDFileChooserProvider.this.showFileType;
            }
        });
        new ImportExportFileChooserUI((JFileChooser)chooser).installUI((JComponent)chooser);
        File f = chooser.getCurrentDirectory();
        chooser.setCurrentDirectory(new File("c:\\"));
        chooser.setCurrentDirectory(f);
        return chooser;
    }

    private class ImportExportFileChooserUI
    extends KingdeeFileChooserUI {
        public ImportExportFileChooserUI(JFileChooser filechooser) {
            super(filechooser);
        }

        protected void setDirectorySelected(boolean directorySelected) {
            super.setDirectorySelected(directorySelected);
            JFileChooser chooser = this.getFileChooser();
            this.getApproveButton(chooser).setText(KDFileChooserProvider.this.approveButtonText);
            this.getApproveButton(chooser).setToolTipText(KDFileChooserProvider.this.approveButtonText);
        }

        public ListSelectionListener createListSelectionListener(JFileChooser fc) {
            return new BasicFileChooserUI.SelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        JFileChooser chooser = ImportExportFileChooserUI.this.getFileChooser();
                        FileSystemView fsv = chooser.getFileSystemView();
                        JList list = (JList)e.getSource();
                        if (!chooser.isMultiSelectionEnabled()) {
                            File file = (File)list.getSelectedValue();
                            if (file != null && file.isDirectory() && chooser.isTraversable(file) && (chooser.getFileSelectionMode() == 0 || !fsv.isFileSystem(file))) {
                                ImportExportFileChooserUI.this.setDirectorySelected(true);
                                ImportExportFileChooserUI.this.setDirectory(file);
                                chooser.setSelectedFile(null);
                            } else {
                                ImportExportFileChooserUI.this.setDirectorySelected(false);
                                if (file != null) {
                                    chooser.setSelectedFile(file);
                                }
                            }
                        }
                    }
                }
            };
        }
    }
}

