/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kds.impl.facade.tip.SpreadBorderLayout;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MultiLangUtil;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.BaseEditUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.EASInitOrgUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.IInitOrgUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitManagerUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.BaseDataInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.service.DebugSumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.model.DefaultInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.IInfo;
import com.kingdee.eas.base.reportmeta.sumreport.model.InfoException;
import com.kingdee.eas.base.reportmeta.sumreport.model.InfoMessagePanel;
import com.kingdee.eas.base.reportmeta.sumreport.service.SumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EXTUIUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class SumUnitEditUI
extends BaseEditUI {
    private Logger _logger = Logger.getLogger(SumUnitEditUI.class);
    private KDLabelContainer _lc1;
    private KDLabelContainer _lc2;
    private KDLabelContainer _lc3;
    private KDLabelContainer _lc4;
    private KDLabel _l5;
    private KDBizPromptBox _bpOrg;
    private KDBizPromptBox _bpParent;
    private KDToolBar _toolBar;
    private IInitOrgUI _orgInit;
    private ISumUnitService _srve;
    private SumUnitInfo _info;
    private String _rangeId;
    private SumUnitManagerUI _owner;
    private InfoMessagePanel _tipPanel;
    private KDPanel _board;
    public static final int TXT_ORG = 1 << _index++;
    public static final int TXT_PARENT = 1 << _index++;
    public static final int ALL_EDITOR = TXT_CODE | TXT_DEC | TXT_NAME | TXT_ORG | TXT_PARENT;
    private boolean _is4Debug;

    public SumUnitEditUI() {
        this(null, null, 1, false);
    }

    public SumUnitEditUI(KDDialog owner, String rangeId, int mode, boolean is4Debug) {
        super(owner, mode);
        this._rangeId = rangeId;
        this._orgInit = new EASInitOrgUI();
        this.init();
        this.initToolBar();
        this.doUILayout();
        this._is4Debug = is4Debug;
        this._srve = this._is4Debug ? new DebugSumUnitService() : new SumUnitService();
        if (owner instanceof SumUnitManagerUI) {
            this._owner = (SumUnitManagerUI)owner;
        }
    }

    private void doUILayout() {
        TableLayout2 ly = new TableLayout2(6, 2);
        ly.setColSpacing(0, 0);
        ly.setRowsSpacing(new int[]{0, 1, 2, 3, 4}, 3);
        ly.setFixedWidth(0, 84);
        ly.setRatableWidth(1, 242);
        ly.setFixedHeight(new int[]{0, 1, 2, 3, 4}, 21);
        ly.setRatableHeight(5, 120);
        this._board = new KDPanel((LayoutManager)ly);
        this._board.setCustomInsets(new Insets(10, 10, 10, 10));
        this._board.add((Component)this._lc1, (Object)TableLayout2.param((int)0, (int)0));
        this._board.add((Component)this._tfCode, (Object)TableLayout2.param((int)0, (int)1));
        this._board.add((Component)this._lc2, (Object)TableLayout2.param((int)1, (int)0));
        this._board.add((Component)this._mlbName, (Object)TableLayout2.param((int)1, (int)1));
        this._board.add((Component)this._lc3, (Object)TableLayout2.param((int)2, (int)0));
        this._board.add((Component)this._bpOrg, (Object)TableLayout2.param((int)2, (int)1));
        this._board.add((Component)this._lc4, (Object)TableLayout2.param((int)3, (int)0));
        this._board.add((Component)this._bpParent, (Object)TableLayout2.param((int)3, (int)1));
        this._board.add((Component)this._l5, (Object)TableLayout2.param((int)4, (int)0, (int)4, (int)1));
        this._board.add((Component)this._mlaDiscribe, (Object)TableLayout2.param((int)5, (int)0, (int)5, (int)1));
        this.getContentPane().setLayout((LayoutManager)new SpreadBorderLayout());
        this.getContentPane().add((Component)this._board, "Center");
    }

    private void initToolBar() {
        this._toolBar = new KDToolBar(0);
        this._toolBar.add((Component)this._btnNew);
        this._toolBar.add((Component)this._btnEdit);
        this._toolBar.add((Component)this._btnSave);
        this._toolBar.add((Component)this._btnClose);
        this.addToolBar((JToolBar)this._toolBar);
    }

    private void init() {
        this.setSize(new Dimension(317, 362));
        BaseEditUI.ActionDispatch action = new BaseEditUI.ActionDispatch();
        this._btnNew = new KDWorkButton();
        this._btnNew.setText("\u65b0\u5efa");
        this._btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this._btnNew.addActionListener((ActionListener)action);
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText("\u4fee\u6539");
        this._btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this._btnEdit.addActionListener((ActionListener)action);
        this._btnSave = new KDWorkButton();
        this._btnSave.setText("\u4fdd\u5b58");
        this._btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this._btnSave.addActionListener((ActionListener)action);
        this._btnClose = new KDWorkButton();
        this._btnClose.setText("\u5173\u95ed");
        this._btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this._btnClose.addActionListener((ActionListener)action);
        Dimension leftSize = new Dimension(84, 21);
        this._lc1 = new KDLabelContainer();
        this._lc1.setPreferredSize(leftSize);
        this._lc1.setBoundLabelText("\u7f16\u7801\uff1a");
        this._lc1.setBoundLabelUnderline(true);
        this._lc2 = new KDLabelContainer();
        this._lc2.setPreferredSize(leftSize);
        this._lc2.setBoundLabelText("\u540d\u79f0\uff1a");
        this._lc2.setBoundLabelUnderline(true);
        this._lc3 = new KDLabelContainer();
        this._lc3.setPreferredSize(leftSize);
        this._lc3.setBoundLabelText("\u7ba1\u7406\u7ec4\u7ec7\uff1a");
        this._lc3.setBoundLabelUnderline(true);
        this._lc4 = new KDLabelContainer();
        this._lc4.setPreferredSize(leftSize);
        this._lc4.setBoundLabelText("\u7236\u5355\u5143\uff1a");
        this._lc4.setBoundLabelUnderline(true);
        this._l5 = new KDLabel();
        this._l5.setText("\u5907\u6ce8\uff1a");
        this._l5.setPreferredSize(leftSize);
        Dimension rightSize = new Dimension(242, 21);
        this._tfCode = new KDTextField();
        this._tfCode.setPreferredSize(rightSize);
        this._mlbName = new KDBizMultiLangBox();
        this._mlbName.setPreferredSize(rightSize);
        this._mlaDiscribe = new KDBizMultiLangArea();
        this._mlaDiscribe.setPreferredSize(rightSize);
        EXTUIUtil.setDefalultLang(this._mlaDiscribe);
        EXTUIUtil.setDefalultLang(this._mlbName);
        this._bpOrg = new KDBizPromptBox();
        this._bpOrg.setSelector(this._orgInit.initOrgF7((KDPromptSelector)new OrgF7((Dialog)((Object)this))));
        this._bpOrg.setEnabledMultiSelection(false);
        this._bpOrg.setDisplayFormat("$name$");
        this._bpOrg.setEditFormat("$number$");
        this._bpOrg.setCommitFormat("$number$");
        this._bpOrg.setEditable(false);
        this._bpOrg.setPreferredSize(rightSize);
        this._bpParent = new KDBizPromptBox();
        this._bpParent.setEnabledMultiSelection(false);
        this._bpParent.setEditable(false);
        this._bpParent.setPreferredSize(rightSize);
    }

    public void setSumUnitF7(KDPromptSelector sumUnitF7, SelectorListener listener) {
        this._bpParent.setSelector(sumUnitF7);
        this._bpParent.addSelectorListener(listener);
    }

    public void setValue(SumUnitInfo value) {
        this._info = value;
        MultiLangUtil.setMlbValue(this._mlbName, value.getName());
        MultiLangUtil.setMlbValue(this._mlaDiscribe, value.getDes());
        this._tfCode.setText(value.getNumber());
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        info.setName(value.getManageOrgName());
        info.setNumber(value.getOrgNumber());
        info.setId(BOSUuid.read((String)value.getManageOrgID()));
        this._bpOrg.setData((Object)info);
        this._bpParent.setValue((Object)value.getParent());
        if (value.getParent() == null) {
            this._bpParent.setEnabled(false);
        }
    }

    public void setParentFieldData(SumUnitInfo parentVo) {
        this._bpParent.setEnabled(parentVo != null);
        this._bpParent.setData((Object)parentVo);
    }

    public void clearUI() {
        this._tfCode.setText(null);
        this._bpOrg.setText(null);
        this._bpOrg.setValue(null);
        this._bpParent.setValue(null);
        MultiLangUtil.clearMlbValue(this._mlbName);
        MultiLangUtil.clearMlbValue(this._mlaDiscribe);
        this._bpParent.setEnabled(true);
    }

    private void actionNew() {
        this.setTitle("\u65b0\u5efa\u6c47\u603b\u5355\u5143");
        if (this._tipPanel != null) {
            this._tipPanel.hideTip();
        }
        this.clearUI();
        this._mode = 1;
    }

    private void actionEdit() {
        this.setTitle("\u4fee\u6539\u6c47\u603b\u5355\u5143");
        this.setFlag(1 | BTN_SAVE);
        if (this._bpParent.getData() == null) {
            this._bpParent.setEnabled(false);
        }
        this._mode = 2;
    }

    private void handleInfoTips(IInfo e) {
        if (this._tipPanel == null) {
            this._tipPanel = new InfoMessagePanel(e.getInfo(), this.getContentPane(), this._board);
        }
        this._tipPanel.setTipString(e.getInfo());
        this.getContentPane().add((Component)((Object)this._tipPanel), "center_north");
        this._tipPanel.showTip();
        this.getContentPane().invalidate();
        this.getContentPane().repaint();
    }

    private void verifyEmpty() throws InfoException {
        if (StringUtil.isEmptyString((String)this._tfCode.getText()) || StringUtil.isEmptyString((String)this._tfCode.getText().trim())) {
            this._tfCode.setText(null);
            this.requestFocus((JComponent)this._tfCode);
            throw new InfoException("\u8bf7\u586b\u5199\u6c47\u603b\u5355\u5143\u7f16\u7801\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyString((String)((String)this._mlbName.getSelectedItemData())) || StringUtil.isEmptyString((String)((String)this._mlbName.getSelectedItemData()).trim())) {
            this._mlbName.setSelectedItemData(null);
            this.requestFocus((JComponent)this._mlbName);
            throw new InfoException("\u8bf7\u586b\u5199\u6c47\u603b\u5355\u5143\u540d\u79f0\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this._bpOrg.getData() == null) {
            this.requestFocus((JComponent)this._bpOrg);
            throw new InfoException("\u8bf7\u586b\u5199\u6c47\u603b\u5355\u5143\u7ba1\u7406\u7ec4\u7ec7\uff0c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(this._bpParent.getData() != null && this._bpParent.getData() != "" || this._owner.isEmpty())) {
            String parentID;
            if (this._info != null && this._mode == 2 && ((parentID = this._info.getParentID()) == null || StringUtil.isEmptyString((String)parentID))) {
                return;
            }
            this.requestFocus((JComponent)this._bpParent);
            throw new InfoException("\u8bf7\u9009\u62e9\u7236\u8282\u70b9\uff0c\u7236\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean verifySame(SumUnitInfo info) throws BOSException, InfoException {
        if (this._srve.isExistUnitName(info)) {
            this.requestFocus((JComponent)this._mlbName);
            throw new InfoException("\u5df2\u5b58\u5728\u540c\u540d\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u540d\u79f0");
        }
        if (this._srve.isExistUnitNumber(info)) {
            this.requestFocus((JComponent)this._tfCode);
            throw new InfoException("\u5df2\u5b58\u5728\u540c\u7f16\u7801\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u7f16\u7801");
        }
        return false;
    }

    private void actionUpdate() {
        try {
            this.verifyEmpty();
        }
        catch (InfoException e1) {
            this.handleInfoTips(e1);
            return;
        }
        SumUnitInfo oldVo = new SumUnitInfo(this._info);
        oldVo.setSumRangeID(this._rangeId);
        super.storeBaseValues();
        this._info.setNumber(this._tfCode.getText().trim());
        Object obj = this._bpParent.getData();
        if (obj instanceof SumUnitInfo) {
            this._info.setParentID(((SumUnitInfo)obj).getId());
            this._info.setLevel(((SumUnitInfo)obj).getLevel() + 1);
            this._info.setLongNumber(((SumUnitInfo)obj).getLongNumber() + this._info.getNumber() + "\\");
        } else if (obj == null || obj == "") {
            this._info.setLongNumber("\\" + this._info.getNumber() + "\\");
        }
        OrgUnitInfo org = (OrgUnitInfo)this._bpOrg.getData();
        this._info.setManageOrgID(org.getId().toString());
        this._info.setOrgNumber(org.getNumber());
        this._info.setManageOrgName(org.getName());
        try {
            this._srve.updateSumUnit(oldVo, this._info);
            this.handleInfoTips(new DefaultInfo("\u66f4\u65b0\u6210\u529f"));
            this._owner.getSumUnitTree().updateTree(this._info, !this._info.getNumber().equals(oldVo.getNumber()), !MixUtil.toString(this._info.getParentID()).equals(MixUtil.toString(oldVo.getParentID())), oldVo.getLongNumber());
        }
        catch (BOSException e) {
            this._logger.info((Object)"\u66f4\u65b0\u6c47\u603b\u5355\u5143\u51fa\u9519", (Throwable)e);
            this.showException(e, "\u66f4\u65b0\u6c47\u603b\u5355\u5143");
        }
        catch (InfoException e) {
            this.handleInfoTips(e);
        }
    }

    private void actionSave() {
        try {
            this.verifyEmpty();
        }
        catch (InfoException e1) {
            this.handleInfoTips(e1);
            return;
        }
        this._info = new SumUnitInfo();
        this._info.setSumRangeID(this._rangeId);
        this._info.setId(UID.create((int)44));
        this._info.setCreateTime(new Timestamp(new Date().getTime()));
        super.storeBaseValues();
        this._info.setNumber(this._tfCode.getText());
        Object obj = this._bpParent.getData();
        if (obj instanceof SumUnitInfo) {
            this._info.setParentID(((SumUnitInfo)obj).getId());
            this._info.setLevel(((SumUnitInfo)obj).getLevel() + 1);
            this._info.setLongNumber(((SumUnitInfo)obj).getLongNumber() + this._info.getNumber() + "\\");
        } else if (this._owner.isEmpty()) {
            this._info.setLongNumber("\\" + this._info.getNumber() + "\\");
        }
        OrgUnitInfo org = (OrgUnitInfo)this._bpOrg.getData();
        this._info.setManageOrgID(org.getId().toString());
        this._info.setOrgNumber(org.getNumber());
        this._info.setManageOrgName(org.getName());
        try {
            if (this.verifySame(this._info)) {
                return;
            }
            this._srve.newSumUnit(this._info);
            this.handleInfoTips(new DefaultInfo("\u65b0\u5efa\u6210\u529f"));
            this._owner.getSumUnitTree().insDelTreeNode(this._info, true);
        }
        catch (BOSException e) {
            this._logger.info((Object)"\u4fdd\u5b58\u6c47\u603b\u5355\u5143\u51fa\u9519", (Throwable)e);
            this.showException(e, "\u4fdd\u5b58\u6c47\u603b\u5355\u5143");
        }
        catch (InfoException e) {
            this.handleInfoTips(e);
        }
    }

    private void actionClose() {
        this.dispose();
    }

    public void setFlag(int flag) {
        super.setFlag(flag);
        this._bpOrg.setEnabled((this._flag & TXT_ORG) == 0);
        this._bpParent.setEnabled((this._flag & TXT_PARENT) == 0);
    }

    public BaseDataInfo getValue() {
        return this._info;
    }

    public int getMode() {
        return this._mode;
    }

    public void dispatchAction(ActionEvent e) {
        this.hideDynamicTips();
        Object src = e.getSource();
        if (src == this._btnNew) {
            this.actionNew();
        } else if (src == this._btnEdit) {
            this.actionEdit();
        } else if (src == this._btnSave) {
            if (this._mode == 2) {
                this.actionUpdate();
            } else {
                this.actionSave();
            }
        } else if (src == this._btnClose) {
            this.actionClose();
        }
    }

    private void hideDynamicTips() {
        if (this._tipPanel != null) {
            Container container = this.getContentPane();
            this._tipPanel.setPreferredSize(new Dimension(0, 0));
            container.remove((Component)((Object)this._tipPanel));
            Dimension d = this._board.getPreferredSize();
            this._board.setPreferredSize(new Dimension(d.width, d.height + 20));
            this._board.doLayout();
            container.invalidate();
            container.repaint();
        }
    }
}

