/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.EASInitOrgUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.base.IInitOrgUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitTree;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.service.DebugSumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.service.SumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class SumUnitManagerUI
extends KDDialog {
    private static final int COL_NUMBER = 0;
    private static final int COL_NAME = 1;
    private static final int COL_DES = 3;
    private static final int COL_ABBREVIATION = 2;
    private SumUnitTree _treeO;
    private KDTable _table;
    private KDWorkButton _btnRefresh;
    private KDWorkButton _btnSearch;
    private KDWorkButton _btnImportOrg;
    private KDWorkButton _btnExportOrg;
    private KDWorkButton _btnClose;
    private KDSplitPane _sppLeftRight;
    private KDToolBar _toolBar;
    private ISumUnitService _susrv;
    private IInitOrgUI _orgInit;
    private String _rangeId;
    private SumUnitOrgInfo _activeRowData;
    private boolean _includeSub;
    private boolean _isEnable = true;
    private boolean _is4Debug;

    public SumUnitManagerUI(String rangeId) {
        this(null, rangeId);
    }

    public SumUnitManagerUI(KDFrame owner, String rangeId) {
        this(owner, rangeId, false);
    }

    public SumUnitManagerUI(KDFrame owner, String rangeId, boolean is4Debug) {
        super((Frame)owner);
        this._rangeId = rangeId;
        this._is4Debug = is4Debug;
        this.init();
        this.doUILayout();
        this.initToolBar();
        this._orgInit = new EASInitOrgUI();
        this._susrv = this._is4Debug ? new DebugSumUnitService() : new SumUnitService();
    }

    public SumUnitTree getSumUnitTree() {
        return this._treeO;
    }

    public void setEnableUI(boolean enable) {
        this._isEnable = enable;
        if (!this._isEnable) {
            this._btnImportOrg.setEnabled(false);
            this._btnExportOrg.setEnabled(false);
            this._treeO.setEnableUI(false);
        }
    }

    private void doUILayout() {
        KDPanel panel = new KDPanel();
        panel.setCustomInsets(new Insets(0, 10, 10, 10));
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this._sppLeftRight, (Object)"Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
    }

    private void initToolBar() {
        this._toolBar = new KDToolBar(0);
        this._toolBar.add((Component)this._btnRefresh);
        this._toolBar.add((Component)this._btnSearch);
        this._toolBar.addSeparator();
        this._toolBar.add((Component)this._btnImportOrg);
        this._toolBar.add((Component)this._btnExportOrg);
        this._toolBar.addSeparator();
        this._toolBar.add((Component)this._btnClose);
        this._btnSearch.setVisible(false);
        this.addToolBar((JToolBar)this._toolBar);
    }

    private void init() {
        this.setTitle("\u6c47\u603b\u5355\u5143\u7ba1\u7406");
        this.setSize(870, 580);
        ActionDispatch action = new ActionDispatch();
        this._btnRefresh = new KDWorkButton();
        this._btnRefresh.addActionListener((ActionListener)action);
        this._btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this._btnRefresh.setText("\u5237\u65b0");
        this._btnSearch = new KDWorkButton();
        this._btnSearch.addActionListener((ActionListener)action);
        this._btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this._btnSearch.setText("\u5b9a\u4f4d");
        this._btnImportOrg = new KDWorkButton();
        this._btnImportOrg.addActionListener((ActionListener)action);
        this._btnImportOrg.setIcon(EASResource.getIcon((String)"imgTbtn_citetree"));
        this._btnImportOrg.setText("\u5f15\u5165\u7ec4\u7ec7");
        this._btnExportOrg = new KDWorkButton();
        this._btnExportOrg.addActionListener((ActionListener)action);
        this._btnExportOrg.setIcon(EASResource.getIcon((String)"imgTbtn_educecompany"));
        this._btnExportOrg.setText("\u5f15\u51fa\u7ec4\u7ec7");
        this._btnClose = new KDWorkButton();
        this._btnClose.addActionListener((ActionListener)action);
        this._btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this._btnClose.setText("\u9000\u51fa");
        try {
            this._treeO = new SumUnitTree(this._rangeId, this, this._is4Debug);
        }
        catch (BOSException e) {
            ExtMsgBox.showError((Component)((Object)this), "\u6784\u5efa\u6c47\u603b\u5355\u5143\u6811\u5931\u8d25", e.getCause().toString());
            this.dispose();
        }
        this._table = new KDTable();
        this._table.addColumns(4);
        this._table.getColumn(0).setWidth(128);
        this._table.getColumn(1).setWidth(128);
        this._table.getColumn(2).setWidth(128);
        this._table.getColumn(3).setWidth(128);
        this._table.getColumn(0).setSortable(true);
        IRow headR = this._table.addHeadRow();
        headR.getCell(0).setValue((Object)"\u7f16\u7801");
        headR.getCell(1).setValue((Object)"\u540d\u79f0");
        headR.getCell(2).setValue((Object)"\u7b80\u79f0");
        headR.getCell(3).setValue((Object)"\u63cf\u8ff0");
        this._table.setEditable(false);
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        KDTSortManager sortManager = new KDTSortManager(this._table);
        sortManager.setSortAuto(true);
        this._table.setSortMange(sortManager);
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ArrayList blocks;
                if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton((MouseEvent)e) && !(blocks = SumUnitManagerUI.this._table.getSelectManager().getBlocks()).isEmpty()) {
                    KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                    int top = block.getTop();
                    int bottom = block.getBottom();
                    if (bottom - top == 0) {
                        SumUnitManagerUI.this._activeRowData = (SumUnitOrgInfo)SumUnitManagerUI.this._table.getRow(top).getUserObject();
                    }
                }
            }
        });
        this._sppLeftRight = new KDSplitPane(1);
        this._sppLeftRight.setDividerLocation(260);
        KDPanel rightPanel = new KDPanel((LayoutManager)new BorderLayout());
        final KDCheckBox showLower = new KDCheckBox("\u5305\u62ec\u4e0b\u7ea7\u8282\u70b9");
        showLower.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumUnitManagerUI.this._includeSub = showLower.isSelected();
                SumUnitManagerUI.this.refreshSumUnitOrg();
            }
        });
        rightPanel.add((Component)showLower, (Object)"North");
        rightPanel.add((Component)this._table, (Object)"Center");
        this._sppLeftRight.setLeftComponent((Component)this._treeO.getUI());
        this._sppLeftRight.setRightComponent((Component)rightPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                SumUnitManagerUI.this._treeO.clearTreeCache();
                SumUnitManagerUI.this.removeWindowListener(this);
            }
        });
        this.setLocationRelativeTo(null);
    }

    private void actionImportOrg() {
        SumUnitInfo activeUnit = this._treeO.getActiveUnit();
        if (null == activeUnit) {
            WindowUtil.msgboxWarning((Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6c47\u603b\u5355\u5143", (String)"\u8b66\u544a", (Component)((Object)this));
            return;
        }
        OrgF7 imptOrgDialog = new OrgF7((Dialog)((Object)this));
        this._orgInit.initOrgF7((KDPromptSelector)imptOrgDialog);
        imptOrgDialog.setMultiSelect(true);
        imptOrgDialog.show();
        OrgUnitInfo[] data = (OrgUnitInfo[])imptOrgDialog.getData();
        if (null != data) {
            SumUnitOrgInfo[] orgsInfo = new SumUnitOrgInfo[data.length];
            for (int i = 0; i < data.length; ++i) {
                orgsInfo[i] = new SumUnitOrgInfo();
                orgsInfo[i].setOrgID(data[i].getId().toString());
                orgsInfo[i].setSumRangeID(this._rangeId);
                orgsInfo[i].setSumUnitID(activeUnit.getId());
                orgsInfo[i].setCreateTime(new Timestamp(new Date().getTime()));
                orgsInfo[i].setLongNumber(activeUnit.getLongNumber());
                orgsInfo[i].setOrgName(data[i].getName());
            }
            try {
                String msg = this._susrv.addCompany(orgsInfo);
                this.refreshSumUnitOrg();
                if (!StringUtil.isEmptyString((String)msg)) {
                    ExtMsgBox.showInfo((Component)((Object)this), msg);
                }
            }
            catch (BOSException e) {
                this.showException(e, "\u5f15\u5165\u7ec4\u7ec7\u5931\u8d25");
            }
        }
    }

    protected void showException(BOSException ex, String title) {
        MsgBox.setTitle((String)title);
        MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
    }

    private void actionExportOrg() {
        if (this._activeRowData == null) {
            WindowUtil.msgboxWarning((Object)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u7ec4\u7ec7\u8bb0\u5f55", (String)"\u8b66\u544a", (Component)((Object)this));
            return;
        }
        boolean comfirm = WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u786e\u8ba4\u5f15\u51fa\u9009\u62e9\u7684\u7ec4\u7ec7", (String)"\u5f15\u51fa\u7ec4\u7ec7");
        if (comfirm) {
            try {
                this._susrv.delCompany(this._activeRowData);
                this._activeRowData = null;
                this.refreshSumUnitOrg();
                ExtMsgBox.showInfo((Component)((Object)this), "\u5f15\u51fa\u7ec4\u7ec7\u6210\u529f\uff01");
            }
            catch (BOSException e) {
                this.showException(e, "\u5f15\u51fa\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25");
            }
        }
    }

    public void refreshSumUnitOrg() {
        SumUnitInfo activeUnit = this._treeO.getActiveUnit();
        if (null == activeUnit) {
            this._table.removeRows();
            return;
        }
        try {
            Vector vRs = null;
            vRs = this._includeSub ? this._susrv.querySumUnitOrgIncluSub(this._rangeId, activeUnit.getNumber()) : this._susrv.querySumUnitOrg(activeUnit.getId());
            this._table.removeRows();
            if (vRs != null && vRs.size() > 0) {
                this._table.setUserObject((Object)vRs);
                int size = vRs.size();
                for (int i = 0; i < size; ++i) {
                    SumUnitOrgInfo item = (SumUnitOrgInfo)vRs.get(i);
                    IRow row = this._table.addRow();
                    row.getCell(0).setValue((Object)item.getOrgNumber());
                    row.getCell(1).setValue((Object)item.getOrgName());
                    row.getCell(2).setValue((Object)item.getOrgAbbreviatioin());
                    row.getCell(3).setValue((Object)item.getOrgDes());
                    row.setUserObject((Object)item);
                }
            }
        }
        catch (BOSException e) {
            this.showException(e, "\u5237\u65b0\u7ec4\u7ec7\u5217\u8868\u5931\u8d25");
        }
    }

    public boolean isEmpty() {
        return this._treeO.isEmpty();
    }

    public void actionRefresh() throws BOSException {
        this._treeO.refresh();
        this.refreshSumUnitOrg();
    }

    public void actionClose() {
        this.setVisible(false);
    }

    private class ActionDispatch
    implements ActionListener {
        private ActionDispatch() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Object src = e.getSource();
                if (src == SumUnitManagerUI.this._btnRefresh) {
                    SumUnitManagerUI.this.actionRefresh();
                } else if (src == SumUnitManagerUI.this._btnImportOrg) {
                    SumUnitManagerUI.this.actionImportOrg();
                } else if (src == SumUnitManagerUI.this._btnExportOrg) {
                    SumUnitManagerUI.this.actionExportOrg();
                } else if (src == SumUnitManagerUI.this._btnClose) {
                    SumUnitManagerUI.this.actionClose();
                }
            }
            catch (BOSException ex) {
                SumUnitManagerUI.this.showException(ex, "\u5f02\u5e38");
            }
        }
    }
}

