/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.base.reportmeta.sumreport.client.icon.UploadSumIcons;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.tree.IEach;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.tree.TreeUtil;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitEditUI;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitF7;
import com.kingdee.eas.base.reportmeta.sumreport.client.sumrange.unit.SumUnitManagerUI;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.debug.service.DebugSumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.service.SumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumUnitService;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SumUnitTree {
    private Logger _logger = Logger.getLogger(SumUnitTree.class);
    private KDTree _tree;
    private KDTreeView _treeView;
    private KDWorkButton _btnNew;
    private KDWorkButton _btnView;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDel;
    private String _rangeId;
    private SumUnitEditUI _editUI;
    private SumUnitManagerUI _owner;
    private SumUnitInfo _activeNode;
    private boolean _rootActive;
    private boolean _empty;
    private boolean _isEnable = true;
    private boolean _isDebug;
    private ISumUnitService _srsv;
    private Map _treeCache;

    public SumUnitTree(String rangeId, SumUnitManagerUI owner, boolean isDebug) throws BOSException {
        this._rangeId = rangeId;
        this._owner = owner;
        this._isDebug = isDebug;
        this._srsv = this._isDebug ? new DebugSumUnitService() : new SumUnitService();
        this.init();
        this.initCtrlPane();
        this.loadData();
    }

    public void setEnableUI(boolean enable) {
        this._isEnable = enable;
        if (!this._isEnable) {
            this._btnNew.setEnabled(false);
            this._btnEdit.setEnabled(false);
            this._btnDel.setEnabled(false);
        }
    }

    private void initCtrlPane() {
        ActionDispatch action = new ActionDispatch();
        this._btnNew = new KDWorkButton();
        this._btnNew.setText(null);
        this._btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this._btnNew.addActionListener((ActionListener)action);
        this._btnView = new KDWorkButton();
        this._btnView.setText(null);
        this._btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this._btnView.addActionListener((ActionListener)action);
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText(null);
        this._btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this._btnEdit.addActionListener((ActionListener)action);
        this._btnDel = new KDWorkButton();
        this._btnDel.setText(null);
        this._btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this._btnDel.addActionListener((ActionListener)action);
        this._treeView.getControlPane().add((Component)this._btnNew);
        this._treeView.getControlPane().add((Component)this._btnView);
        this._treeView.getControlPane().add((Component)this._btnEdit);
        this._treeView.getControlPane().add((Component)this._btnDel);
    }

    private void init() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        treeModel.setAsksAllowsChildren(true);
        this._tree = new KDTree();
        this._tree.setModel((TreeModel)treeModel);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        this._tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SumUnitTree.this._activeNode != null) {
                    SumUnitTree.this.actionView();
                }
            }
        });
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultKingdeeTreeNode activeNode = (DefaultKingdeeTreeNode)SumUnitTree.this._tree.getLastSelectedPathComponent();
                if (activeNode == null) {
                    return;
                }
                if (activeNode != null) {
                    SumUnitTree.this._rootActive = activeNode.isRoot();
                    SumUnitTree.this._activeNode = (SumUnitInfo)activeNode.getUserObject();
                    DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)activeNode.getParent();
                    SumUnitTree.this._activeNode.setParent(parentNode == null ? null : (SumUnitInfo)parentNode.getUserObject());
                    SumUnitTree.this._owner.refreshSumUnitOrg();
                } else {
                    SumUnitTree.this._activeNode = null;
                }
            }
        });
        this._treeView = new KDTreeView(this._tree);
        this._treeView.setShowButton(false);
    }

    private void loadData() throws BOSException {
        SumUnitInfo rootUnit = this._srsv.buildSumUnitTree(this._rangeId);
        if (null != rootUnit) {
            this._empty = false;
            DefaultKingdeeTreeNode newRoot = SumUnitTree.createTreeNode(rootUnit);
            this._tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)newRoot));
            this._tree.expandOnLevel(1);
            this._tree.setRootVisible(true);
        } else {
            this._empty = true;
            this._tree.setModel(null);
        }
        this._activeNode = null;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public void refresh() throws BOSException {
        this.loadData();
        this.clearTreeCache();
    }

    public JComponent getUI() {
        return this._treeView;
    }

    public KingdeeTreeModel getModel() {
        return (KingdeeTreeModel)this._tree.getModel();
    }

    private JComponent cloneTree() {
        TreeModel model = this._tree.getModel();
        KDTree tree = new KDTree(true);
        if (model != null) {
            DefaultKingdeeTreeNode srcR = (DefaultKingdeeTreeNode)model.getRoot();
            DefaultKingdeeTreeNode dstR = this.cloneSingleNode(srcR);
            KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)dstR);
            treeModel.setAsksAllowsChildren(true);
            tree.setModel((TreeModel)treeModel);
            tree.expandAllNodes(true, (TreeNode)dstR);
        } else {
            tree.setModel(null);
        }
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(this._tree.isRootVisible());
        tree.setShowsRootHandles(true);
        return tree;
    }

    private DefaultKingdeeTreeNode cloneSingleNode(DefaultKingdeeTreeNode srcNode) {
        DefaultKingdeeTreeNode dstNode = new DefaultKingdeeTreeNode(srcNode.getUserObject(), srcNode.getCustomIcon());
        dstNode.setText(srcNode.getText());
        Enumeration children = srcNode.children();
        dstNode.setAllowsChildren(srcNode.getChildCount() != 0);
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode srcChild = (DefaultKingdeeTreeNode)children.nextElement();
            DefaultKingdeeTreeNode dstChild = this.cloneSingleNode(srcChild);
            dstNode.add((MutableTreeNode)dstChild);
        }
        return dstNode;
    }

    public static DefaultKingdeeTreeNode createTreeNode(SumUnitInfo info) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)info, (Icon)UploadSumIcons.createIcon("sum_unit.gif"));
        newNode.setText(info.getName());
        newNode.setUserObject((Object)info);
        Vector children = info.getChildren();
        if (null != children && children.size() > 0) {
            for (Object obj : children) {
                Serializable item;
                if (obj instanceof SumUnitInfo) {
                    item = (SumUnitInfo)obj;
                    newNode.add((MutableTreeNode)SumUnitTree.createTreeNode(item));
                    continue;
                }
                if (!(obj instanceof SumUnitOrgInfo)) continue;
                item = (SumUnitOrgInfo)obj;
                newNode.add((MutableTreeNode)SumUnitTree.createTreeNode((SumUnitOrgInfo)item));
            }
        }
        return newNode;
    }

    private static DefaultKingdeeTreeNode createTreeNode(SumUnitOrgInfo org) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)org, EASResource.getIcon((String)"imgTree_company"));
        newNode.setText(org.getOrgName());
        newNode.setUserObject((Object)org);
        return newNode;
    }

    private void disableAllCmps(Container parentUI, Container excluse) {
        Component[] childs;
        if (null != parentUI && null != (childs = parentUI.getComponents()) && childs.length > 0) {
            for (int i = 0; i < childs.length; ++i) {
                Component c = childs[i];
                if (c == excluse) continue;
                c.setEnabled(false);
                this.disableAllCmps((Container)c, excluse);
            }
        }
    }

    private void initalEditUI(int mode) {
        this._editUI = new SumUnitEditUI(this._owner, this._rangeId, mode, this._isDebug);
        final SumUnitF7 unitF7 = new SumUnitF7((KDTree)this.cloneTree(), this._editUI);
        this._editUI.setSumUnitF7(unitF7, new SelectorListener(){

            public void willShow(SelectorEvent e) {
                final KDTree tree = (KDTree)SumUnitTree.this.cloneTree();
                SumUnitEditUI owner = ((SumUnitF7)((KDBizPromptBox)e.getSource()).getSelector()).getOwner();
                if (owner.getMode() == 2) {
                    SumUnitInfo info = (SumUnitInfo)owner.getValue();
                    final String id = info.getId();
                    TreeUtil.depthFirstTravel((DefaultKingdeeTreeNode)tree.getModel().getRoot(), new IEach(){

                        public void each(DefaultKingdeeTreeNode node) {
                            SumUnitInfo curInfo = (SumUnitInfo)node.getUserObject();
                            if (id.equals(curInfo.getId())) {
                                ((KingdeeTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
                            }
                        }
                    });
                }
                unitF7.updateData(tree);
            }
        });
        this._editUI.setModal(true);
        this._editUI.setLocationRelativeTo(null);
        this._editUI.setDefaultCloseOperation(2);
        this._editUI.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                if (!SumUnitTree.this._isEnable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SumUnitTree.this.disableAllCmps((Container)((Object)SumUnitTree.this._editUI), SumUnitTree.this._editUI.getCloseBtn());
                        }
                    });
                }
            }
        });
    }

    public SumUnitInfo getActiveUnit() {
        return this._activeNode;
    }

    private void actionNew() {
        this.initalEditUI(1);
        this._editUI.clearUI();
        this._editUI.setTitle("\u65b0\u5efa\u6c47\u603b\u5355\u5143");
        this._editUI.setFlag(1 | SumUnitEditUI.BTN_SAVE);
        SumUnitInfo parentUnit = this._activeNode;
        if (parentUnit == null && this._tree.isRootVisible() && this._tree.getModel() != null) {
            parentUnit = (SumUnitInfo)((DefaultKingdeeTreeNode)this._tree.getModel().getRoot()).getUserObject();
        }
        this._editUI.setParentFieldData(parentUnit);
        this._editUI.setVisible(true);
    }

    private boolean verify() {
        if (this._activeNode == null) {
            WindowUtil.msgboxWarning((Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6c47\u603b\u5355\u5143", (String)"\u8b66\u544a", (Component)((Object)this._owner));
            return false;
        }
        return true;
    }

    private void actionEdit() {
        if (!this.verify()) {
            return;
        }
        this.initalEditUI(2);
        this._editUI.clearUI();
        this._editUI.setTitle("\u4fee\u6539\u6c47\u603b\u5355\u5143");
        this._editUI.setFlag(1 | SumUnitEditUI.BTN_SAVE);
        this._editUI.setValue(this._activeNode);
        this._editUI.setVisible(true);
    }

    private void actionView() {
        if (!this.verify()) {
            return;
        }
        this.initalEditUI(1);
        this._editUI.clearUI();
        this._editUI.setTitle("\u67e5\u770b\u6c47\u603b\u5355\u5143");
        this._editUI.setFlag(SumUnitEditUI.BTN_EDIT | SumUnitEditUI.ALL_EDITOR);
        this._editUI.setValue(this._activeNode);
        this._editUI.setVisible(true);
    }

    private void actionDel() {
        if (!this.verify()) {
            return;
        }
        boolean comfirm = WindowUtil.msgboxYesNo((Component)((Object)this._owner), (Object)"\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u6c47\u603b\u5355\u5143", (String)"\u5220\u9664\u6c47\u603b\u5355\u5143");
        if (comfirm) {
            try {
                this._activeNode.setSumRangeID(this._rangeId);
                this._srsv.delSumUnit(this._activeNode);
                if (this._rootActive) {
                    this._tree.setRootVisible(false);
                    this._tree.invalidate();
                    this._tree.repaint();
                }
                this.insDelTreeNode(this._activeNode, false);
                this._activeNode = null;
                this._owner.refreshSumUnitOrg();
            }
            catch (BOSException e) {
                this._logger.info((Object)"\u5220\u9664\u6c47\u603b\u5355\u5143\u9519\u8bef", (Throwable)e);
                WindowUtil.msgboxError((Object)"\u5220\u9664\u6c47\u603b\u5355\u5143\u9519\u8bef", (String)"\u9519\u8bef", (Component)((Object)this._owner));
            }
        }
    }

    public DefaultKingdeeTreeNode locateSpecifyNode(String key) {
        if (this._treeCache == null) {
            this.initTreeCache();
        }
        return (DefaultKingdeeTreeNode)this._treeCache.get(key);
    }

    private void initTreeCache() {
        int size = 30;
        TreeModel treeModel = this._tree.getModel();
        if (treeModel != null) {
            size = treeModel.getChildCount(treeModel.getRoot()) << 4;
        }
        this._treeCache = new HashMap(size);
        if (treeModel == null) {
            return;
        }
        TreeUtil.depthFirstTravel((DefaultKingdeeTreeNode)treeModel.getRoot(), new IEach(){

            public void each(DefaultKingdeeTreeNode node) {
                SumUnitInfo unitInfo = (SumUnitInfo)node.getUserObject();
                SumUnitTree.this._treeCache.put(unitInfo.getId(), node);
            }
        });
    }

    public synchronized void clearTreeCache() {
        if (this._treeCache != null) {
            this._treeCache.clear();
            this._treeCache = null;
        }
    }

    public synchronized void insDelTreeNode(SumUnitInfo info, boolean insert) {
        if (insert) {
            KingdeeTreeModel model = (KingdeeTreeModel)this._tree.getModel();
            DefaultKingdeeTreeNode curNode = SumUnitTree.createTreeNode(info);
            if (model != null) {
                DefaultKingdeeTreeNode parentNode = this.locateSpecifyNode(info.getParentID());
                model.insertNodeInto((MutableTreeNode)curNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
            } else {
                this._tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)curNode));
                this._tree.setRootVisible(true);
                this._empty = false;
                this._tree.repaint();
                this._treeView.repaint();
                this.initTreeCache();
            }
            this._treeCache.put(info.getId(), curNode);
            TreePath treePath = new TreePath(curNode.getPath());
            if (curNode.getParent() != null) {
                treePath = new TreePath(((DefaultKingdeeTreeNode)curNode.getParent()).getPath());
            }
            this._tree.expandPath(treePath);
        } else {
            KingdeeTreeModel model = (KingdeeTreeModel)this._tree.getModel();
            DefaultKingdeeTreeNode curNode = this.locateSpecifyNode(info.getId());
            if (model.getRoot() != curNode) {
                DefaultKingdeeTreeNode parentNode = this.locateSpecifyNode(info.getParentID());
                curNode.setParent((MutableTreeNode)parentNode);
                model.removeNodeFromParent((MutableTreeNode)curNode);
            } else {
                this._tree.setModel(null);
                this._empty = true;
            }
            this._treeCache.remove(info.getId());
        }
    }

    public synchronized void updateTree(SumUnitInfo info, boolean updateNumber, boolean updateParent, String oldLongNumber) {
        Object updator;
        DefaultKingdeeTreeNode curNode = this.locateSpecifyNode(info.getId());
        curNode.setUserObject((Object)info);
        curNode.setText(info.getName());
        ((DefaultTreeModel)this._tree.getModel()).nodeChanged((TreeNode)curNode);
        if (updateNumber) {
            updator = new LongNumberUpdator(curNode, oldLongNumber, info.getLongNumber());
            ((LongNumberUpdator)updator).doUpdate();
        }
        if (updateParent) {
            updator = new ParentUpdator(curNode, info.getParentID());
            ((ParentUpdator)updator).doUpdate();
        }
        this._tree.invalidate();
        this._tree.repaint();
        this._tree.doLayout();
        this._treeView.doLayout();
    }

    private class ParentUpdator {
        private DefaultKingdeeTreeNode _root;
        private String _newParent;

        public ParentUpdator(DefaultKingdeeTreeNode root, String newParent) {
            this._root = root;
            this._newParent = newParent;
        }

        public void doUpdate() {
            this.updateNodeParent();
            DefaultKingdeeTreeNode newParentNode = SumUnitTree.this.locateSpecifyNode(this._newParent);
            KingdeeTreeModel model = (KingdeeTreeModel)SumUnitTree.this._tree.getModel();
            model.removeNodeFromParent((MutableTreeNode)this._root);
            model.insertNodeInto((MutableTreeNode)this._root, (MutableTreeNode)newParentNode, newParentNode.getChildCount());
            TreePath treePath = new TreePath(newParentNode.getPath());
            SumUnitTree.this._tree.expandPath(treePath);
        }

        private void updateNodeParent() {
            SumUnitInfo curInfo = (SumUnitInfo)this._root.getUserObject();
            Enumeration enumer = this._root.children();
            while (enumer.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)enumer.nextElement();
                SumUnitInfo childInfo = (SumUnitInfo)child.getUserObject();
                childInfo.setParentID(this._newParent);
                childInfo.setParent(curInfo);
            }
        }
    }

    private class LongNumberUpdator {
        private DefaultKingdeeTreeNode _root;
        private String _oldLongNumber;
        private String _newLongNumber;

        public LongNumberUpdator(DefaultKingdeeTreeNode root, String oldLongNumber, String newLongNumber) {
            this._root = root;
            this._newLongNumber = newLongNumber;
            this._oldLongNumber = oldLongNumber;
        }

        public void doUpdate() {
            this.updateLongNumber(this._root, this._newLongNumber, this._oldLongNumber, true);
        }

        private void updateLongNumber(DefaultKingdeeTreeNode node, String newLongNumber, String oldLongNumber, boolean recurrenceRoot) {
            if (!recurrenceRoot) {
                SumUnitInfo curInfo = (SumUnitInfo)node.getUserObject();
                String longNumber = curInfo.getLongNumber();
                if (!StringUtil.isEmptyString((String)longNumber)) {
                    longNumber = newLongNumber + longNumber.substring(oldLongNumber.length());
                }
                curInfo.setLongNumber(longNumber);
            }
            Enumeration enumer = node.children();
            while (enumer.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)enumer.nextElement();
                this.updateLongNumber(child, newLongNumber, oldLongNumber, false);
            }
        }
    }

    private class ActionDispatch
    implements ActionListener {
        private ActionDispatch() {
        }

        public void actionPerformed(ActionEvent e) {
            Object srcO = e.getSource();
            if (srcO == SumUnitTree.this._btnNew) {
                SumUnitTree.this.actionNew();
            } else if (srcO == SumUnitTree.this._btnEdit) {
                SumUnitTree.this.actionEdit();
            } else if (srcO == SumUnitTree.this._btnView) {
                SumUnitTree.this.actionView();
            } else if (srcO == SumUnitTree.this._btnDel) {
                SumUnitTree.this.actionDel();
            }
        }
    }
}

