/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.task.algorithm;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.sumreport.client.task.algorithm.PeriodSettingPanel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

class PeriodCalculator {
    private PeriodSettingPanel _panel;
    private ReportSnapType _type;
    private DateFormat _dateFromat;
    private Calendar _calendar;
    private String _notePrefix = "\u6ce8\u610f\uff1a\u4e0a\u62a5\u5468\u671f\u4ece";

    public PeriodCalculator(PeriodSettingPanel panel, ReportSnapType type) {
        this._panel = panel;
        this._type = type;
        this._dateFromat = new SimpleDateFormat("yyyy-MM-dd");
        this._calendar = Calendar.getInstance();
    }

    public String revert() {
        if (this._type == ReportSnapType.UNKNOW) {
            this._panel._dpFrom.setValue((Object)this._panel._start, false);
            this._panel._dpTo.setValue((Object)this._panel._end, false);
        } else if (this._type == ReportSnapType.YEAR) {
            this._calendar.setTime(this._panel._start);
            int year = this._calendar.get(1);
            this._panel._spinYear.setValue((Object)new Integer(year), false);
        } else if (this._type == ReportSnapType.MONTH) {
            this._calendar.setTime(this._panel._start);
            int year = this._calendar.get(1);
            this._panel._spinYear.setValue((Object)new Integer(year), false);
            this._panel._cbMonth.setSelectedIndex(this._calendar.get(2), false);
        } else if (this._type == ReportSnapType.QUARTER) {
            this.revertQuarter();
        } else if (this._type == ReportSnapType.MONTHHALF) {
            this._calendar.setTime(this._panel._start);
            String start = this._dateFromat.format(this._calendar.getTime());
            String year = start.substring(0, 4);
            this._panel._spinYear.setValue((Object)new Integer(year), false);
            int month = Integer.parseInt(start.substring(5, 7));
            this._panel._cbMonth.setSelectedIndex(month - 1, false);
            int halfMonth = "01".equals(start.substring(8)) ? 0 : 1;
            this._panel._cbHalfModth.setSelectedIndex(halfMonth, true);
        } else if (this._type == ReportSnapType.WEEK) {
            this.revertWeek();
        } else if (this._type == ReportSnapType.DAY) {
            this._calendar.setTime(this._panel._start);
            this._panel._dpDay.setValue((Object)this._calendar.getTime(), false);
        } else if (this._type == ReportSnapType.YEARHALF) {
            this._calendar.setTime(this._panel._start);
            int year = this._calendar.get(1);
            this._panel._spinYear.setValue((Object)new Integer(year), false);
            String start = this._dateFromat.format(this._calendar.getTime());
            int halfYear = "01".equals(start.substring(5, 7)) ? 0 : 1;
            this._panel._cbHalfYear.setSelectedIndex(halfYear, true);
        }
        return this.getNote(this._panel._start, this._panel._end);
    }

    public String cal() throws ParseException {
        if (this._panel._spinYear != null) {
            this._panel._spinYear.commitEdit();
        }
        String from = "";
        String to = "";
        if (this._type == ReportSnapType.UNKNOW) {
            this._panel._dpFrom.commitEdit();
            this._panel._dpTo.commitEdit();
            from = this._panel._dpFrom.getText();
            to = this._panel._dpTo.getText();
        } else if (this._type == ReportSnapType.YEAR) {
            String year = this._panel._spinYear.getValue().toString();
            from = year + "-01-01";
            to = year + "-12-31";
        } else if (this._type == ReportSnapType.MONTH) {
            String year = this._panel._spinYear.getValue().toString();
            int month = this._panel._cbMonth.getSelectedIndex() + 1;
            this._calendar.setTime(this._dateFromat.parse(year + "-" + (month > 9 ? "" + month : "0" + month) + "-01"));
            from = this._dateFromat.format(this._calendar.getTime());
            this._calendar.add(2, 1);
            this._calendar.add(5, -1);
            to = this._dateFromat.format(this._calendar.getTime());
        } else {
            if (this._type == ReportSnapType.QUARTER) {
                return this.calQuarter(from, to);
            }
            if (this._type == ReportSnapType.MONTHHALF) {
                String year = this._panel._spinYear.getValue().toString();
                int month = this._panel._cbMonth.getSelectedIndex() + 1;
                if (this._panel._cbHalfModth.getSelectedIndex() == 0) {
                    from = year + "-" + (month > 9 ? "" + month : "0" + month) + "-01";
                    to = year + "-" + (month > 9 ? "" + month : "0" + month) + "-15";
                } else {
                    this._calendar.setTime(this._dateFromat.parse(year + "-" + (month > 9 ? "" + month : "0" + month) + "-01"));
                    this._calendar.add(2, 1);
                    this._calendar.add(5, -1);
                    from = year + "-" + (month > 9 ? "" + month : "0" + month) + "-16";
                    to = this._dateFromat.format(this._calendar.getTime());
                }
            } else {
                if (this._type == ReportSnapType.WEEK) {
                    return this.calWeek(from, to);
                }
                if (this._type == ReportSnapType.DAY) {
                    this._panel._dpDay.commitEdit();
                    from = this._panel._dpDay.getText();
                    to = this._panel._dpDay.getText();
                } else if (this._type == ReportSnapType.YEARHALF) {
                    String year = this._panel._spinYear.getValue().toString();
                    switch (this._panel._cbHalfYear.getSelectedIndex()) {
                        case 0: {
                            from = year + "-01-01";
                            to = year + "-06-30";
                            break;
                        }
                        case 1: {
                            from = year + "-07-01";
                            to = year + "-12-31";
                        }
                    }
                }
            }
        }
        return this.getNote(from, to);
    }

    private String getNote(String from, String to) throws ParseException {
        StringBuffer noteBuf = new StringBuffer();
        noteBuf.append(this._notePrefix);
        noteBuf.append(from).append(" \u5230 ").append(to);
        this._panel._start = this._dateFromat.parse(from);
        this._panel._end = this._dateFromat.parse(to);
        return noteBuf.toString();
    }

    private String getNote(Date start, Date end) {
        StringBuffer noteBuf = new StringBuffer();
        noteBuf.append(this._notePrefix);
        String from = this._dateFromat.format(start);
        String to = this._dateFromat.format(end);
        noteBuf.append(from).append(" \u5230 ").append(to);
        return noteBuf.toString();
    }

    private String calQuarter(String from, String to) throws ParseException {
        String year = this._panel._spinYear.getValue().toString();
        switch (this._panel._cbQuarter.getSelectedIndex()) {
            case 0: {
                from = "01-01";
                to = "03-31";
                break;
            }
            case 1: {
                from = "04-01";
                to = "06-30";
                break;
            }
            case 2: {
                from = "07-01";
                to = "09-30";
                break;
            }
            default: {
                from = "10-01";
                to = "12-31";
            }
        }
        from = year + "-" + from;
        to = year + "-" + to;
        return this.getNote(from, to);
    }

    private void revertQuarter() {
        this._calendar.setTime(this._panel._start);
        int year = this._calendar.get(1);
        this._panel._spinYear.setValue((Object)new Integer(year), false);
        String start = this._dateFromat.format(this._calendar.getTime());
        int idx = (Integer.parseInt(start.substring(5, 7)) - 1) / 3;
        this._panel._cbQuarter.setSelectedIndex(idx, false);
    }

    private String calWeek(String from, String to) throws ParseException {
        String year = this._panel._spinYear.getValue().toString();
        int month = this._panel._cbMonth.getSelectedIndex() + 1;
        Date date = this._dateFromat.parse(year + "-" + (month > 9 ? "" + month : "0" + month) + "-01");
        this._calendar.setTime(date);
        this._calendar.set(7, this._panel._cbWeekBegin.getSelectedIndex() + 1);
        int week = this._panel._cbWeek.getSelectedIndex();
        this._calendar.add(5, week * 7);
        from = this._dateFromat.format(this._calendar.getTime());
        this._calendar.add(5, 6);
        to = this._dateFromat.format(this._calendar.getTime());
        return this.getNote(from, to);
    }

    private void revertWeek() {
        this._calendar.setTime(this._panel._start);
        int year = this._calendar.get(1);
        this._panel._spinYear.setValue((Object)new Integer(year), false);
        String start = this._dateFromat.format(this._calendar.getTime());
        int month = Integer.parseInt(start.substring(5, 7));
        this._panel._cbMonth.setSelectedIndex(month - 1, false);
        this._calendar.set(7, this._panel._cbWeekBegin.getSelectedIndex() + 1);
        int weekth = this._calendar.get(4);
        if (weekth < 5) {
            this._panel._cbWeek.setSelectedIndex(weekth - 1, false);
        } else {
            String end = this._dateFromat.format(this._panel._end);
            int newMonth = Integer.parseInt(end.substring(5, 7));
            this._panel._cbMonth.setSelectedIndex(newMonth - 1, false);
            this._panel._cbWeek.setSelectedIndex(weekth - 5, false);
        }
    }

    public void setNotePrefix(String notePrefix) {
        if (StringUtil.isEmptyString((String)notePrefix)) {
            return;
        }
        this._notePrefix = notePrefix;
    }
}

