/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.client.task.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.reportmeta.sumreport.data.F7VO;
import com.kingdee.eas.base.reportmeta.sumreport.debug.service.DebugSumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.service.SumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumRangeService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SumRangeF7
implements KDPromptSelector {
    private Logger _logger = Logger.getLogger(SumRangeF7.class);
    private KDDialog _win;
    private boolean _isCancel;
    private KDTable _table;
    private KDWorkButton _btnSearch;
    private KDWorkButton _btnRefresh;
    private KDWorkButton _btnOk;
    private KDWorkButton _btnCancel;
    private KDTextField _klValue;
    private KDComboBox _kcbOptions;
    private boolean _codeFilter;
    private KDPromptBox _host;
    private ISumRangeService _srsv;
    private boolean _is4Debug;

    public SumRangeF7(KDDialog _owner, KDPromptBox host, boolean is4Debug) {
        this._win = new KDDialog((Dialog)_owner);
        this._host = host;
        this._is4Debug = is4Debug;
        this.init();
        this.initLayout();
    }

    private SumRangeF7(KDFrame frame) {
        this._win = new KDDialog((Frame)frame);
        this.init();
        this.initLayout();
    }

    private void init() {
        this._win.setTitle("\u9009\u62e9\u6c47\u603b\u8303\u56f4");
        this._win.setModal(true);
        this._klValue = new KDTextField();
        this._kcbOptions = new KDComboBox(new Object[]{"\u540d\u79f0", "\u7f16\u7801"});
        this._kcbOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = SumRangeF7.this._kcbOptions.getSelectedIndex();
                if (idx == 1) {
                    SumRangeF7.this._codeFilter = true;
                } else {
                    SumRangeF7.this._codeFilter = false;
                }
            }
        });
        this._btnSearch = new KDWorkButton();
        this._btnSearch.setText("\u641c\u7d22");
        this._btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this._btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumRangeF7.this.filter(SumRangeF7.this._klValue.getText());
            }
        });
        this._btnRefresh = new KDWorkButton();
        this._btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this._btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumRangeF7.this.refresh();
            }
        });
        this._table = new KDTable();
        this._table.addColumns(2);
        this._table.getColumn(1).setWidth(200);
        IRow header = this._table.addHeadRow();
        header.getCell(0).setValue((Object)"\u7f16\u7801");
        header.getCell(1).setValue((Object)"\u540d\u79f0");
        this._table.getStyleAttributes().setLocked(true);
        this._table.getSelectManager().setSelectMode(2);
        this._btnOk = new KDWorkButton("\u786e\u5b9a");
        this._btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumRangeF7.this._isCancel = false;
                SumRangeF7.this._win.setVisible(false);
                SumRangeF7.this._host.setData(SumRangeF7.this.getData());
            }
        });
        this._btnCancel = new KDWorkButton("\u53d6\u6d88");
        this._btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SumRangeF7.this._isCancel = true;
                SumRangeF7.this._win.setVisible(false);
                SumRangeF7.this._host.setData(SumRangeF7.this.getData());
            }
        });
        this._table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    SumRangeF7.this._isCancel = true;
                    SumRangeF7.this._win.setVisible(false);
                    SumRangeF7.this._host.setData(SumRangeF7.this.getData());
                }
            }
        });
        this._srsv = this._is4Debug ? new DebugSumRangeService() : new SumRangeService();
    }

    private void initLayout() {
        KDPanel contentPane = new KDPanel();
        contentPane.setPreferredSize(new Dimension(361, 479));
        this._win.setContentPane((Container)contentPane);
        this._klValue.setPreferredSize(new Dimension(120, 21));
        this._kcbOptions.setPreferredSize(new Dimension(55, 21));
        this._btnSearch.setPreferredSize(new Dimension(55, 21));
        this._btnRefresh.setPreferredSize(new Dimension(27, 21));
        KDPanel board = new KDPanel((LayoutManager)new BorderLayout());
        board.setCustomInsets(new Insets(10, 10, 10, 10));
        TableLayout2 ly2 = new TableLayout2(2, 4);
        ly2.setFixedHeight(0, 21);
        ly2.setFixedHeight(1, 3);
        ly2.setFixedWidth(0, 55);
        ly2.setRatableWidth(1, 120);
        ly2.setFixedWidth(2, 55);
        ly2.setFixedWidth(3, 27);
        ly2.setColsSpacing(TableLayout2.ALL, 3);
        KDPanel toolPl = new KDPanel((LayoutManager)ly2);
        toolPl.add((Component)this._kcbOptions, (Object)TableLayout2.param((int)0, (int)0));
        toolPl.add((Component)this._klValue, (Object)TableLayout2.param((int)0, (int)1));
        toolPl.add((Component)this._btnSearch, (Object)TableLayout2.param((int)0, (int)2));
        toolPl.add((Component)this._btnRefresh, (Object)TableLayout2.param((int)0, (int)3));
        board.add((Component)toolPl, (Object)"North");
        board.add((Component)this._table, (Object)"Center");
        this._win.getContentPane().setLayout(new BorderLayout());
        this._win.getContentPane().add((Component)board, "Center");
        TableLayout2 ly = new TableLayout2(3, 5);
        ly.setRatableWidth(0, 100);
        ly.setFixedWidth(1, 74);
        ly.setFixedWidth(2, 3);
        ly.setFixedWidth(3, 74);
        ly.setFixedWidth(4, 10);
        ly.setFixedHeight(0, 10);
        ly.setFixedHeight(1, 21);
        ly.setFixedHeight(2, 10);
        KDPanel bottom = new KDPanel((LayoutManager)ly);
        KDSeparator separator = new KDSeparator();
        bottom.add((Component)separator, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)4));
        bottom.add((Component)this._btnOk, (Object)TableLayout2.param((int)1, (int)1));
        bottom.add((Component)this._btnCancel, (Object)TableLayout2.param((int)1, (int)3));
        this._win.getContentPane().add((Component)bottom, "South");
        this._win.setLocationRelativeTo(null);
    }

    public Object getData() {
        if (this._table.getRowCount() == 0) {
            return null;
        }
        KDTSelectBlock block = this._table.getSelectManager().get(0);
        int row = null == block ? 0 : block.getBeginRow();
        F7VO vo = (F7VO)this._table.getRow(row).getUserObject();
        return vo;
    }

    public boolean isCanceled() {
        return this._isCancel;
    }

    public void show() {
        this._win.pack();
        this._win.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SumRangeF7.this._klValue.requestFocus();
                SumRangeF7.this.refresh();
            }
        });
        this._win.setVisible(true);
    }

    private void filter(String value) {
        int count = this._table.getRowCount();
        for (int i = 0; i < count; ++i) {
            F7VO vo = (F7VO)this._table.getRow(i).getUserObject();
            if (!this._codeFilter) {
                if (vo.getName().indexOf(value) == -1) {
                    this._table.getRow(i).getStyleAttributes().setHided(true);
                    continue;
                }
                this._table.getRow(i).getStyleAttributes().setHided(false);
                continue;
            }
            if (vo.getCode().indexOf(value) == -1) {
                this._table.getRow(i).getStyleAttributes().setHided(true);
                continue;
            }
            this._table.getRow(i).getStyleAttributes().setHided(false);
        }
    }

    private void refresh() {
        try {
            List rsL = this._srsv.getLaunchedRanges(EASUtil.gelLoginLocal());
            this._table.removeRows();
            int size = rsL.size();
            for (int i = 0; i < size; ++i) {
                F7VO vo = (F7VO)rsL.get(i);
                IRow row = this._table.addRow();
                row.getCell(1).setValue((Object)vo.getName());
                row.getCell(0).setValue((Object)vo.getCode());
                row.setUserObject((Object)vo);
            }
        }
        catch (BOSException e) {
            this._logger.info((Object)"\u67e5\u8be2\u5df2\u7ecf\u542f\u7528\u7684\u7528\u6237\u8303\u56f4\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CtrlUIEnv.setKingdeeLAF();
                SumRangeF7 f7 = new SumRangeF7(new KDFrame());
                f7.show();
            }
        });
    }
}

