/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.debug.client.task.main;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.SnapOrgSelector;
import com.kingdee.eas.base.reportmeta.sumreport.debug.client.task.main.DebugTaskMainUI;
import com.kingdee.eas.base.reportmeta.sumreport.debug.model.DebugUserOrgModel;
import com.kingdee.eas.base.reportmeta.sumreport.util.ExtMsgBox;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

class UserOrgSettingUI
extends KDDialog {
    private DebugTaskMainUI _ownerUI;
    private KDBizPromptBox _userPBox;
    private KDBizPromptBox _orgPBox;
    private KDCheckBox _cbInCU;
    private KDCheckBox _cbOpenEachTime;
    private KDWorkButton _btnOK;
    private KDWorkButton _btnCancel;
    private KDWorkButton _btnReset;
    private KDLabelContainer _lc;
    private KDLabelContainer _lc1;
    private boolean _isInCU = true;
    private DebugUserOrgModel _model;
    private static final String INIT_EXCEPTION = "\u521d\u59cb\u8bbe\u7f6e\u8fd0\u884c\u62a5\u8868\u4eba\u8eab\u4efd\u754c\u9762\u5931\u8d25\uff1a";

    public UserOrgSettingUI(DebugTaskMainUI ownerUI) {
        super((Frame)((Object)ownerUI), true);
        this.setResizable(false);
        this._ownerUI = ownerUI;
        this.setTitle("\u8bbe\u7f6e\u62a5\u8868\u8fd0\u884c\u7528\u6237");
        this._model = DebugUserOrgModel.getInst(this._ownerUI.getTaskID(), true);
        this.initUI();
        this.doUILayout();
        this.installListeners();
    }

    private void initUI() {
        this.setDefaultCloseOperation(1);
        this.setSize(384, 220);
        this._lc = new KDLabelContainer();
        this._lc.setBoundLabelText("\u7528\u6237\uff1a");
        this._lc.setBoundLabelUnderline(true);
        Dimension leftDim = new Dimension(74, 21);
        this._lc.setPreferredSize(leftDim);
        this._userPBox = new KDBizPromptBox();
        Dimension rightDim = new Dimension(242, 21);
        this._userPBox.setPreferredSize(rightDim);
        this._userPBox.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this._userPBox.setDisplayFormat("$name$");
        this._userPBox.setEditFormat("$number$");
        this._userPBox.setCommitFormat("$number$");
        this._userPBox.setData((Object)this._model.getCurrentUser());
        this._lc1 = new KDLabelContainer();
        this._lc1.setBoundLabelText("\u6240\u5c5e\u7ec4\u7ec7\uff1a");
        this._lc1.setBoundLabelUnderline(true);
        this._lc1.setPreferredSize(leftDim);
        this._orgPBox = new KDBizPromptBox();
        this._orgPBox.setPreferredSize(rightDim);
        OrgF7 orgF7 = new OrgF7((Dialog)((Object)this));
        orgF7.setMultiSelect(false);
        this._orgPBox.setSelector((KDPromptSelector)orgF7);
        this._orgPBox.setDisplayFormat("$name$");
        this._orgPBox.setEditFormat("$number$");
        this._orgPBox.setCommitFormat("$number$");
        this._orgPBox.setData((Object)this._model.getCurrentOrg());
        this._cbInCU = new KDCheckBox("F7\u63a7\u4ef6\u6570\u636e\u9650\u5236\u4e8e\u5f53\u524dCU\u7ba1\u8f96\u5185\u7528\u6237\u4e0e\u7ec4\u7ec7");
        this._userPBox.setEditable(false);
        this._orgPBox.setEditable(false);
        this._cbInCU.setSelected(this._isInCU);
        this._cbInCU.setPreferredSize(new Dimension(150, 21));
        if (this._isInCU) {
            this.updateUserF7View();
        }
        this._cbOpenEachTime = new KDCheckBox("\u8fd0\u884c\u62a5\u8868\u65f6\u6bcf\u6b21\u6253\u5f00");
        this._cbOpenEachTime.setSelected(false);
        this._cbOpenEachTime.setPreferredSize(new Dimension(150, 21));
        this._btnOK = new KDWorkButton("\u786e\u5b9a");
        this._btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserOrgSettingUI.this.actionOK();
            }
        });
        this._btnCancel = new KDWorkButton("\u53d6\u6d88");
        this._btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserOrgSettingUI.this.setVisible(false);
            }
        });
        this._btnReset = new KDWorkButton("\u91cd\u7f6e");
        this._btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserOrgSettingUI.this.actionReset();
            }
        });
        this._btnReset.setPreferredSize(new Dimension(74, 21));
        this._btnOK.setPreferredSize(new Dimension(74, 21));
        this._btnCancel.setPreferredSize(new Dimension(74, 21));
    }

    public void updateUserF7View() {
        try {
            ObjectUuidPK currentUserPK = new ObjectUuidPK(this._model.getCurrentUser().getId());
            EntityViewInfo view = this.getUserCondition((IObjectPK)currentUserPK);
            this._userPBox.setEntityViewInfo(view);
        }
        catch (Exception e1) {
            ExtMsgBox.showError((Component)((Object)this), "\u521d\u59cb\u8bbe\u7f6e\u8fd0\u884c\u62a5\u8868\u4eba\u8eab\u4efd\u754c\u9762\u5931\u8d25\uff1a\u4fee\u6539\u7528\u6237\u5931\u8d25", e1.toString());
        }
    }

    private void installListeners() {
        this._cbInCU.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UserOrgSettingUI.this._isInCU = e.getStateChange() == 1;
                if (UserOrgSettingUI.this._isInCU) {
                    UserOrgSettingUI.this.updateUserF7View();
                } else {
                    UserOrgSettingUI.this._userPBox.setEntityViewInfo(null);
                }
            }
        });
        this._cbOpenEachTime.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UserOrgSettingUI.this._ownerUI.setOpenIndentifySettingEachTime(e.getStateChange() == 1);
            }
        });
        this._userPBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                IObjectPK userPK = UserOrgSettingUI.this.getSelectedUserPK();
                if (userPK == null) {
                    UserOrgSettingUI.this._orgPBox.setData(null);
                    UserOrgSettingUI.this._orgPBox.setEnabled(false);
                    return;
                }
                OrgF7 orgF7 = (OrgF7)UserOrgSettingUI.this._orgPBox.getSelector();
                try {
                    SnapOrgSelector.setReportOrgF7Property(orgF7, UserOrgSettingUI.this.getSelectedUserPK());
                }
                catch (Exception e) {
                    ExtMsgBox.showError((Component)((Object)UserOrgSettingUI.this), "\u521d\u59cb\u8bbe\u7f6e\u8fd0\u884c\u62a5\u8868\u4eba\u8eab\u4efd\u754c\u9762\u5931\u8d25\uff1a\u4fee\u6539\u7ec4\u7ec7\u5931\u8d25", e.toString());
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                Object user = UserOrgSettingUI.this._userPBox.getData();
                Object org = UserOrgSettingUI.this._orgPBox.getData();
                DebugUserOrgModel model = DebugUserOrgModel.getInst(UserOrgSettingUI.this._ownerUI.getTaskID(), false);
                if (user == null || org == null) {
                    model.reset();
                }
            }
        });
    }

    private void doUILayout() {
        TableLayout2 ly = new TableLayout2(4, 5);
        ly.setFixedWidth(new int[]{0, 2, 3, 4}, 74);
        ly.setFixedHeight(new int[]{1, 3}, 21);
        ly.setRatableHeight(0, 69);
        ly.setFixedHeight(2, 3);
        ly.setRatableWidth(1, 15);
        ly.setColsSpacing(new int[]{0, 1}, 0);
        ly.setColsSpacing(new int[]{2, 3}, 3);
        ly.setRowSpacing(0, 6);
        ly.setRowsSpacing(new int[]{1, 2}, 9);
        KDPanel board = new KDPanel((LayoutManager)ly);
        board.setCustomInsets(new Insets(10, 10, 10, 10));
        TableLayout2 innerLy = new TableLayout2(3, 2);
        innerLy.setFixedWidth(0, 74);
        innerLy.setRatableWidth(1, 242);
        innerLy.setFixedHeight(new int[]{0, 1}, 21);
        innerLy.setRatableHeight(2, 21);
        innerLy.setRowsSpacing(TableLayout2.ALL, 3);
        innerLy.setColsSpacing(TableLayout2.ALL, 0);
        KDContainer container = new KDContainer();
        container.setTitle("\u7528\u6237\u8bbe\u7f6e");
        container.setEnableActive(false);
        KDPanel innerPanel = new KDPanel((LayoutManager)innerLy);
        container.setContentPane((Container)innerPanel);
        innerPanel.setCustomInsets(new Insets(3, 3, 0, 3));
        innerPanel.add((Component)this._lc, (Object)TableLayout2.param((int)0, (int)0));
        innerPanel.add((Component)this._userPBox, (Object)TableLayout2.param((int)0, (int)1));
        innerPanel.add((Component)this._lc1, (Object)TableLayout2.param((int)1, (int)0));
        innerPanel.add((Component)this._orgPBox, (Object)TableLayout2.param((int)1, (int)1));
        innerPanel.add((Component)this._cbInCU, (Object)TableLayout2.param((int)2, (int)1));
        board.add((Component)container, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)4));
        board.add((Component)this._cbOpenEachTime, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)4));
        board.add((Component)new KDSeparator(), (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)4));
        board.add((Component)this._btnReset, (Object)TableLayout2.param((int)3, (int)2));
        board.add((Component)this._btnOK, (Object)TableLayout2.param((int)3, (int)3));
        board.add((Component)this._btnCancel, (Object)TableLayout2.param((int)3, (int)4));
        this.setContentPane((Container)board);
    }

    private void actionOK() {
        Object user = this._userPBox.getData();
        Object org = this._orgPBox.getData();
        if (user == null) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (org == null) {
            ExtMsgBox.showInfo((Component)((Object)this), "\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this._model.setCurrentUser((UserInfo)user);
        this._model.setCurrentOrg((OrgUnitInfo)org);
        this.setVisible(false);
    }

    private void actionReset() {
        this._model.reset();
        this._userPBox.setDataNoNotify((Object)this._model.getCurrentUser());
        this._orgPBox.setDataNoNotify((Object)this._model.getCurrentOrg());
        this.invalidate();
        this.repaint();
    }

    private IObjectPK getSelectedUserPK() {
        Object user = this._userPBox.getData();
        if (user == null) {
            return null;
        }
        return new ObjectUuidPK(((UserInfo)user).getId());
    }

    private EntityViewInfo getUserCondition(IObjectPK currentUserPK) throws Exception {
        boolean bizAdmin;
        FilterInfo filter = new FilterInfo();
        boolean cuAdmin = Administrator.isCUAdmin(null, (IObjectPK)currentUserPK);
        filter = cuAdmin | (bizAdmin = Administrator.isBizAdmin(null, (IObjectPK)currentUserPK)) ? this.getAdminUserCondition(currentUserPK, cuAdmin) : this.getCommonUserCondition(currentUserPK);
        filter.mergeFilter(this.getAdminExceptFilter(), "and");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private FilterInfo getAdminUserCondition(IObjectPK currentUserPK, boolean isCUAdmin) throws Exception {
        List manageCuIDList = null;
        OrgRangeType orgRangeType = isCUAdmin ? OrgRangeType.BIZ_ORG_TYPE : OrgRangeType.MANAGE_ORG_TYPE;
        manageCuIDList = PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)orgRangeType);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)manageCuIDList), CompareType.INNER));
        return filterInfo;
    }

    private FilterInfo getAdminExceptFilter() {
        return Administrator.getNotAdminUserFilter();
    }

    private FilterInfo getCommonUserCondition(IObjectPK currentUserPK) {
        FilterInfo filter = new FilterInfo();
        StringBuffer filterBuf = new StringBuffer();
        filterBuf.append("SELECT DISTINCT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUserPK).append("' ");
        filterBuf.append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(currentUserPK.toString()).append("' ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterBuf.toString(), CompareType.INNER));
        return filter;
    }
}

