/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.server.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISumRangeBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SumRangeBOFacade
implements ISumRangeBOFacade {
    private static Logger log = LogUtil.getPackageLogger(SumRangeBOFacade.class);

    public List getUsingRangeList(String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID, s.FNumber, s.FBeginDate, s.FEndDate, s.FLastUpdateUserID, s.FLastUpdateTime, ");
        sbSQL.append("s.Fname_").append(localString).append(" as range_name, ");
        sbSQL.append("s.Fdes_").append(localString).append(" as range_des, ");
        sbSQL.append("u.Fname_").append(localString).append(" as updateuser_name ");
        sbSQL.append("from T_EXT_SumRange s LEFT OUTER JOIN t_pm_user u on s.FLastUpdateUserID = u.fid ");
        sbSQL.append("where s.FUsingFlag = 1 ");
        sbSQL.append("order by s.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), null);
    }

    public List getLaunchedRanges(String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID as id , s.FNumber as code,  ");
        sbSQL.append("s.Fname_").append(localString).append(" as name ");
        sbSQL.append("from T_EXT_SumRange s ");
        sbSQL.append("where s.FUsingFlag = 1 ");
        sbSQL.append("order by s.flastupdatetime desc");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), null);
    }

    public List getRangList(String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID as id , s.FNumber as code, s.FBeginDate as startTime, s.FEndDate as stopTime, s.FLastUpdateUserID , s.FLastUpdateTime as editedTime, s.fusingflag as status, ");
        sbSQL.append("s.Fname_").append(localString).append(" as name, ");
        sbSQL.append("s.Fdes_").append(localString).append(" as discribe, ");
        sbSQL.append("u.Fname_").append(localString).append(" as editedPerson ");
        sbSQL.append("from T_EXT_SumRange s LEFT OUTER JOIN t_pm_user u on s.FLastUpdateUserID = u.fid ");
        sbSQL.append("order by s.fcreatetime desc");
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), null);
    }

    public List getCurrentOrgUnitListByRangeID(String rangeID, String localString) throws SumRangeException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select su.FID as id, su.FNumber as num, su.FLongNumber as longnumber, su.fmanageorgid as manageorgid,su.FParentID as pid,");
        sbSQL.append(" su.FLevel as lev,  ");
        sbSQL.append("su.Fname_").append(localString).append(" as name, ");
        sbSQL.append("su.Fdes_").append(localString).append(" as dec ,");
        sbSQL.append("org.Fname_").append(localString).append(" as orgname,");
        sbSQL.append("org.fnumber as orgnumber ");
        sbSQL.append(" from T_EXT_SumUnit as su left outer join T_ORG_BaseUnit org on su.fmanageorgid=org.fid ");
        sbSQL.append("where su.FSumRangeID = ? ");
        sbSQL.append(" order by su.flevel asc,su.fcreatetime asc");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        try {
            return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public boolean isExistRangeNumber(String fid, String fnumber) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (fid == null || fid.length() == 0) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumRange WHERE fnumber = ? ");
            queryValue.add(fnumber);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumRange WHERE fid <> ? AND fnumber = ? ");
            queryValue.add(fid);
            queryValue.add(fnumber);
        }
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        return !map.isEmpty();
    }

    public boolean isExistRangeName(String fid, String fname, String localString) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (fid == null || fid.length() == 0) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumRange WHERE FName_").append(localString).append(" = ? ");
            queryValue.add(fname);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumRange WHERE fid <> ? and FName_").append(localString).append(" = ? ");
            queryValue.add(fid);
            queryValue.add(fname);
        }
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        return !map.isEmpty();
    }

    public boolean isExistUnitNumber(String fid, String fnumber, String rangeID) throws SumRangeException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (fid == null || fid.length() == 0) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumUnit WHERE fnumber = ? and FSumRangeID = ?");
            queryValue.add(fnumber);
            queryValue.add(rangeID);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumUnit WHERE fid <> ? AND fnumber = ? and FSumRangeID = ?");
            queryValue.add(fid);
            queryValue.add(fnumber);
            queryValue.add(rangeID);
        }
        try {
            HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
            return !map.isEmpty();
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public boolean isExistUnitName(String fid, String fname, String localString, String rangeID) throws SumRangeException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (fid == null || fid.length() == 0) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumUnit WHERE FName_").append(localString).append(" = ? and FSumRangeID = ?");
            queryValue.add(fname);
            queryValue.add(rangeID);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_SumUnit WHERE fid <> ? and FName_").append(localString).append(" = ? and FSumRangeID = ?");
            queryValue.add(fid);
            queryValue.add(fname);
            queryValue.add(rangeID);
        }
        try {
            HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
            return !map.isEmpty();
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public void insertSumRange(SumRangeInfo sumRangeInfo) throws BOSException {
        String sql = "insert into T_EXT_SumRange(FID, FNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FUsingFlag, FCreatorID, FCreateTime) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Timestamp createTime = new Timestamp(new Date().getTime());
        sumRangeInfo.setCreateTime(createTime);
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(sumRangeInfo.getId());
        queryValue.add(sumRangeInfo.getNumber());
        queryValue.add(sumRangeInfo.getName("l2"));
        queryValue.add(sumRangeInfo.getName("l3"));
        queryValue.add(sumRangeInfo.getDes("l2"));
        queryValue.add(sumRangeInfo.getDes("l3"));
        queryValue.add(new Integer(sumRangeInfo.getUsingFlag()));
        queryValue.add(sumRangeInfo.getCreator());
        queryValue.add(sumRangeInfo.getCreateTime());
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql, queryValue);
    }

    public SumRangeInfo getSumRangeInfoByID(String rangeID, String localString) throws BOSException {
        SumRangeInfo sumRangeInfo = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select FID, FNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FUsingFlag ");
        sbSQL.append("from T_EXT_SumRange ");
        sbSQL.append("where FID = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        if (!map.isEmpty()) {
            sumRangeInfo = new SumRangeInfo();
            sumRangeInfo.setId(CtrlReportUtil.getObjectString(map.get("fid")));
            sumRangeInfo.setNumber(CtrlReportUtil.getObjectString(map.get("fnumber")));
            sumRangeInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            sumRangeInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            sumRangeInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            sumRangeInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            int usingFlag = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("fusingflag")));
            sumRangeInfo.setUsingFlag(usingFlag);
        }
        return sumRangeInfo;
    }

    public void updateSumRange(SumRangeInfo sumRangeInfo) throws BOSException {
        String sql = "update T_EXT_SumRange set FNumber = ?, FName_l2 = ?, FName_l3 = ?, FDes_l2 = ?, FDes_l3 = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FID = ? ";
        Timestamp updateTime = new Timestamp(new Date().getTime());
        sumRangeInfo.setLastUpdateTime(updateTime);
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(sumRangeInfo.getNumber());
        queryValue.add(sumRangeInfo.getName("l2"));
        queryValue.add(sumRangeInfo.getName("l3"));
        queryValue.add(sumRangeInfo.getDes("l2"));
        queryValue.add(sumRangeInfo.getDes("l3"));
        queryValue.add(sumRangeInfo.getUpdateUserId());
        queryValue.add(sumRangeInfo.getLastUpdateTime());
        queryValue.add(sumRangeInfo.getId());
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql, queryValue);
    }

    public boolean isRangeReference(String rangeID) throws BOSException {
        String sql = "select top 1 * from T_EXT_TaskDistribute where FSumRangeID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
        return !map.isEmpty();
    }

    public void deleteSumRange(List rangeIDs) throws BOSException {
        ArrayList<String> sqlList = new ArrayList<String>();
        int size = rangeIDs.size();
        for (int i = 0; i < size; ++i) {
            String rangeID = (String)rangeIDs.get(i);
            String sumSQL = "delete T_EXT_SumRange where fid = '" + rangeID + "'";
            String unitSQL = "delete T_EXT_SumUnit where FSumRangeID = '" + rangeID + "'";
            String unitOrgSQL = "delete T_EXT_SumUnitOrg where FSumRangeID = '" + rangeID + "'";
            sqlList.add(unitOrgSQL);
            sqlList.add(unitSQL);
            sqlList.add(sumSQL);
        }
        sqlList.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
    }

    public boolean isCanStopRange(String rangeID) throws BOSException {
        String sql = "select top 1 t.FStatus from T_EXT_TaskDistribute t WHERE t.FStatus = 1 and  t.FSumRangeID = ? ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
        return map.isEmpty();
    }

    public void setSumRangeUsing(List rangeIDs, int status) throws BOSException {
        String now = MixUtil.getToDay();
        String partSql = " FUsingFlag = 0 ";
        switch (status) {
            case 1: {
                partSql = " FUsingFlag = 1,FBeginDate ={ts'" + now + "'} ," + "FEndDate = null ";
                break;
            }
            case 2: {
                partSql = " FUsingFlag = 2,FEndDate ={ts'" + now + "'} ";
            }
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        int size = rangeIDs.size();
        for (int i = 0; i < size; ++i) {
            String sql = "update T_EXT_SumRange set" + partSql + " where fid = '" + (String)rangeIDs.get(i) + "'";
            sqlList.add(sql);
        }
        sqlList.trimToSize();
        ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
    }

    private List getUnitListByRangeID(String rangeID) throws BOSException {
        String sql = "select * from T_EXT_SumUnit where FSumRangeID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql, queryValue);
    }

    public SumRangeInfo getSumRangeAllInfoByID(String rangeID, String localString) throws BOSException {
        SumRangeInfo rangeInfo = this.getSumRangeInfoByID(rangeID, localString);
        List unitList = this.getUnitListByRangeID(rangeID);
        rangeInfo.setUnitList(unitList);
        List orgList = this.getOrgListByRangeID(rangeID, localString);
        rangeInfo.setOrgList(orgList);
        return rangeInfo;
    }

    public List getUnitListByRangeID(String rangeId, String localString, String curOrgId) throws BOSException {
        StringBuffer sql = new StringBuffer("select fid,fnumber,");
        sql.append(" fname_").append(localString).append(" as unitname");
        sql.append(" from T_EXT_SumUnit where FSumRangeID = ? ");
        sql.append(" and fmanageorgid = ?");
        ArrayList<String> parms = new ArrayList<String>(2);
        parms.add(rangeId);
        parms.add(curOrgId);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), parms);
    }

    public void insertSumUnit(SumUnitInfo sumUnitInfo) throws SumRangeException {
        String sql = "insert into T_EXT_SumUnit(FID, FNumber, FLongNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FParentID, FLevel, FManageOrgID,FSumRangeID,fcreatetime) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(sumUnitInfo.getId());
        queryValue.add(sumUnitInfo.getNumber());
        queryValue.add(sumUnitInfo.getLongNumber());
        queryValue.add(sumUnitInfo.getName("l2"));
        queryValue.add(sumUnitInfo.getName("l3"));
        queryValue.add(sumUnitInfo.getDes("l2"));
        queryValue.add(sumUnitInfo.getDes("l3"));
        queryValue.add(MixUtil.toString(sumUnitInfo.getParentID()));
        queryValue.add(new Integer(sumUnitInfo.getLevel()));
        queryValue.add(MixUtil.toString(sumUnitInfo.getManageOrgID()));
        queryValue.add(sumUnitInfo.getSumRangeID());
        queryValue.add(sumUnitInfo.getCreateTime());
        try {
            ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql, queryValue);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public SumUnitInfo getSumUnitInfoByID(String unitID, String localString) throws BOSException {
        SumUnitInfo sumUnitInfo = null;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select su.*, ");
        sbSQL.append("org.Fname_").append(localString).append(" as org_name ");
        sbSQL.append("from T_EXT_SumUnit su LEFT OUTER JOIN T_ORG_BaseUnit org on su.FManageOrgID = org.fid ");
        sbSQL.append("where su.FID = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(unitID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
        if (!map.isEmpty()) {
            sumUnitInfo = new SumUnitInfo();
            sumUnitInfo.setId(CtrlReportUtil.getObjectString(map.get("fid")));
            sumUnitInfo.setNumber(CtrlReportUtil.getObjectString(map.get("fnumber")));
            sumUnitInfo.setLongNumber(CtrlReportUtil.getObjectString(map.get("flongnumber")));
            sumUnitInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            sumUnitInfo.setMultiLangItem("name", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            sumUnitInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l2")), "l2");
            sumUnitInfo.setMultiLangItem("des", CtrlReportUtil.getObjectString(map.get("fname_l3")), "l3");
            sumUnitInfo.setParentID(CtrlReportUtil.getObjectString(map.get("fparentid")));
            int level = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("flevel")));
            sumUnitInfo.setLevel(level);
            sumUnitInfo.setManageOrgID(CtrlReportUtil.getObjectString(map.get("fmanageorgid")));
            sumUnitInfo.setManageOrgName(CtrlReportUtil.getObjectString(map.get("org_name")));
        }
        return sumUnitInfo;
    }

    public void updateSumUnitName(SumUnitInfo newVo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_ext_sumunit set ").append("name_l2='").append(newVo.getName("l2")).append("',").append("name_l1='").append(newVo.getName("l1")).append("',").append("name_l3='").append(newVo.getName("l3")).append("' ").append(" where fid ='").append(newVo.getId()).append('\'');
        ExtDBUtil.maintainRecord(ServerUtil.getContext(), sql.toString(), new ArrayList());
    }

    public void updateSumUnit(SumUnitInfo newSumUnitInfo, SumUnitInfo oldSumUnitInfo) throws SumRangeException {
        String oldParent;
        String newParent;
        String orgSQL;
        String unitSQL;
        ArrayList<String> sqlList = new ArrayList<String>();
        Timestamp updateTime = new Timestamp(new Date().getTime());
        newSumUnitInfo.setLastUpdateTime(updateTime);
        StringBuffer sbUpdateSQL = new StringBuffer();
        sbUpdateSQL.append("update T_EXT_SumUnit set ");
        sbUpdateSQL.append("FNumber = '").append(newSumUnitInfo.getNumber().replaceAll("'", "''")).append("', ");
        sbUpdateSQL.append("FName_l2 = '").append(newSumUnitInfo.getName("l2").replaceAll("'", "''")).append("', ");
        sbUpdateSQL.append("FName_l3 = '").append(newSumUnitInfo.getName("l3").replaceAll("'", "''")).append("', ");
        sbUpdateSQL.append("FDes_l2 = '").append(newSumUnitInfo.getDes("l2").replaceAll("'", "''")).append("', ");
        sbUpdateSQL.append("FDes_l3 = '").append(newSumUnitInfo.getDes("l3").replaceAll("'", "''")).append("', ");
        sbUpdateSQL.append("FLastUpdateTime = {ts'").append(MixUtil.getDateFromTimestamp(newSumUnitInfo.getLastUpdateTime())).append("'} , ");
        sbUpdateSQL.append("FManageOrgID = '").append(newSumUnitInfo.getManageOrgID()).append("'");
        sbUpdateSQL.append(" where FID = '").append(newSumUnitInfo.getId()).append("'");
        sqlList.add(sbUpdateSQL.toString());
        String oldNumber = oldSumUnitInfo.getNumber();
        String newNumber = newSumUnitInfo.getNumber();
        if (!oldNumber.equals(newNumber)) {
            String search = "\\" + oldNumber.replaceAll("'", "''") + "\\";
            String replace = "\\" + newNumber.replaceAll("'", "''") + "\\";
            unitSQL = "update T_EXT_SumUnit set FLongNumber = replace(FLongNumber, '" + search + "', '" + replace + "') where FSumRangeID = '" + oldSumUnitInfo.getSumRangeID() + "'";
            sqlList.add(unitSQL);
            orgSQL = "update T_EXT_SumUnitOrg set FLongNumber = replace(FLongNumber, '" + search + "', '" + replace + "') where FSumRangeID = '" + oldSumUnitInfo.getSumRangeID() + "'";
            sqlList.add(orgSQL);
        }
        String oldLongNumber = oldSumUnitInfo.getLongNumber();
        String newLongNumber = newSumUnitInfo.getLongNumber();
        if (!newLongNumber.equals(oldLongNumber)) {
            unitSQL = "update T_EXT_SumUnit set FLongNumber = replace(FLongNumber, '" + oldLongNumber.replaceAll("'", "''") + "', '" + newLongNumber.replaceAll("'", "''") + "') where FSumRangeID = '" + oldSumUnitInfo.getSumRangeID() + "'";
            sqlList.add(unitSQL);
            orgSQL = "update T_EXT_SumUnitOrg set FLongNumber = replace(FLongNumber, '" + oldLongNumber.replaceAll("'", "''") + "', '" + newLongNumber.replaceAll("'", "''") + "') where FSumRangeID = '" + oldSumUnitInfo.getSumRangeID() + "'";
            sqlList.add(orgSQL);
        }
        if (!(newParent = MixUtil.toString(newSumUnitInfo.getParentID())).equals(oldParent = MixUtil.toString(oldSumUnitInfo.getParentID()))) {
            StringBuffer sqlBuf = new StringBuffer("UPDATE T_EXT_SumUnit SET FParentID = '");
            sqlBuf.append(newParent).append("',FCreateTime = {ts'");
            sqlBuf.append(MixUtil.getDateFromTimestamp(newSumUnitInfo.getLastUpdateTime())).append("'}");
            sqlBuf.append(" WHERE FParentID = '");
            sqlBuf.append(oldParent).append("' AND\u3000FID = '");
            sqlBuf.append(newSumUnitInfo.getId()).append('\'');
            sqlList.add(sqlBuf.toString());
            sqlBuf.delete(0, sqlBuf.length());
            int newLevel = newSumUnitInfo.getLevel();
            int oldLevel = oldSumUnitInfo.getLevel();
            if (newLevel != oldLevel) {
                sqlBuf.delete(0, sqlBuf.length());
                sqlBuf.append("UPDATE T_EXT_SumUnit SET FLEVEL = (FLEVEL + ");
                sqlBuf.append(newLevel).append("-").append(oldLevel);
                sqlBuf.append(") WHERE CharIndex('").append(newSumUnitInfo.getLongNumber().replaceAll("'", "''"));
                sqlBuf.append("',FLongNumber) > 0 And FSumRangeID = '").append(oldSumUnitInfo.getSumRangeID()).append('\'');
                sqlList.add(sqlBuf.toString());
            }
        }
        sqlList.trimToSize();
        try {
            ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public boolean isUnitReference(SumUnitInfo unitInfo) throws BOSException {
        String rangeID = unitInfo.getSumRangeID();
        return this.isRangeReference(rangeID);
    }

    public void deleteSumUnit(SumUnitInfo vo) throws SumRangeException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String unitSQL = "delete from T_EXT_SumUnit  where fsumrangeid='" + vo.getSumRangeID() + "' and charindex('" + "\\" + vo.getNumber() + "\\" + "',flongNumber)>0 ";
        String unitOrgSQL = "delete from T_EXT_SumUnitOrg  where  fsumrangeid='" + vo.getSumRangeID() + "' and charindex('" + "\\" + vo.getNumber() + "\\" + "',flongNumber)>0 ";
        sqlList.add(unitOrgSQL);
        sqlList.add(unitSQL);
        sqlList.trimToSize();
        try {
            ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public ArrayList querySumUnitOrgByID(String sumUnitID, String local) throws SumRangeException {
        StringBuffer sql = new StringBuffer();
        sql.append("select su.forgid as orgid,su.flongnumber as longnumber, su.fsumunitid as unitid , org.fnumber as orgnumber,");
        sql.append("su.forgname as orgname,");
        sql.append("org.FDESCRIPTION_").append(local).append(" as orgdes,");
        sql.append("org.fsimplename as orgabbreviation ");
        sql.append(" from T_EXT_SumUnitOrg su left outer join T_ORG_BaseUnit org on org.fid = su.forgid where su.FSumUnitID = ? order by su.fcreatetime asc");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(sumUnitID);
        try {
            return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public ArrayList querySumUnitOrgByRangeID(String rangeID, String local) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select su.forgid as orgid, su.fsumunitid as unitid ,");
        sql.append("org.fname_").append(local).append(" as orgname ");
        sql.append(" from T_EXT_SumUnitOrg su left outer join T_ORG_BaseUnit org on org.fid = su.forgid where su.fsumrangeid = ? order by su.fcreatetime asc");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
    }

    public ArrayList querySumUnitOrgIncluSubByID(String rangeID, String number, String local) throws SumRangeException {
        StringBuffer sql = new StringBuffer();
        sql.append("select su.forgid as orgid,su.flongnumber as longnumber, su.fsumunitid as unitid , org.fnumber as orgnumber,");
        sql.append("su.forgname as orgname,");
        sql.append("org.FDESCRIPTION_").append(local).append(" as orgdes,");
        sql.append("org.fsimplename as orgabbreviation ");
        sql.append(" from T_EXT_SumUnitOrg su left outer join T_ORG_BaseUnit org on org.fid = su.forgid where ").append(" CharIndex('").append(number).append("',su.flongnumber)>0 and FSumRangeId = ? order by su.fcreatetime asc");
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(rangeID);
            return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), params);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public void insertUnitOrg(List orgInfos) throws SumRangeException {
        ArrayList<String> sqlList = new ArrayList<String>();
        int size = orgInfos.size();
        for (int i = 0; i < size; ++i) {
            SumUnitOrgInfo orgInfo = (SumUnitOrgInfo)orgInfos.get(i);
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append("insert into T_EXT_SumUnitOrg(FOrgID, FOrgName,FSumRangeID, FSumUnitID,FCreateTime, FLongNumber) values (");
            sbSQL.append("'").append(orgInfo.getOrgID()).append("', ");
            sbSQL.append("'").append(orgInfo.getOrgName()).append("', ");
            sbSQL.append("'").append(orgInfo.getSumRangeID()).append("', ");
            sbSQL.append("'").append(orgInfo.getSumUnitID()).append("', ");
            sbSQL.append("{ts'").append(MixUtil.getDateFromTimestamp(orgInfo.getCreateTime())).append("'}, ");
            sbSQL.append("'").append(orgInfo.getLongNumber()).append("')");
            sqlList.add(sbSQL.toString());
        }
        sqlList.trimToSize();
        try {
            ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public boolean isOrgImport(SumUnitOrgInfo info) throws SumRangeException {
        String sql = "select top 1 so.* from t_ext_sumunitorg so where so.fsumrangeid = ? and forgid = ?";
        ArrayList<String> queryVals = new ArrayList<String>();
        queryVals.add(info.getSumRangeID());
        queryVals.add(info.getOrgID());
        try {
            HashMap rsMap = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryVals);
            return !rsMap.isEmpty();
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public boolean isOrgReference(String orgID) throws BOSException {
        String sql = "select top 1 td.* from T_EXT_TaskDistribute td, T_EXT_SumUnitOrg so where td.fid = so.FSumRangeID and so.FOrgID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(orgID);
        HashMap map = ExtDBUtil.getResultMapBySql(ServerUtil.getContext(), sql, queryValue);
        return !map.isEmpty();
    }

    public void deleteUnitOrg(String orgID, String unitID) throws SumRangeException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String unitOrgSQL = "delete T_EXT_SumUnitOrg where FOrgID = '" + orgID + "' and FSumUnitID = '" + unitID + "'";
        sqlList.add(unitOrgSQL);
        sqlList.trimToSize();
        try {
            ExtDBUtil.executeBatch(ServerUtil.getContext(), sqlList);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public ArrayList queryfullUnitTree(String rangeID, String local) throws SumRangeException {
        StringBuffer sqlBuf = new StringBuffer(530);
        sqlBuf.append("(select '0' as type, u.fid as id , u.fname_").append(local).append(" as name, u.fparentid as pid, u.flevel as flevel,u.fcreatetime as createtime from t_ext_sumunit u where u.fsumrangeid= '").append(rangeID).append("')");
        sqlBuf.append("union all");
        sqlBuf.append("(select '1' as type, uo.forgid as id, uo.forgname").append(" as name, uo.fsumunitid as pid, 1000 as flevel, uo.fcreatetime as createtime  from t_ext_sumunitorg uo left outer join t_org_baseunit o on uo.forgid = o.fid where uo.fsumrangeid = '").append(rangeID).append("')");
        sqlBuf.append(" order by flevel asc,createtime asc");
        try {
            return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sqlBuf.toString(), null);
        }
        catch (BOSException e) {
            throw SumRangeException.wrap((Exception)((Object)e));
        }
    }

    public List getSumRangeUnitList(List sumRangeInfoList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select range.fnumber as rangeNumber,range.FUsingFlag,range.fname_l1 as rangeName_l1,range.fname_l2 as rangeName_l2,").append(" range.fname_l3 as rangeName_l3,range.fdes_l1 as rangefdes_l1,range.fdes_l2 as rangefdes_l2,").append(" range.fbegindate as begindate, range.fenddate as enddate,").append(" range.fdes_l3 as rangefdes_l3,unit.FNumber as unitNumber,unit.FLongNumber,unit.fId as unitId,unit.fparentId,unit.FName_l1 as unitfname_l1,").append(" unit.FName_l2 as unitfname_l2,unit.FName_l3 as unitfname_l3,unit.FDes_l1 as unitfdes_l1,").append(" unit.FDes_l2 as unitfdes_l2,unit.FDes_l3 as unitfdes_l3,unit.FLevel,unit.FManageOrgID,org.fnumber as orgNumber ").append(" from t_ext_sumrange range left join t_ext_sumunit unit on range.fid=unit.fsumrangeid").append(" left join t_org_baseunit org on unit.fmanageorgid = org.fid ").append(" where range.fnumber in ");
        StringBuffer whereSql = new StringBuffer();
        ArrayList<String> queryValue = new ArrayList<String>();
        SumRangeInfo sumRangeInfo = null;
        for (int i = 0; i < sumRangeInfoList.size(); ++i) {
            whereSql.append("(").append("?").append(",");
            sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(i);
            queryValue.add(sumRangeInfo.getNumber());
        }
        ArrayList result = null;
        if (whereSql.length() > 0) {
            whereSql.deleteCharAt(whereSql.length() - 1);
            whereSql.append(")");
            sql.append(whereSql);
            sql.append(" order by unit.FLongNumber");
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
        }
        return result;
    }

    public List getOrgUnitListBaseNumber(List orgList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fid,org.fnumber,org.fname_l2").append(" from t_org_baseunit org ").append(" where org.fisfreeze = 0 and org.fnumber in ");
        StringBuffer whereSql = new StringBuffer();
        ArrayList queryValue = new ArrayList();
        if (orgList.size() > 0) {
            whereSql.append("(");
        }
        for (int i = 0; i < orgList.size(); ++i) {
            whereSql.append("?").append(",");
            queryValue.add(orgList.get(i));
        }
        ArrayList result = null;
        if (whereSql.length() > 0) {
            whereSql.deleteCharAt(whereSql.length() - 1);
            whereSql.append(")");
            sql.append(whereSql);
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), queryValue);
        }
        return result;
    }

    public List getOrgListByRangeID(String rangeID, String localString) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select so.FOrgID, so.FSumRangeID, so.FSumUnitID, so.FLongNumber, ");
        sbSQL.append(" so.forgname as orgname, ");
        sbSQL.append(" org.fnumber as orgnumber");
        sbSQL.append(" from T_EXT_SumUnitOrg so inner join T_ORG_BaseUnit org on so.FOrgID = org.fid ");
        sbSQL.append(" where so.FSumRangeID = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(rangeID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sbSQL.toString(), queryValue);
    }

    public List getSumRangeListByNumber(List sumRangeInfoList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select range.fnumber as rangeNumber,range.FUsingFlag,range.fname_l1 as rangeName_l1,range.fname_l2 as rangeName_l2,").append(" range.fname_l3 as rangeName_l3,range.fdes_l1 as rangefdes_l1,range.fdes_l2 as rangefdes_l2,").append(" range.fdes_l3 as rangefdes_l3").append(" from t_ext_sumrange range ").append(" where range.fnumber in ");
        StringBuffer numWhereSql = new StringBuffer();
        StringBuffer nameWhereSql = new StringBuffer();
        ArrayList<String> numQueryValue = new ArrayList<String>();
        ArrayList<String> nameQueryValue = new ArrayList<String>();
        SumRangeInfo sumRangeInfo = null;
        if (sumRangeInfoList.size() > 0) {
            numWhereSql.append("(");
            nameWhereSql.append("  or Range.fname_l2 in (");
        }
        for (int i = 0; i < sumRangeInfoList.size(); ++i) {
            numWhereSql.append("?").append(",");
            nameWhereSql.append("?").append(",");
            sumRangeInfo = (SumRangeInfo)sumRangeInfoList.get(i);
            numQueryValue.add(sumRangeInfo.getNumber());
            nameQueryValue.add(sumRangeInfo.getName());
        }
        ArrayList result = null;
        if (numWhereSql.length() > 0 && nameWhereSql.length() > 0) {
            numWhereSql.deleteCharAt(numWhereSql.length() - 1);
            numWhereSql.append(")");
            nameWhereSql.deleteCharAt(nameWhereSql.length() - 1);
            nameWhereSql.append(")");
            sql.append(numWhereSql);
            sql.append(nameWhereSql);
            numQueryValue.addAll(nameQueryValue);
            result = ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), numQueryValue);
        }
        return result;
    }

    public Map batchInsertSumRange(Map sumRangeInfoMap, String curUserId) throws BOSException {
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        if (sumRangeInfoMap == null || sumRangeInfoMap.size() == 0) {
            return errorMsgMap;
        }
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer successMsg = new StringBuffer();
        ArrayList<StringBuffer> sumRangeSql = new ArrayList<StringBuffer>();
        ArrayList sumUnitSql = new ArrayList();
        ArrayList sumUnitOrgSql = new ArrayList();
        StringBuffer sql = null;
        Timestamp curTime = new Timestamp(new Date().getTime());
        Iterator iter = sumRangeInfoMap.values().iterator();
        while (iter.hasNext()) {
            sql = new StringBuffer();
            SumRangeInfo sumRangeInfo = (SumRangeInfo)iter.next();
            sumRangeInfo.setId(UID.create((int)44));
            sumRangeInfo.setUpdateUserId(curUserId);
            sumRangeInfo.setCreator(curUserId);
            sumRangeInfo.setCreateTime(curTime);
            sumRangeInfo.setLastUpdateTime(curTime);
            sql.append(" insert into T_EXT_SumRange(FID, FNumber, FName_l1, FName_l2, FName_l3, FDes_l1, FDes_l2, FDes_l3,").append(" FUsingFlag, FCreatorID, FCreateTime )").append(" values (");
            sql.append("'").append(sumRangeInfo.getId()).append("',");
            sql.append("'").append(sumRangeInfo.getNumber()).append("',");
            sql.append("'").append(sumRangeInfo.getName("l1")).append("',");
            sql.append("'").append(sumRangeInfo.getName("l2")).append("',");
            sql.append("'").append(sumRangeInfo.getName("l3")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l1")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l2")).append("',");
            sql.append("'").append(sumRangeInfo.getDes("l3")).append("',");
            sql.append(sumRangeInfo.getUsingFlag()).append(",");
            sql.append("'").append(sumRangeInfo.getCreator()).append("',");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumRangeInfo.getCreateTime())).append("'} )");
            sumRangeSql.add(sql);
            this.batchInsertSumUnit(sumRangeInfo, errorMsg, sumUnitSql, sumUnitOrgSql);
            if (successMsg.length() == 0) {
                successMsg.append("\u4ee5\u4e0b\u6c47\u603b\u8303\u56f4\u6570\u636e\u5bfc\u5165\u6210\u529f\uff1a\n");
            }
            successMsg.append("   \u6c47\u603b\u8303\u56f4\u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
            successMsg.append("\u6c47\u603b\u8303\u56f4\u540d\u79f0\uff1a").append(sumRangeInfo.getName("l2")).append(" \n");
        }
        Context ctx = ServerUtil.getContext();
        sumRangeSql.addAll(sumUnitSql);
        sumRangeSql.addAll(sumUnitOrgSql);
        ExtDBUtil.executeBatch(ctx, sumRangeSql);
        errorMsgMap.put("successMsg", successMsg.toString());
        errorMsgMap.put("errorMsg", errorMsg.toString());
        return errorMsgMap;
    }

    public void batchInsertSumUnit(SumRangeInfo sumRangeInfo, StringBuffer errorMsg, ArrayList sumUnitSql, ArrayList sumUnitOrgSql) throws BOSException {
        List unitList = sumRangeInfo.getUnitList();
        if (unitList == null || unitList.size() == 0) {
            return;
        }
        StringBuffer sql = null;
        HashMap<String, String> unitIdMap = new HashMap<String, String>();
        for (int j = 0; j < unitList.size(); ++j) {
            sql = new StringBuffer();
            SumUnitInfo sumUnitInfo = (SumUnitInfo)unitList.get(j);
            String oldId = sumUnitInfo.getId();
            String oldParentId = sumUnitInfo.getParentID();
            sumUnitInfo.setId(UID.create((int)44));
            if (StringUtil.isEmptyString((String)oldParentId)) {
                sumUnitInfo.setParentID("");
                unitIdMap.put(oldId, sumUnitInfo.getId());
            } else if (unitIdMap.containsKey(oldParentId)) {
                sumUnitInfo.setParentID((String)unitIdMap.get(oldParentId));
                unitIdMap.put(oldId, sumUnitInfo.getId());
            } else {
                if (errorMsg.length() == 0) {
                    errorMsg.append("\u4ee5\u4e0b\u6c47\u603b\u5355\u5143\u627e\u4e0d\u5230\u4e0a\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u5bfc\u5165\uff1a\n");
                }
                errorMsg.append("  \u6c47\u603b\u8303\u56f4\u7f16\u7801\uff1a").append(sumRangeInfo.getNumber()).append("  ");
                errorMsg.append("\u6c47\u603b\u5355\u5143\u7f16\u7801\uff1a").append(sumUnitInfo.getNumber()).append("\n");
                continue;
            }
            sumUnitInfo.setCreateTime(sumRangeInfo.getCreateTime());
            sumUnitInfo.setLastUpdateTime(sumRangeInfo.getCreateTime());
            sql.append(" insert into T_EXT_SumUnit(FID, FNumber, FLongNumber, FName_l1, FName_l2, ").append(" FName_l3, FDes_l1, FDes_l2, FDes_l3, FParentID, FLevel, FManageOrgID,FSumRangeID,fcreatetime) values (");
            sql.append("'").append(sumUnitInfo.getId()).append("',");
            sql.append("'").append(sumUnitInfo.getNumber()).append("',");
            sql.append("'").append(sumUnitInfo.getLongNumber()).append("',");
            sql.append("'").append(sumUnitInfo.getName("l1")).append("',");
            sql.append("'").append(sumUnitInfo.getName("l2")).append("',");
            sql.append("'").append(sumUnitInfo.getName("l3")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l1")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l2")).append("',");
            sql.append("'").append(sumUnitInfo.getDes("l3")).append("',");
            sql.append("'").append(sumUnitInfo.getParentID()).append("',");
            sql.append(sumUnitInfo.getLevel()).append(",");
            sql.append("'").append(sumUnitInfo.getManageOrgID()).append("',");
            sql.append("'").append(sumRangeInfo.getId()).append("',");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumUnitInfo.getCreateTime())).append("'} )");
            sumUnitSql.add(sql);
            this.batchInsertSumUnitOrg(sumRangeInfo, sumUnitInfo, sumUnitOrgSql, unitIdMap);
        }
    }

    public void batchInsertSumUnitOrg(SumRangeInfo sumRangeInfo, SumUnitInfo sumUnitInfo, ArrayList sumUnitOrgSql, Map unitIdMap) throws BOSException {
        StringBuffer sql = null;
        List orgList = null;
        orgList = sumRangeInfo.getOrgList();
        if (orgList == null || orgList.size() == 0) {
            return;
        }
        for (int j = 0; j < orgList.size(); ++j) {
            sql = new StringBuffer();
            SumUnitOrgInfo sumUnitOrgInfo = (SumUnitOrgInfo)orgList.get(j);
            if (!unitIdMap.containsKey(sumUnitOrgInfo.getSumUnitID())) continue;
            sumUnitOrgInfo.setSumUnitID((String)unitIdMap.get(sumUnitOrgInfo.getSumUnitID()));
            sumUnitOrgInfo.setSumRangeID(sumRangeInfo.getId());
            sumUnitOrgInfo.setCreateTime(sumRangeInfo.getCreateTime());
            sql.append("insert into T_EXT_SumUnitOrg(FOrgID, FSumRangeID, FSumUnitID,FCreateTime, FOrgName,FLongNumber) values (");
            sql.append("'").append(sumUnitOrgInfo.getOrgID()).append("', ");
            sql.append("'").append(sumUnitOrgInfo.getSumRangeID()).append("', ");
            sql.append("'").append(sumUnitInfo.getId()).append("', ");
            sql.append("{ts'").append(MixUtil.getDateFromTimestamp(sumUnitOrgInfo.getCreateTime())).append("'}, ");
            sql.append("'").append(sumUnitOrgInfo.getOrgName()).append("',");
            sql.append("'").append(sumUnitOrgInfo.getLongNumber()).append("')");
            sumUnitOrgSql.add(sql);
        }
    }

    public IORMModel queryInterface(Class arg0) throws ORMCoreException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public List getInsertSumUnitsSQL(List unitLst) {
        String prefix = "insert into T_EXT_SumUnit(FID, FNumber, FLongNumber, FName_l2, FName_l3, FDes_l2, FDes_l3, FParentID, FLevel, FManageOrgID,FSumRangeID,fcreatetime) values ('";
        int prefixLen = prefix.length();
        StringBuffer sqlBuf = new StringBuffer(prefix);
        ArrayList<String> lstSql = new ArrayList<String>(unitLst.size());
        int len = unitLst.size();
        for (int i = 0; i < len; ++i) {
            SumUnitInfo info = (SumUnitInfo)unitLst.get(i);
            sqlBuf.append(info.getId()).append("','");
            sqlBuf.append(info.getNumber().replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getLongNumber().replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getName("l2").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getName("l3").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getDes("l2").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getDes("l3").replaceAll("'", "''")).append("','");
            sqlBuf.append(info.getParentID()).append("',");
            sqlBuf.append(String.valueOf(info.getLevel())).append(",'");
            sqlBuf.append(MixUtil.toString(info.getManageOrgID())).append("','");
            sqlBuf.append(info.getSumRangeID()).append("',");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(info.getCreateTime())).append("'})");
            lstSql.add(sqlBuf.toString());
            sqlBuf.delete(prefixLen, sqlBuf.length());
        }
        return lstSql;
    }

    public String addNewVersion(SumRangeInfo newVO, String oriRangeID, String local) throws BOSException {
        ArrayList<String> lstSQL = new ArrayList<String>();
        StringBuffer sqlBuf = new StringBuffer("insert into T_EXT_SumRange( fid,fnumber,fname_l2,fname_l3,fdes_l2,fdes_l3,fcreatorid,fcreatetime,FUsingFlag)values('");
        sqlBuf.append(newVO.getId()).append("','");
        sqlBuf.append(newVO.getNumber().replaceAll("'", "''")).append("','");
        sqlBuf.append(newVO.getName("l2").replaceAll("'", "''")).append("','");
        sqlBuf.append(newVO.getName("l3").replaceAll("'", "''")).append("','");
        sqlBuf.append(newVO.getDes("l2").replaceAll("'", "''")).append("','");
        sqlBuf.append(newVO.getDes("l3").replaceAll("'", "''")).append("','");
        sqlBuf.append(newVO.getCreator()).append("',{ts'");
        sqlBuf.append(MixUtil.getDateFromTimestamp(newVO.getCreateTime())).append("'},0").append(')');
        lstSQL.add(sqlBuf.toString());
        sqlBuf.delete(0, sqlBuf.length());
        lstSQL.addAll(this.getInsertSumUnitsSQL(newVO.getUnitList()));
        lstSQL.addAll(this.getBatchInsertOrgsSQL(newVO.getOrgList()));
        ExtDBUtil.executeBatch(ServerUtil.getContext(), lstSQL);
        return newVO.getName(local);
    }

    private List getBatchInsertOrgsSQL(List orgLst) {
        String prefix = "insert into T_EXT_SumUnitOrg(FOrgID, FOrgName,FSumRangeID, FSumUnitID,FCreateTime, FLongNumber) values (";
        int prefixLen = prefix.length();
        StringBuffer sqlBuf = new StringBuffer(prefix);
        ArrayList<String> sqlLst = new ArrayList<String>(orgLst.size());
        int size = orgLst.size();
        for (int i = 0; i < size; ++i) {
            SumUnitOrgInfo orgInfo = (SumUnitOrgInfo)orgLst.get(i);
            sqlBuf.append("'").append(orgInfo.getOrgID()).append("', ");
            sqlBuf.append("'").append(orgInfo.getOrgName()).append("', ");
            sqlBuf.append("'").append(orgInfo.getSumRangeID()).append("', ");
            sqlBuf.append("'").append(orgInfo.getSumUnitID()).append("', ");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(orgInfo.getCreateTime())).append("'}, ");
            sqlBuf.append("'").append(orgInfo.getLongNumber()).append("')");
            sqlLst.add(sqlBuf.toString());
            sqlBuf.delete(prefixLen, sqlBuf.length());
        }
        return sqlLst;
    }

    public List getAssignToCurOrgSumRanges(String curOrgID, String localString) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct range.fid as fid,range.fnumber as fnumber,range.fname_").append(localString).append(" as rangename");
        sql.append(" from t_ext_taskdistribute task");
        sql.append(" inner join t_ext_taskdetail detail on task.fid = detail.ftaskdistributeid");
        sql.append(" inner join t_ext_sumunit unit on detail.funitororgid = unit.fid");
        sql.append(" inner join t_ext_sumrange range on range.fid = unit.fsumrangeid");
        sql.append(" where detail.fidflag = ").append(0);
        sql.append(" and unit.fmanageorgid = ?");
        ArrayList<String> param = new ArrayList<String>(1);
        param.add(curOrgID);
        return ExtDBUtil.getResultListBySql(ServerUtil.getContext(), sql.toString(), param);
    }

    public List getInvalidOrgInRange(String rangeID) {
        return null;
    }
}

