/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.ByteContentInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.LogInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SnapDataBean;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SnapshotDataException;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISnapshotBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.server.impl.SnapshotBOFacade;
import java.util.List;

public class SnapshotService {
    public static final int BLOCK_SIZE = 65536;
    private ISnapshotBOFacade _facade;

    private SnapDataBean[] cutApart(byte[] source) {
        int leaveBytes = source.length;
        int index = 0;
        int srcPos = 0;
        int size = leaveBytes / 65536 + (leaveBytes % 65536 > 0 ? 1 : 0);
        SnapDataBean[] blocks = new SnapDataBean[size];
        while (leaveBytes > 0) {
            int bytes = 65536;
            if (65536 > leaveBytes) {
                bytes = leaveBytes;
            }
            byte[] buffer = new byte[bytes];
            System.arraycopy(source, srcPos, buffer, 0, bytes);
            leaveBytes -= 65536;
            SnapDataBean block = new SnapDataBean(buffer, index);
            srcPos += 65536;
            blocks[index] = block;
            ++index;
        }
        return blocks;
    }

    public ISnapshotBOFacade getFacade() throws SnapshotDataException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                if (ServerUtil.isServerSide()) {
                    this._facade = new SnapshotBOFacade();
                    return this._facade;
                }
                this._facade = (ISnapshotBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SnapshotBOFacade.class.getName(), ISnapshotBOFacade.class);
            }
            catch (BOSException e) {
                throw SnapshotDataException.wrap("Initial Snapshot BO Facade facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    public void saveSnapshotData(ByteContentInfo info) throws SnapshotDataException {
        SnapDataBean[] blocks = this.cutApart(info.getContent());
        this.getFacade().insert(info.getId().toString(), blocks);
    }

    public void updateSnapshotData(ByteContentInfo info) throws SnapshotDataException {
        SnapDataBean[] blocks = this.cutApart(info.getContent());
        this.getFacade().update(info.getId().toString(), blocks);
    }

    public void deleteASnapshotData(String id) throws SnapshotDataException {
        this.getFacade().delete(id);
    }

    public void batchDel(List ids) throws SnapshotDataException {
        this.getFacade().batchDel(ids);
    }

    public void logUpdate(LogInfo info) throws SnapshotDataException {
        this.getFacade().insertLog(info);
    }

    public void clearLog(String activityID) throws SnapshotDataException {
        this.getFacade().deleteLog(activityID);
    }

    public List queryLog(String activityID) throws SnapshotDataException {
        return this.getFacade().queryLog(activityID);
    }
}

