/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class Config {
    private static String configFileName = Config.class.getResource("").getPath() + "openApi.properties";
    private static Properties props;

    private static void loadConfig() throws FileNotFoundException, IOException {
        props = new Properties();
        File configFile = new File(configFileName);
        if (configFile.exists()) {
            props.load(new FileInputStream(configFile));
        }
    }

    public static Properties getAllProperty() {
        return props;
    }

    public static String getProperty(String propertyName) {
        if (props != null) {
            return props.getProperty(propertyName);
        }
        return null;
    }

    public static String getProperty(String propertyName, String _default) {
        String value = Config.getProperty(propertyName);
        if (value == null || value.trim().length() < 1) {
            value = _default;
        }
        return value;
    }

    public static int getProperty(String propertyName, int _default) {
        String value = Config.getProperty(propertyName);
        int ret = _default;
        try {
            if (value != null && value.trim().length() > 0) {
                ret = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    static {
        try {
            Config.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class WatchFileThread
    extends Thread {
        long lastModify = 0L;

        public WatchFileThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                File file;
                if (!(file = new File(configFileName)).exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (file.lastModified() != this.lastModify) {
                    this.lastModify = file.lastModified();
                    try {
                        Config.loadConfig();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

