/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.login;

import com.kingdee.bos.openapi.third.InvokeType;
import com.kingdee.bos.openapi.third.ctx.IloginContext;
import com.kingdee.bos.openapi.third.invoker.AbstractMQLoginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;

public class MqLoginContext
extends AbstractMQLoginContext {
    public String getVirtualHost() {
        return this.connEntity.getVhost();
    }

    private MqLoginContext(Builder builder) {
        this.loginContext = builder.loginContext;
        this.invokeType = builder.isHttps ? InvokeType.MQ_HTTPS : InvokeType.MQ;
        this.connEntity.setHost(builder.mqContext.mqHost);
        this.connEntity.setPort(builder.mqContext.mqPort);
        this.connEntity.setPassword(builder.mqContext.mqPassword);
        this.connEntity.setUserName(builder.mqContext.mqUserName);
        if (!OpenApiTools.isEmpty(builder.mqContext.virtualHost)) {
            this.connEntity.setVhost(builder.mqContext.virtualHost);
        }
    }

    public static class MQContext {
        private String mqHost;
        private int mqPort;
        private String mqUserName;
        private String mqPassword;
        private String virtualHost;

        public MQContext(String mqHost, int mqPort, String mqUserName, String mqPassword) {
            this.mqHost = mqHost;
            this.mqPort = mqPort;
            this.mqUserName = mqUserName;
            this.mqPassword = mqPassword;
        }

        public MQContext virtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
            return this;
        }
    }

    public static class Builder {
        private IloginContext loginContext;
        private MQContext mqContext;
        private boolean isHttps;

        public Builder(MQContext mqContext, IloginContext loginContext) {
            this.mqContext = mqContext;
            this.loginContext = loginContext;
        }

        public Builder https(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public MqLoginContext build() {
            return new MqLoginContext(this);
        }
    }
}

