/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import com.kingdee.bos.openapi.util.AES;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PacketsUtil {
    public static final byte[] gzip(String str, String charset) throws Exception {
        if (str == null) {
            throw new NullPointerException("gzip input is null!");
        }
        return PacketsUtil.gzip(str.getBytes(charset));
    }

    public static final byte[] gzip(byte[] input) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        GZIPOutputStream gzipOut = null;
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        gzipOut = new GZIPOutputStream(arrayOut);
        try {
            gzipOut.write(input);
            gzipOut.finish();
            gzipOut.flush();
        }
        finally {
            gzipOut.close();
            arrayOut.close();
        }
        return arrayOut.toByteArray();
    }

    public static final byte[] gzipAndEncrypt(byte[] input, String encryptKey) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        input = PacketsUtil.gzip(input);
        return AES.encrypt(input, encryptKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] ungzip(byte[] input) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        GZIPInputStream gzipIn = new GZIPInputStream(new ByteArrayInputStream(input));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = gzipIn.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            gzipIn.close();
            out.close();
        }
        return out.toByteArray();
    }

    public static final byte[] decryptAndUngzip(byte[] input, String encryptKey) throws Exception {
        if (input == null || input.length == 0) {
            return input;
        }
        byte[] decrypted = AES.decrypt(input, encryptKey);
        byte[] ungziped = PacketsUtil.ungzip(decrypted);
        return ungziped;
    }

    public static void writeInt(OutputStream out, int len) throws IOException {
        byte[] lengthBytes = new byte[]{(byte)(len >>> 24 & 0xFF), (byte)(len >>> 16 & 0xFF), (byte)(len >>> 8 & 0xFF), (byte)(len >>> 0 & 0xFF)};
        out.write(lengthBytes);
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = "\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8".getBytes("UTF-8");
        System.out.println("\u539f\u59cb\u957f\u5ea6 \uff1a" + bytes.length);
        byte[] result = PacketsUtil.gzipAndEncrypt(bytes, "");
        System.out.println("\u7ed3\u679c\u957f\u5ea6\uff1a" + result.length);
    }
}

