/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.exception.CannotDeleteException;
import com.kingdee.bos.workflow.exception.NotEnabledException;
import com.kingdee.bos.workflow.exception.WfExpiredException;
import com.kingdee.bos.workflow.metas.ProcDefFactory;
import com.kingdee.bos.workflow.report.client.AbstractProcessDefineListUI;
import com.kingdee.bos.workflow.report.client.ProcessDefSetAdminUI;
import com.kingdee.bos.workflow.report.client.ProcessInstanceListUI;
import com.kingdee.bos.workflow.report.client.WfBizTypeListUI;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.wfdesigner.WorkFlowProcessInfo;
import com.kingdee.bos.workflow.wfdesigner.service.IWorkFlowDefineService;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ProcessDefineListUI
extends AbstractProcessDefineListUI {
    private static final long serialVersionUID = 8258686746610836822L;
    private final String basicShowWfDefinePanelClass = "com.kingdee.bos.workflow.monitor.client.BasicShowWfDefinePanel";
    private String[] hidedColums = new String[]{"FPROCDEFID", "FBIZPACKAGE", "FPACKAGENAME"};
    private String COLUMNNAME_ENABLE = "FENABLE";
    private static final Logger logger = CoreUIObject.getLogger(ProcessDefineListUI.class);
    private DefaultKingdeeTreeNode nodeRoot = null;
    private HashSet set = new HashSet();
    private IWorkFlowDefineService service = null;

    private void setColumnValue(int rowIndex, String columnTitle, Object value) {
        ICell cell;
        IRow row;
        if (this.tblMain != null && (row = this.tblMain.getRow(rowIndex)) != null && (cell = row.getCell(columnTitle)) != null) {
            cell.setValue(value);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.actionDelete_actionPerformed(e);
    }

    private void enableProcessDef(boolean enable) {
        try {
            EASWfServiceClient service = ReportUtil.getServiceClient();
            int size = this.tblMain.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
                int size1 = selectBlock.getBottom();
                for (int j = selectBlock.getTop(); j <= size1; ++j) {
                    String processDEFID = this.getCurrentID(j);
                    service.setProcessDefEnable(processDEFID, enable);
                    this.setColumnValue(j, this.COLUMNNAME_ENABLE, new Boolean(enable));
                    this.synchronizeButtonState(j);
                }
            }
            if (enable) {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("EnableProcessDefSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("DisableProcessDefSuccess"));
            }
        }
        catch (WfException e) {
            String errorMessage = "";
            errorMessage = enable ? ReportResourceUtil.getReportMultiLanguageResource("EnableProcessDefFailure") : ReportResourceUtil.getReportMultiLanguageResource("DisableProcessDefFailure");
            ExceptionHandler.handle((Component)((Object)this), (String)errorMessage, (Throwable)e);
        }
    }

    private void startProcess() {
        try {
            EASWfServiceClient service = ReportUtil.getServiceClient();
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            String processDEFID = this.getCurrentID(index);
            ProcessDefInfo procDefInfo = service.getProcessDefInfo(processDEFID);
            if (!procDefInfo.getClientStart()) {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("ProcessNotEnableClientStart"));
                return;
            }
            ProcessDef procDef = ApplicationUtil.getProcessDefByDefHashValue((String)procDefInfo.getMd5HashValue());
            if (procDef.getStartupActivities().size() > 1) {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("processHashMultiStartupPoint"));
                return;
            }
            ProcessInstInfo pii = service.createProcessInst(processDEFID, CompositeUtil.getUserID(), CompositeUtil.getUserName());
            service.startProcessInst(pii.getProcInstId());
            MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("StartProcessSuccess"));
        }
        catch (WfExpiredException ex) {
            MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("PROCESS_EXPIRED"));
        }
        catch (NotEnabledException e) {
            MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("ProcessNotEnable"));
        }
        catch (WfException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof WfExpiredException) {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("PROCESS_EXPIRED"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("StartProcessFailure"));
        }
    }

    private void setButtonIco() {
        this.startkDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.enableKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnBatchAdmin.setIcon(EASResource.getIcon((String)"imgTbtn_persondistribute"));
        this.disableKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.showProcDefDiagramKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.showProcInstKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuProcDef.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuProcInst.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuProcEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuProcDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuUpdateSubSystem.setIcon(EASResource.getIcon((String)"imgIcon_update"));
        this.menuItemSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_notice"));
        this.wfBizType.setIcon(EASResource.getIcon((String)"imgTbtn_sort"));
    }

    private void initializeUI() {
        this.tblMain.addKDTSelectListener((KDTSelectListener)new ProcessDefSelectListener());
        this.windowTitle = this.getWindowTitle();
        this.setButtonIco();
        CompositeUtil.hideColumns(this.tblMain, this.hidedColums);
        CompositeUtil.setRowSelect(this.tblMain);
        CompositeUtil.setTableReadOnly(this.tblMain);
        this.initTree();
        this.selectDefaultTreeNode();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        if (postman != null) {
            RequestContext request = (RequestContext)postman.getRequestContext();
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0) {
                request.put("procDefID", (Object)this.getCurrentID(index));
            } else if (this.tblMain.getRowCount() > 0) {
                request.put("procDefID", (Object)this.getCurrentID(0));
            }
            request.setQuery(this.getFiltedEntityViewInfo("com.kingdee.eas"));
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    public void initTree() {
        BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
        this.set.clear();
        this.getPackageName(root, this.set);
        this.nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        this.nodeRoot = this.convertToKingdeeTreeNode(root, this.nodeRoot);
        this.nodeRoot.setText(ReportResourceUtil.getReportMultiLanguageResource("ALL_PROCESS_TREE"));
        this.flowPackTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeRoot));
        this.flowPackTree.getSelectionModel().setSelectionMode(1);
        this.flowPackTree.setAutoscrolls(true);
        this.flowPackTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object object = ProcessDefineListUI.this.flowPackTree.getLastSelectedPathComponent();
                if (object != null && object instanceof DefaultKingdeeTreeNode) {
                    IBriefViewTreeNode currentNodeObject = (IBriefViewTreeNode)((DefaultKingdeeTreeNode)object).getUserObject();
                    ProcessDefineListUI.this.filterEntity(currentNodeObject.getPackageName());
                    ProcessDefineListUI.this.updateActions();
                }
            }
        });
    }

    private void filterEntity(String packageNameFilter) {
        this.mainQuery = this.getFiltedEntityViewInfo(packageNameFilter);
        this.tblMain.checkParsed();
        this.tblMain.refresh();
    }

    private EntityViewInfo getFiltedEntityViewInfo(String packageNameFilter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(packageName ='" + packageNameFilter + "') or (packageName like '" + packageNameFilter + ".%')");
        String oqlFilter = buffer.toString();
        FilterInfo filter = null;
        EntityViewInfo query = null;
        try {
            filter = new FilterInfo(oqlFilter);
        }
        catch (ParserException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"generate filterInfo exception", (Throwable)e);
        }
        EntityViewInfo tempQuery = this.getDefaultEntityViewInfo();
        query = query == null || tempQuery == null ? new EntityViewInfo() : (EntityViewInfo)tempQuery.clone();
        try {
            FilterItemCollection filterCollection = null;
            if (query.getFilter() != null) {
                filterCollection = query.getFilter().getFilterItems();
            }
            if (filterCollection != null) {
                query.getFilter().mergeFilter(filter, "AND");
            } else {
                query.setFilter(filter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return query;
    }

    private void getPackageName(IBriefViewTreeNode root, HashSet set) {
        String packageName = root.getPackageName();
        set.add(packageName);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode node = (IBriefViewTreeNode)enu.nextElement();
            this.getPackageName(node, set);
        }
    }

    private boolean isShowNode(String packageName) {
        for (String str : this.set) {
            if (!packageName.equalsIgnoreCase(str) && !str.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        nodeRoot.setText(root.getAlias());
        nodeRoot.setUserObject((Object)root);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            if (!this.isShowNode(bvNode.getPackageName())) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(bvNode.getAlias());
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        return nodeRoot;
    }

    private void selectDefaultTreeNode() {
        this.flowPackTree.setSelectionNode((DefaultKingdeeTreeNode)this.flowPackTree.getModel().getRoot());
    }

    private String getCurrentID(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell(0)) != null && (destValue = destCell.getValue()) != null) {
            return (String)destValue;
        }
        return "";
    }

    private boolean getEnable(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell("FENABLE")) != null && (destValue = destCell.getValue()) != null && destValue instanceof Boolean) {
            Boolean enableValue = (Boolean)destValue;
            return enableValue;
        }
        return false;
    }

    private void getParameter() {
    }

    private String getWindowTitle() {
        return ReportResourceUtil.getReportName("ProcessDefine_Normal");
    }

    private void setProcessEnableButtonEnable(boolean enable) {
        this.enableKDWorkButton.setEnabled(!enable);
        this.disableKDWorkButton.setEnabled(enable);
        this.menuProcEnable.setEnabled(!enable);
        this.menuProcDisable.setEnabled(enable);
    }

    private void synchronizeButtonState(int rowIndex) {
        boolean enableValue = this.getEnable(rowIndex);
        this.setProcessEnableButtonEnable(enableValue);
        this.updateActions();
    }

    private void showProcDefDiagram() {
        try {
            String procDefID;
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0 && (procDefID = this.getCurrentID(index)) != null && procDefID.length() > 0) {
                ProcessDefInfo processDefInfo = ReportUtil.getServiceClient().getProcessDefInfo(procDefID);
                Locale currentLocale = SysContext.getSysContext().getLocale();
                ProcessDef processDef = ApplicationUtil.getProcessDefByDefHashValue((String)processDefInfo.getMd5HashValue());
                String procDefDiagramTitle = processDef.getName(currentLocale);
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"define", (Object)processDef);
                uiContext.put((Object)"title", (Object)procDefDiagramTitle);
                uiContext.put((Object)"OpenAsNewWin", (Object)"");
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                IUIWindow uiWindow = uiFactory.create("com.kingdee.bos.workflow.monitor.client.BasicShowWfDefinePanel", (Map)uiContext);
                if (uiWindow instanceof UINewFrame) {
                    UINewFrame frame = (UINewFrame)uiWindow;
                    frame.getStatusBar().setVisible(false);
                    frame.getJMenuBar().setVisible(false);
                    uiWindow.show();
                    frame.setExtendedState(6);
                } else if (uiWindow instanceof UIModelDialog) {
                    UIModelDialog dialog = (UIModelDialog)uiWindow;
                    dialog.setResizable(true);
                    uiWindow.show();
                }
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
        catch (WfException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"WfException", (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"BOSException", (Throwable)e);
        }
    }

    private void showProcInst() {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0 && (id = this.getCurrentID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ProcessDefineID", (Object)id);
                uiContext.put((Object)"isFormWfDefineListUI", (Object)new Boolean(true));
                String className = ProcessInstanceListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
                if (uiWindow instanceof UINewFrame) {
                    UINewFrame frame = (UINewFrame)uiWindow;
                    uiWindow.show();
                    frame.setExtendedState(6);
                }
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        this.startProcess();
        this.updateActions();
    }

    @Override
    public void actionQueryData_actionPerformed(ActionEvent e) throws Exception {
        this.actionQuery_actionPerformed(e);
        this.updateActions();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initTree();
        this.updateActions();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.updateActions();
    }

    @Override
    public void actionEnableProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnableProcess_actionPerformed(e);
        this.enableProcessDef(true);
        this.updateActions();
    }

    @Override
    public RequestContext prepareActionDisableProcess(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDisableProcess(itemAction);
        ArrayList<String> list = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                list.add(this.getCurrentID(j));
            }
        }
        request.put("procDefIDList", list);
        return request;
    }

    @Override
    public RequestContext prepareActionEnableProcess(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDisableProcess(itemAction);
        ArrayList<String> list = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                list.add(this.getCurrentID(j));
            }
        }
        request.put("procDefIDList", list);
        return request;
    }

    @Override
    public void actionDisableProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisableProcess_actionPerformed(e);
        this.enableProcessDef(false);
        this.updateActions();
    }

    @Override
    public void procDefDiagramAction_actionPerformed(ActionEvent e) throws Exception {
        this.showProcDefDiagram();
        this.updateActions();
    }

    @Override
    public void actionShowProcInst_actionPerformed(ActionEvent e) throws Exception {
        this.showProcInst();
        this.updateActions();
    }

    @Override
    public void actionUpdateSubSystem_actionPerformed(ActionEvent e) throws Exception {
        if (this.set.size() <= 0) {
            return;
        }
        String[] types = new String[]{ProcessType.NORMAL.getName(), ProcessType.MICRO.getName()};
        this.service = ProcessDefineListUI.getService();
        ArrayList arrayList = this.service.getRunProcessDef(types);
        ArrayList<WorkFlowProcessInfo> packageExistList = new ArrayList<WorkFlowProcessInfo>();
        ArrayList<WorkFlowProcessInfo> packageNoExistList = new ArrayList<WorkFlowProcessInfo>();
        ArrayList<WorkFlowProcessInfo> packageMoveList = new ArrayList<WorkFlowProcessInfo>();
        for (WorkFlowProcessInfo info : arrayList) {
            String packageName = info.getPackageName();
            if (this.set.contains(packageName)) {
                packageExistList.add(info);
                continue;
            }
            if (packageName == null || packageName.lastIndexOf(46) == -1) continue;
            boolean flag = true;
            Iterator it_temp = this.set.iterator();
            int i = packageName.lastIndexOf(46);
            if (i >= 0) {
                String str1 = packageName.substring(i);
                while (it_temp.hasNext()) {
                    String packageTemp = (String)it_temp.next();
                    if (!packageTemp.substring(packageTemp.lastIndexOf(46)).equals(str1)) continue;
                    info.setPackageName(packageTemp);
                    packageMoveList.add(info);
                    flag = false;
                    break;
                }
            } else {
                logger.info((Object)("'" + info.getProcessId() + "'"));
            }
            if (!flag) continue;
            packageNoExistList.add(info);
        }
        if (packageMoveList.size() > 0) {
            this.sortProcessDefByPackageName(packageMoveList);
        }
        if (packageNoExistList.size() > 0) {
            this.sortProcessDefByParentPackage(packageNoExistList);
        }
        this.tblMain.refresh();
        MsgBox.showInfo((String)ReportResourceUtil.getReportMultiLanguageResource("ProcessDefineList_UpdateSubSystem"));
    }

    private void sortProcessDefByParentPackage(ArrayList list) throws BOSException {
        if (list == null || list.size() == 0) {
            return;
        }
        ArrayList<WorkFlowProcessInfo> listProcess = new ArrayList<WorkFlowProcessInfo>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            WorkFlowProcessInfo info = (WorkFlowProcessInfo)list.get(i);
            this.updatePackageName(info);
            listProcess.add(info);
        }
        if (listProcess.size() < 0) {
            logger.error((Object)"there is an error, the listProcess size is 0");
            return;
        }
        try {
            if (this.service == null) {
                this.service = ProcessDefineListUI.getService();
            }
            this.service.updatePackage(listProcess, "T_WFR_ProcDef");
        }
        catch (SQLException e) {
            throw new BOSException("Update database has an error." + e.getStackTrace());
        }
    }

    private void updatePackageName(WorkFlowProcessInfo info) throws BOSException {
        String packageName = info.getPackageName();
        int i = packageName.lastIndexOf(46);
        if (i < 0) {
            return;
        }
        String parentPackageName = packageName.substring(0, i);
        if (this.set.contains(parentPackageName)) {
            info.setPackageName(parentPackageName);
        } else {
            info.setPackageName(parentPackageName);
            this.updatePackageName(info);
        }
    }

    private void sortProcessDefByPackageName(ArrayList list) throws BOSException {
        if (list == null || list.size() == 0) {
            return;
        }
        try {
            if (this.service == null) {
                this.service = ProcessDefineListUI.getService();
            }
            this.service.updatePackage((List)list, "T_WFR_ProcDef");
        }
        catch (SQLException e) {
            throw new BOSException("Update database has an error." + e.getStackTrace());
        }
    }

    public static IWorkFlowDefineService getService() throws BOSException {
        String url = UIConfig.getUrl();
        ORMRPCServiceLocator.setCurrentServiceURL((String)url);
        IWorkFlowDefineService service = (IWorkFlowDefineService)BOSObjectFactory.createRemoteBOSObject((String)url, (String)"com.kingdee.bos.workflow.wfdesigner.service.WorkFlowDefineService", IWorkFlowDefineService.class);
        return service;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setButtonDefaultStyl(this.btnAddNew);
        this.setButtonDefaultStyl(this.btnView);
        this.setButtonDefaultStyl(this.btnEdit);
        this.setButtonDefaultStyl(this.btnRemove);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnAttachment);
        this.setButtonDefaultStyl(this.btnLocate);
        this.setButtonDefaultStyl(this.btnPageSetup);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.loadFields();
        this.getParameter();
        this.initializeUI();
        this.startkDWorkButton.setEnabled(false);
        this.enableKDWorkButton.setEnabled(false);
        this.disableKDWorkButton.setEnabled(false);
        this.showProcDefDiagramKDWorkButton.setEnabled(false);
        this.showProcInstKDWorkButton.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.actionDelete.setEnabled(false);
        this.actionQueryData.setEnabled(false);
        this.actionView.setEnabled(false);
        this.menuProcDef.setEnabled(false);
        this.menuProcInst.setEnabled(false);
        this.menuProcEnable.setEnabled(false);
        this.menuProcDisable.setEnabled(false);
        this.updateActions();
        this.tblMain.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ProcessDefineListUI.this.updateActions();
            }
        });
        this.wfBizType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UIContext uiContext = new UIContext((Object)ProcessDefineListUI.this.getParent());
                    IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    IUIWindow window = uiFactory.create(WfBizTypeListUI.class.getName(), (Map)uiContext);
                    window.show();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        });
        this.tblMain.getSelectManager().setSelectMode(10);
        if (!this.canBatchAdmin()) {
            this.btnBatchAdmin.setVisible(false);
        }
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    public ProcessDefineListUI() throws Exception {
        this.setLocatePre(false);
    }

    private void updateActions() {
        if (this.tblMain.getRowCount() == 0) {
            this.startkDWorkButton.setEnabled(false);
            this.enableKDWorkButton.setEnabled(false);
            this.disableKDWorkButton.setEnabled(false);
            this.showProcDefDiagramKDWorkButton.setEnabled(false);
            this.showProcInstKDWorkButton.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuProcDef.setEnabled(false);
            this.menuProcInst.setEnabled(false);
            this.menuProcEnable.setEnabled(false);
            this.menuProcDisable.setEnabled(false);
        } else {
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0) {
                String procDefID = this.getCurrentID(index);
                ProcessDefInfo procDefInfo = null;
                try {
                    procDefInfo = EnactmentServiceFactory.createRemoteEnactService().getProcessDefInfo(procDefID);
                }
                catch (WfException wfException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                if (procDefInfo != null) {
                    boolean isEable = procDefInfo.isEnable();
                    this.enableKDWorkButton.setEnabled(!isEable);
                    this.disableKDWorkButton.setEnabled(isEable);
                    this.showProcDefDiagramKDWorkButton.setEnabled(true);
                    this.showProcInstKDWorkButton.setEnabled(true);
                    this.btnRemove.setEnabled(true);
                    this.menuProcDef.setEnabled(true);
                    this.menuProcInst.setEnabled(true);
                    this.menuProcEnable.setEnabled(!isEable);
                    this.menuProcDisable.setEnabled(isEable);
                }
            } else {
                this.startkDWorkButton.setEnabled(false);
                this.enableKDWorkButton.setEnabled(false);
                this.disableKDWorkButton.setEnabled(false);
                this.showProcDefDiagramKDWorkButton.setEnabled(false);
                this.showProcInstKDWorkButton.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.menuProcDef.setEnabled(false);
                this.menuProcInst.setEnabled(false);
                this.menuProcEnable.setEnabled(false);
                this.menuProcDisable.setEnabled(false);
            }
        }
    }

    private void disableActions() {
        this.startkDWorkButton.setEnabled(false);
        this.enableKDWorkButton.setEnabled(false);
        this.disableKDWorkButton.setEnabled(false);
        this.showProcDefDiagramKDWorkButton.setEnabled(false);
        this.showProcInstKDWorkButton.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.menuProcDef.setEnabled(false);
        this.menuProcInst.setEnabled(false);
        this.menuProcEnable.setEnabled(false);
        this.menuProcDisable.setEnabled(false);
    }

    @Override
    public RequestContext prepareProcDefDiagramAction(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareProcDefDiagramAction(itemAction);
        int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
        if (index >= 0) {
            String procDefID = this.getCurrentID(index);
            request.put("procDefID", (Object)procDefID);
        }
        return request;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"FNAME", "FPROCCode"};
        return locateNames;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String processDefName = this.tblMain.getCell(selectIndex, 1).getValue().toString();
        String processDefId = this.tblMain.getCell(selectIndex, 0).getValue().toString();
        String temp = ReportResourceUtil.getReportMultiLanguageResource("DELETE_CONFIRM");
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)(temp + processDefName + "\uff1f"));
        if (result == 0) {
            try {
                IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
                service.deleteProcessDefine(processDefId);
                service.deleteBizProc(processDefId);
                this.refreshList();
            }
            catch (CannotDeleteException wfex) {
                if (wfex.getMessage().equalsIgnoreCase("can not delete this process define,because the process define has Instances process.")) {
                    MsgBox.showError((String)ReportResourceUtil.getReportMultiLanguageResource("PRODEF_CANNOT_DELETE"));
                }
                ExceptionHandler.handle((Component)((Object)this), (Throwable)wfex);
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return "FPROCDEFID";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.showProcInst();
        this.updateActions();
    }

    @Override
    public void actionBatchAdmin_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectrow = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String adminId = "";
        boolean issame = true;
        for (int i = 0; i < selectrow.length; ++i) {
            Object curId = this.tblMain.getRow(selectrow[i]).getCell("adminIds").getValue();
            if (curId == null) continue;
            if (!"".equals(adminId) && !adminId.equals(curId)) {
                issame = false;
                break;
            }
            adminId = curId.toString();
        }
        if (issame) {
            this.getUIContext().put("procdefadminIds", adminId);
        } else {
            this.getUIContext().put("procdefadminIds", "");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProcessDefSetAdminUI.class.getName(), this.getUIContext());
        uiWindow.show();
        if (((ProcessDefSetAdminUI)uiWindow.getUIObject()).isCancel()) {
            SysUtil.abort();
        }
        Object[] objects = (Object[])((ProcessDefSetAdminUI)uiWindow.getUIObject()).kDBizPromptBox1.getData();
        String curtext = ((ProcessDefSetAdminUI)uiWindow.getUIObject()).kDBizPromptBox1.getText();
        String adminIds = "";
        String adminNames = "";
        if (objects != null && objects.length > 0 && objects[0] != null) {
            for (int i = 0; i < objects.length; ++i) {
                PersonInfo person = (PersonInfo)objects[i];
                boolean isdel = true;
                if (!"".equals(curtext)) {
                    for (int j = 0; j < curtext.split(";").length; ++j) {
                        if (!person.getName().equals(curtext.split(";")[j].trim())) continue;
                        isdel = false;
                        break;
                    }
                }
                if (isdel) continue;
                adminIds = adminIds + person.getId() + ";";
                if (!"".equals(adminNames)) {
                    adminNames = adminNames + "\u3001";
                }
                adminNames = adminNames + person.getName();
            }
        }
        ArrayList ids = this.getSelectedIdValues();
        ProcDefFactory.getRemoteInstance().batchAdmin((List)ids, adminIds, adminNames);
        this.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        String fmt = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("FCREATEDTIME").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("FCREATEDTIME").setWidth(140);
        this.tblMain.getColumn("FENABLE").setWidth(60);
        this.tblMain.getColumn("FNAME").setWidth(160);
        this.tblMain.getColumn("FVALIDFROM").setWidth(140);
        this.tblMain.getColumn("FVALIDTO").setWidth(140);
        this.tblMain.getColumn("FAUTHOR").setWidth(100);
    }

    @Override
    public boolean isPrepareActionDisableProcess() {
        return true;
    }

    @Override
    public boolean isPrepareActionEnableProcess() {
        return true;
    }

    @Override
    public boolean isPrepareProcDefDiagramAction() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionShowProcInst() {
        return true;
    }

    @Override
    public RequestContext prepareActionShowProcInst(IItemAction itemAction) throws Exception {
        return super.prepareActionShowProcInst(itemAction);
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private boolean canBatchAdmin() {
        String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return "00000000-0000-0000-0000-00000000000013B7DE7F".equals(currentUserId);
    }

    class ProcessDefSelectListener
    implements KDTSelectListener {
        ProcessDefSelectListener() {
        }

        public void tableSelectChanged(KDTSelectEvent e) {
            if (e == null) {
                return;
            }
            KDTSelectBlock selectBlock = e.getSelectBlock();
            if (selectBlock == null) {
                return;
            }
            int beginRow = selectBlock.getBeginRow();
            if (beginRow < 0) {
                return;
            }
            ProcessDefineListUI.this.synchronizeButtonState(beginRow);
        }
    }
}

