/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ResponsibleDef;
import com.kingdee.bos.workflow.metas.ProcInstMonitorFactory;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.Pair;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.InputBox;
import com.kingdee.bos.workflow.monitor.client.PermissionUtil;
import com.kingdee.bos.workflow.monitor.client.PersonAndOpinionBox;
import com.kingdee.bos.workflow.monitor.client.WFCacheClearUI;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.bos.workflow.report.IProcessInstanceListUIFacade;
import com.kingdee.bos.workflow.report.client.AbstractProcessInstanceListUI;
import com.kingdee.bos.workflow.report.client.util.CompositeUtil;
import com.kingdee.bos.workflow.report.client.util.ReportResourceUtil;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.multiapprove.MetadataUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.bp.BPClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ProcessInstanceListUI
extends AbstractProcessInstanceListUI {
    private final String basicWorkFlowMonitorPanelClass = "com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel";
    private final String workflowResourceClass = "com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource";
    private static boolean isSynCU = false;
    private final String processInstLogListUIClass = "com.kingdee.bos.workflow.report.client.ProcessInstLogListUI";
    private final String processInstRePairUIClass = "com.kingdee.bos.workflow.report.client.ProcessInstRePairUI";
    private static Logger logger = Logger.getLogger(ProcessInstanceListUI.class);
    private String[] hidedColums = new String[]{"FPROCINSTID"};
    private String processDefID = "";
    private boolean isFristSortTable = true;
    private ISortManager sm = null;
    private int sort = 0;
    private SorterItemCollection oldSortItem = null;
    boolean enableOrgIsolation = false;
    boolean isQueryHistoryNow = false;
    EntityViewInfo mainQuery4Current = new EntityViewInfo();
    EntityViewInfo mainQuery4History = null;
    private Set orgIds = null;

    public ProcessInstanceListUI() throws Exception {
        this.showWrongInfoBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.billBtn.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.suspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        this.canSuspendBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abolishsuspend"));
        this.abortBtn.setIcon(EASResource.getIcon((String)"imgTbtn_abortinstance"));
        this.reAppointCeoBtn.setIcon(EASResource.getIcon((String)"imgTbtn_reappperform"));
        this.syncOrgUnitBtn.setIcon(EASResource.getIcon((String)"imgTbtn_syncpurview"));
        this.dataRepairBtn.setIcon(EASResource.getIcon((String)"imgTbtn_automatching"));
        this.saDataSyncBtn.setEnabled(true);
        this.saDataSyncBtn.setIcon(EASResource.getIcon((String)"imgTbtn_monadismpostil"));
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ProcessInstanceListUI.this.tblMain_tableSelectChanged(e);
            }
        });
        this.suspendBtn.setVisible(false);
        this.resetBtnText();
    }

    private boolean hasSelect() {
        int size = this.tblMain.getSelectManager().size();
        int rts = 0;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            rts += sb.getBottom() - sb.getTop() + 1;
        }
        return rts != 0;
    }

    @Override
    public void actionCanSuspend_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MessageDialog.show((Component)((Object)this), (Object)ReportResourceUtil.getReportMultiLanguageResource("WFReport_CONFIRM2"), (String)ReportResourceUtil.getReportMultiLanguageResource("WFReport_PROMPT"), (int)2) != 0) {
            return;
        }
        try {
            int size = this.tblMain.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    String state = this.getProcessInstanceState(j);
                    if (!state.equals(WfState.SUSPENDED.getValue()) && !state.equals(WfState.BLOCKED.getValue())) continue;
                    EnactmentServiceFactory.createRemoteEnactService().resumeProcessInst(this.getProcessInstanceID(j));
                }
            }
            this.refreshList();
            this.initButtonState();
        }
        catch (Exception e1) {
            this.handleException("resumeProcessErrMSg");
        }
    }

    @Override
    public void actionSuspend_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MessageDialog.show((Component)((Object)this), (Object)ReportResourceUtil.getReportMultiLanguageResource("WFReport_CONFIRM"), (String)ReportResourceUtil.getReportMultiLanguageResource("WFReport_PROMPT"), (int)2) != 0) {
            return;
        }
        try {
            int size = this.tblMain.getSelectManager().size();
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    String state = this.getProcessInstanceState(j);
                    if (!state.equals(WfState.RUNNING.getValue())) continue;
                    EnactmentServiceFactory.createRemoteEnactService().suspendProcessInst(this.getProcessInstanceID(j));
                }
            }
            this.refreshList();
            this.initButtonState();
        }
        catch (Exception e1) {
            this.handleException("suspendProcessErrorMsg");
        }
    }

    @Override
    public void actionAbort_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.checkOperateProcessPermission("wf_report_Monitor_OperateAbort")) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("ABORT_CONFIRM")) == 0) {
                String reason = InputBox.read();
                if (reason == null) {
                    return;
                }
                try {
                    int size = this.tblMain.getSelectManager().size();
                    IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
                    IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
                    for (int i = 0; i < size; ++i) {
                        KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                        for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                            String state = this.getProcessInstanceState(j);
                            if (!state.equals(WfState.SUSPENDED.getValue()) && !state.equals(WfState.BLOCKED.getValue()) && !state.equals(WfState.RUNNING.getValue())) continue;
                            boolean isIgnoreShareCenter = ems.isIgnoreShareCenter(this.getProcessInstanceID(j));
                            if (!isIgnoreShareCenter) {
                                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHARENOTABORT"));
                                return;
                            }
                            util.abortForWfMonitor(this.getProcessInstanceID(j), reason);
                        }
                    }
                    this.refreshList();
                    this.initButtonState();
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    this.handleException("abortProcessErrMsg");
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("DonotSuspended"));
        }
    }

    private boolean checkOperateProcessPermission(String permissionName) throws EASBizException, BOSException {
        boolean perm = false;
        try {
            PermissionUtil permissionUtil = new PermissionUtil();
            perm = permissionUtil.checkOperate(null, permissionName);
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return perm;
    }

    private void handleException(String errMsgKey) {
        MsgBox.showError((String)ReportResourceUtil.getReportMultiLanguageResource(errMsgKey));
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int result = MsgBox.showConfirm2((String)ReportResourceUtil.getReportMultiLanguageResource("DELETE_CONFIRM"));
        if (result != 0) {
            return;
        }
        IObjectPK pk = null;
        try {
            int size = this.tblMain.getSelectManager().size();
            pk = LogUtil.beginLog(null, (String)ReportResourceUtil.getReportMultiLanguageResource("DelProcinst"), (BOSObjectType)new BOSObjectType("WFPCINST"), null, (String)(ReportResourceUtil.getReportMultiLanguageResource("DelProcinst") + "(" + size + ")" + ReportResourceUtil.getReportMultiLanguageResource("DelNumber")));
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    String state = this.getProcessInstanceState(j);
                    if (!state.equals(WfState.ABORTED.getValue()) && !state.equals(WfState.TERMINATED.getValue()) && !state.equals(WfState.COMPLETED.getValue())) continue;
                    EnactmentServiceFactory.createRemoteEnactService().deleteProcessInst(this.getProcessInstanceID(j));
                }
            }
            this.refreshList();
            this.initButtonState();
            LogUtil.afterLog(null, (IObjectPK)pk);
        }
        catch (Exception e1) {
            this.handleException("abortProcessErrMsg");
        }
    }

    private boolean checkOperatePermission(String instId, String permissionName) throws EASBizException, BOSException {
        boolean perm = false;
        try {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            String hash = EnactmentServiceFactory.createRemoteEnactService().getProcessInstInfo(instId).getProcDefHashValue();
            ProcessDef processDef = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(hash);
            ResponsibleCollection respons = processDef.getProcessHeader().getResponsibles();
            if (respons != null) {
                for (ResponsibleDef resDef : respons) {
                    String id = resDef.getID();
                    if (!id.equals(user.getPerson().getId().toString())) continue;
                    return true;
                }
            }
            IPermission permission = PermissionFactory.getRemoteInstance();
            permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), null, null, permissionName);
            perm = true;
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return perm;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionQueryHistoryData_actionPerformed(ActionEvent e) throws Exception {
        this.queryHistoryData(e);
    }

    @Override
    public RequestContext prepareActionShowProcessDiagram(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionShowProcessDiagram(itemAction);
        int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
        if (index >= 0) {
            String id = this.getProcessInstanceID(index);
            request.put("proceInstId", (Object)id);
        }
        request.put("userId", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        return request;
    }

    @Override
    public void actionShowProcessDiagram_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showProcessDiagram();
    }

    @Override
    public void actionShowWrongInfo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showProcessWrongInfo();
    }

    @Override
    public void actionDump_actionPerformed(ActionEvent e) throws Exception {
        int conFirm = MsgBox.showConfirm2((String)ReportResourceUtil.getReportMultiLanguageResource("DumpReminder"));
        if (conFirm == 2) {
            return;
        }
        try {
            BPClient.invokeServer((String)"com.kingdee.bos.workflow.metas.AdjustWfData", (String)"dumpWfData", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{new Integer(0)});
        }
        catch (Throwable ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public void onLoad() throws Exception {
        Set orgIds;
        if (this.getUIContext().get("isFormWfDefineListUI") != null && ((Boolean)this.getUIContext().get("isFormWfDefineListUI")).booleanValue() && this.getUIContext().get("ProcessDefineID") != null) {
            this.processDefID = this.getUIContext().get("ProcessDefineID").toString();
        }
        this.tblMain.addKDTDataFillListener((KDTDataFillListener)new DataFillListener());
        super.onLoad();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        this.btnRemove.setVisible("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userId));
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(userId)) {
            this.dataRepairBtn.setVisible(false);
            this.dataRepairBtn.setEnabled(false);
            this.saDataSyncBtn.setVisible(false);
            this.saDataSyncBtn.setEnabled(false);
            this.showAutoFixRecord.setVisible(false);
            this.showAutoFixRecord.setEnabled(false);
        } else {
            this.saDataSyncBtn.setVisible(true);
            this.saDataSyncBtn.setEnabled(true);
        }
        this.getParameter();
        this.initializeUI();
        IProcessInstanceListUIFacade facade = (IProcessInstanceListUIFacade)RpcProxy.wrapNoSupport(IProcessInstanceListUIFacade.class);
        IProcessInstanceListUIFacade.InitData initData = facade.prepareForInit();
        if (this.getUIContext().get("isFormWfDefineListUI") == null || !((Boolean)this.getUIContext().get("isFormWfDefineListUI")).booleanValue()) {
            // empty if block
        }
        if ((orgIds = initData.orgIds) != null) {
            if (orgIds.size() == 0) {
                orgIds.add("nothing");
            }
            FilterItemInfo info = new FilterItemInfo("controlUnitID", (Object)orgIds, CompareType.INCLUDE);
            FilterItemInfo infoNUll = new FilterItemInfo("controlUnitID", null, CompareType.IS);
            FilterInfo fi = this.mainQuery.getFilter();
            if (fi == null) {
                fi = new FilterInfo();
                this.mainQuery.setFilter(fi);
            }
            int filterSize = fi.getFilterItems().size();
            fi.getFilterItems().add(info);
            fi.getFilterItems().add(infoNUll);
            String maskString = fi.getMaskString();
            if (StringUtils.isEmpty((String)maskString)) {
                fi.setMaskString("#0 or #1");
            } else {
                fi.setMaskString("(" + maskString + ") AND (#" + filterSize + " or #" + (filterSize + 1) + ")");
            }
            this.orgIds = orgIds;
        }
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F9"), "actionCache");
        this.getActionMap().put("actionCache", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WFCacheClearUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                    uiWindow.show();
                }
                catch (UIException uIException) {
                    // empty catch block
                }
            }
        });
        this.mainQuery4Current = super.getEntityViewInfo(this.mainQuery4Current);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("FPROCDEFNAME").setWidth(150);
        this.tblMain.getColumn("FPROCINSTTOPIC").setWidth(250);
        this.tblMain.getColumn("FCREATEDTIME").setWidth(150);
        this.tblMain.getColumn("FPROCDEFVER").setWidth(50);
        this.tblMain.getColumn("FSTATE").setWidth(50);
        this.tblMain.getColumn("FCODE").setWidth(200);
        this.initButtonState();
    }

    private void initButtonState() {
        boolean isSuspend = false;
        boolean isCanSuspend = false;
        boolean isAbort = false;
        boolean canDelete = true;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                String state = this.getProcessInstanceState(j);
                if (state.equals(WfState.SUSPENDED.getValue())) {
                    isCanSuspend = true;
                    isAbort = true;
                    canDelete = false;
                    continue;
                }
                if (state.equals(WfState.RUNNING.getValue())) {
                    isSuspend = true;
                    isAbort = true;
                    canDelete = false;
                    continue;
                }
                if (state.equals(WfState.BLOCKED.getValue())) {
                    isCanSuspend = true;
                    isAbort = true;
                    canDelete = false;
                    continue;
                }
                if (state.equals(WfState.NOT_STARTED.getValue())) {
                    isAbort = true;
                    canDelete = false;
                    continue;
                }
                if (state.equals(WfState.NOT_RUNNING.getValue())) {
                    canDelete = false;
                    continue;
                }
                if (!state.equals(WfState.ROLLBACKED.getValue())) continue;
                canDelete = false;
            }
        }
        this.suspendBtn.setEnabled(isSuspend);
        this.canSuspendBtn.setEnabled(isCanSuspend);
        this.abortBtn.setEnabled(isAbort);
        this.btnRemove.setEnabled(canDelete);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user.getPerson() == null) {
            return filter;
        }
        String sql = null;
        sql = this.isQueryHistoryNow ? "FPROCINSTID in (SELECT b.fprocinstid FROM t_wfr_procdef a,t_wfr_procinsthst b where a.FPROCDEFID = b.FPROCDEFID and a.finnerversion =b.FPROCDEFVER and (a.fadminids is null or a.fadminids ='' or a.fadminids like '%" + user.getPerson().getId() + ";%'))" : "FPROCINSTID in (SELECT b.fprocinstid FROM t_wfr_procdef a,t_wfr_procinst b where a.FPROCDEFID = b.FPROCDEFID and a.finnerversion =b.FPROCDEFVER and (a.fadminids is null or a.fadminids ='' or a.fadminids like '%" + user.getPerson().getId() + ";%'))";
        filter.getFilterItems().add(new FilterItemInfo(sql));
        filter.setMaskString("#0");
        if (this.orgIds == null) {
            return filter;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("controlUnitID", (Object)this.orgIds, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("controlUnitID", null, CompareType.IS));
        fi.setMaskString("#0 or #1");
        try {
            fi.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return fi;
    }

    protected String getKeyFieldName() {
        return "FPROCINSTID";
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) {
        this.initButtonState();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            SorterItemInfo sortName;
            if (this.isFristSortTable) {
                this.sm = new KDTSortManager(this.tblMain);
                this.oldSortItem = (SorterItemCollection)this.mainQuery.getSorter().clone();
                this.isFristSortTable = false;
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            if (this.sort == 0) {
                sortName = new SorterItemInfo(this.tblMain.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.ASCEND);
                this.setSortForQuery(sortName);
            } else {
                sortName = new SorterItemInfo(this.tblMain.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.DESCEND);
                this.setSortForQuery(sortName);
            }
        }
        if (e.getClickCount() != 1 && e.getClickCount() == 2) {
            boolean permit = true;
            if (permit) {
                this.showProcessDiagram();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("NotHavePermission"));
            }
        }
    }

    private void setSortForQuery(SorterItemInfo sortItem) throws Exception {
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().addObjectCollection((IObjectCollection)this.oldSortItem);
        Iterator iter = this.mainQuery.getSorter().iterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                SorterItemInfo sort = (SorterItemInfo)iter.next();
                if (!sort.getPropertyName().equals(sortItem.getPropertyName())) continue;
                sort.setSortType(sortItem.getSortType());
            }
        } else {
            this.mainQuery.getSorter().add(sortItem);
        }
        this.refreshListForOrder();
    }

    private void queryHistoryData(ActionEvent e) throws Exception {
        String actionCommand = e.getActionCommand();
        if ("queryHistory".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryCurrentState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
            this.isQueryHistoryNow = true;
            if (this.mainQuery4History == null) {
                this.mainQuery4History = new EntityViewInfo();
                this.mainQuery4History = super.getEntityViewInfo(this.mainQuery4History);
            }
            this.mainQuery = this.mainQuery4History;
            this.mainQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "ProcInstHst");
            this.refreshList();
        } else if ("queryCurrent".equalsIgnoreCase(actionCommand)) {
            ReportUtil.setQueryHistoryState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
            this.isQueryHistoryNow = false;
            this.mainQuery = this.mainQuery4Current;
            this.mainQueryPK = new MetaDataPK("com.kingdee.bos.workflow.metas", "ProcInst");
            this.refreshList();
        }
    }

    private void setButtonIco() {
        this.showProcessDiagramKDWorkButton.setIcon(EASResource.getIcon((String)"imgTbtn_flowstakeout"));
    }

    private void initializeUI() {
        this.windowTitle = this.getWindowTitle();
        this.setButtonIco();
        ReportUtil.setQueryHistoryState(this.queryHistoryKDWorkButton, this.queryHistoryMnItm);
        this.tblMain.getSelectManager().setSelectMode(10);
        CompositeUtil.setTableReadOnly(this.tblMain);
        CompositeUtil.hideColumns(this.tblMain, this.hidedColums);
        if (this.processDefID != null) {
            this.queryData0(true);
        }
        Icon icon = EASResource.getIcon((String)"imgTbtn_conversionsave");
        this.btnDump.setIcon(icon);
        try {
            if (isSynCU) {
                isSynCU = ProcInstMonitorFactory.getRemoteInstance().isAlreadySynCU();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (isSynCU) {
            this.syncOrgUnitBtn.setVisible(false);
            this.syncOrgUnitBtn.setEnabled(false);
        }
    }

    private void queryData0(boolean isCloseWindow) {
        if (this.processDefID != null) {
            FilterItemInfo fii = new FilterItemInfo("procdefID", (Object)this.processDefID, CompareType.EQUALS);
            FilterInfo fi = this.mainQuery.getFilter();
            if (fi == null) {
                fi = new FilterInfo();
                this.mainQuery.setFilter(fi);
            }
            fi.getFilterItems().add(fii);
        } else if (isCloseWindow) {
            SysUtil.abort();
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        if (postman != null) {
            RequestContext request = (RequestContext)postman.getRequestContext();
            String uiName = ((Object)((Object)this)).getClass().getName();
            String queryName = this.mainQueryPK.getFullName();
            request.put("uiName", (Object)uiName);
            request.put("queryName", (Object)queryName);
            request.put("uiClassName", (Object)((Object)((Object)this)).getClass().getName());
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    private void queryData1(boolean isCloseWindow, EntityViewInfo defaultFilter) throws BOSException, EASBizException {
        FilterInfo filterInfo = this.mainQuery.getFilter();
        if (filterInfo != null) {
            filterInfo.getFilterItems().clear();
            filterInfo.setMaskString(null);
        }
        if (defaultFilter != null) {
            this.mainQuery = defaultFilter;
        }
    }

    private String getProcessInstanceID(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell("FPROCINSTID")) != null && (destValue = destCell.getValue()) != null && destValue instanceof String) {
            return (String)destValue;
        }
        return "";
    }

    private String getProcessInstanceState(int rowIndex) {
        Object destValue;
        ICell destCell;
        IRow currentRow = this.tblMain.getRow(rowIndex);
        if (currentRow != null && (destCell = currentRow.getCell("FSTATE")) != null && (destValue = destCell.getValue()) != null && destValue instanceof BizEnumValueDTO) {
            return (String)((BizEnumValueDTO)destValue).getValue();
        }
        return "";
    }

    private void getParameter() {
        this.processDefID = (String)this.getUIContext().get("ProcessDefineID");
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        boolean permit = true;
        if (permit) {
            this.showProcessDiagram();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("NotHavePermission"));
        }
    }

    private String getWindowTitle() {
        return ReportResourceUtil.getReportName("ProcessInstance_Normal");
    }

    private void showProcessDiagram() {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0 && (id = this.getProcessInstanceID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"id", (Object)id);
                uiContext.put((Object)"OpenAsNewWin", (Object)"");
                uiContext.put((Object)"isOpenedByWfMonitorUI", (Object)"true");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel", (Map)uiContext);
                if (uiWindow instanceof UINewFrame) {
                    UINewFrame frame = (UINewFrame)uiWindow;
                    uiWindow.show();
                    frame.setExtendedState(6);
                }
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    private void showProcessWrongInfo() {
        try {
            String id;
            int index = CompositeUtil.getCurrentRowIndex(this.tblMain);
            if (index >= 0 && (id = this.getProcessInstanceID(index)) != null && id.length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"processInstId", (Object)id);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.workflow.report.client.ProcessInstLogListUI", (Map)uiContext);
                uiWindow.show();
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"UIException", (Throwable)e);
        }
    }

    @Override
    public boolean isPrepareActionShowProcessDiagram() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public void actionReAppointCeo_actionPerformed(ActionEvent e) throws Exception {
        block14: {
            int conFirm;
            ActivityInstInfo tActivityInfo;
            this.checkSelected();
            if (!this.checkOperateActivityPermission("wf_report_Monitor_ActivityProperty_DesignatePerformer")) {
                this.handleExceptionActivity("noPerm");
                return;
            }
            List tList = this.getProcInstIds();
            IEnactmentService svcice = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo firstProcInstInfo = null;
            ActivityDef firstActDef = null;
            ArrayList<ActivityInstInfo> activityInfos = new ArrayList<ActivityInstInfo>();
            for (int index = 0; index < tList.size(); ++index) {
                String procInstId = (String)tList.get(index);
                ProcessInstInfo procInstInfo = svcice.getProcessInstInfo(procInstId);
                if (!WfState.SUSPENDED.getValue().equals(procInstInfo.getState())) {
                    MsgBox.showError((String)ReportResourceUtil.getReportMultiLanguageResource("ReACeoChooseAg"));
                    return;
                }
                IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
                boolean isShare = ems.isShareCenterAssign(procInstId);
                if (isShare) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)"ISSHAREREREPAET"));
                    return;
                }
                HashSet tSet = new HashSet();
                ActivityInstInfo[] activityList = svcice.getRelatedActInstsByProcInstID(procInstId);
                if (activityList == null || activityList.length <= 0) continue;
                boolean isSusManPower = false;
                for (int indexAct = 0; indexAct < activityList.length; ++indexAct) {
                    ActivityDef actDef;
                    boolean isClosedState;
                    tActivityInfo = activityList[indexAct];
                    boolean bl = isClosedState = tActivityInfo.getState().equals(WfState.ABORTED.getValue()) || tActivityInfo.getState().equals(WfState.COMPLETED.getValue()) || tActivityInfo.getState().equals(WfState.TERMINATED.getValue()) || tActivityInfo.getState().equals(WfState.CLOSED.getValue());
                    if (isClosedState || !((actDef = svcice.getActDefByActInstInfo(tActivityInfo)) instanceof ManpowerActivityDef)) continue;
                    isSusManPower = true;
                    if (firstProcInstInfo == null) {
                        firstProcInstInfo = procInstInfo;
                        firstActDef = actDef;
                        activityInfos.add(tActivityInfo);
                        continue;
                    }
                    String firstProcDefId = firstProcInstInfo.getProcDefId();
                    int firstVersion = firstProcInstInfo.getProcDefInnerVersion();
                    String firstActDefId = firstActDef.getID();
                    String procDefId = procInstInfo.getProcDefId();
                    int version = procInstInfo.getProcDefInnerVersion();
                    String actDefId = actDef.getID();
                    if (!firstProcDefId.equals(procDefId) || firstVersion != version || !firstActDefId.equals(actDefId)) continue;
                    activityInfos.add(tActivityInfo);
                }
                if (isSusManPower) continue;
                MsgBox.showError((String)ReportResourceUtil.getReportMultiLanguageResource("ReACeoNoMumanNodes"));
                return;
            }
            int allCount = tList.size();
            int dealCount = activityInfos.size();
            if (dealCount <= 0) {
                MsgBox.showError((String)ReportResourceUtil.getReportMultiLanguageResource("ReACeoNoActivity"));
                return;
            }
            if (allCount > dealCount && (conFirm = MsgBox.showConfirm2((String)ReportResourceUtil.getReportMultiLanguageResource("ReACeoDealOther"))) == 2) {
                return;
            }
            if (activityInfos != null && activityInfos.size() > 0) {
                String label = ((KDWorkButton)e.getSource()).getText();
                Pair results = PersonAndOpinionBox.readType((String)label, (int)0);
                if (results == null) {
                    return;
                }
                try {
                    PersonInfo personInfo = (PersonInfo)results.getB();
                    String personId = personInfo.getId().toString();
                    if (WfUtils.checkPersonHasUser((String)personId)) {
                        MsgBox.showInfo((String)ReportResourceUtil.getReportMultiLanguageResource("BackServerProce"));
                        String[] personIdArray = new String[]{personId};
                        IWfUtil util = (IWfUtil)RpcProxy.wrapRequired(IWfUtil.class, (String)WfUtil.class.getName());
                        for (int index = 0; index < activityInfos.size(); ++index) {
                            tActivityInfo = (ActivityInstInfo)activityInfos.get(index);
                            util.reassignToPerson(tActivityInfo.getActInstId(), personIdArray, (String)results.getA());
                        }
                        break block14;
                    }
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorImageDescriptionResource", (String)"msgPersonHasNoUser"));
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)"\u65e0\u6cd5\u91cd\u65b0\u6307\u5b9a\u53c2\u4e0e\u4eba\uff01", (Throwable)ex);
                    System.out.println("\u65e0\u6cd5\u91cd\u65b0\u6307\u5b9a\u53c2\u4e0e\u4eba,\u539f\u56e0:");
                    ex.printStackTrace();
                    this.handleException("reAssignErrMsg");
                }
            }
        }
    }

    private void handleExceptionActivity(String errMsgKey) {
        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.bos.workflow.monitor.client.WorkFlowMonitorResource", (String)errMsgKey));
    }

    public List getProcInstIds() {
        ArrayList<Object> tList = new ArrayList<Object>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                Object destValue;
                ICell destCell = this.tblMain.getRow(j).getCell("FPROCINSTID");
                if (destCell == null || (destValue = destCell.getValue()) == null || !(destValue instanceof String)) continue;
                tList.add(destValue);
            }
        }
        return tList;
    }

    private boolean checkOperateActivityPermission(String permissionName) throws EASBizException, BOSException {
        boolean perm = false;
        try {
            PermissionUtil permissionUtil = new PermissionUtil();
            perm = permissionUtil.checkOperate(null, permissionName);
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
        catch (BOSException e2) {
            this.handleException((Exception)((Object)e2));
        }
        return perm;
    }

    @Override
    public void actionSyncOrgUnitBtn_actionPerformed(ActionEvent e) throws Exception {
        int confirm = MsgBox.showConfirm2((String)ReportResourceUtil.getReportMultiLanguageResource("SyncReminder"));
        if (confirm == 2) {
            return;
        }
        try {
            BPClient.invokeServer((String)"com.kingdee.bos.workflow.metas.ProcInstMonitor", (String)"synProcInstCUData", (Class[])new Class[0], (Object[])new Object[0]);
            this.syncOrgUnitBtn.setVisible(false);
            this.syncOrgUnitBtn.setEnabled(false);
        }
        catch (Throwable ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IEnactmentService ems = EnactmentServiceFactory.createRemoteEnactService();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String instId = this.getProcessInstanceID(rowIndex);
        String bizObjId = ems.getBizObjIdByProcessInstanceId(instId);
        boolean isOpenByMessage = false;
        if (!StringUtils.isEmpty((String)bizObjId)) {
            try {
                String className = "com.kingdee.eas.base.message.client.MessageServiceProvider";
                String methodName = "showWFBIllByBillId";
                Class[] parameterTypes = new Class[]{Component.class, String.class, String.class};
                Object[] args = new Object[]{this, bizObjId, null};
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, parameterTypes);
                m.invoke(c, args);
                isOpenByMessage = true;
            }
            catch (Throwable t) {
                isOpenByMessage = false;
            }
        }
        if (!isOpenByMessage) {
            String editUIName = "";
            if (!StringUtils.isEmpty((String)bizObjId)) {
                editUIName = MetadataUtils.getEditUIClassByBillId((String)bizObjId);
            }
            if (StringUtils.isEmpty((String)bizObjId) || StringUtils.isEmpty((String)editUIName)) {
                MsgBox.showWarning((Component)((Object)this), (String)ReportResourceUtil.getReportMultiLanguageResource("OpenBillError"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)bizObjId);
            uiContext.put((Object)"isFromWorkflow", (Object)new Boolean(true));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionDataRepair_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String instId = this.getProcessInstanceID(rowIndex);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"processInstId", (Object)instId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.workflow.report.client.ProcessInstRePairUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionSADataSync_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.workflow.report.client.ProcessInstSADataSynUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionShowAutoFixRecord_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.bos.workflow.monitor.client.AutoFixRecordListUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (!StringUtils.isEmpty((String)this.processDefID)) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("procdefID", (Object)this.processDefID, CompareType.EQUALS);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(filterItemInfo);
            try {
                if (ev.getFilter() != null) {
                    ev.getFilter().mergeFilter(filterInfo, "AND");
                } else {
                    ev.setFilter(filterInfo);
                }
            }
            catch (Exception e) {
                ev.setFilter(filterInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterTableDataFill(KDTDataRequestEvent dre) {
        int lastRow;
        int firstRow = dre.getFirstRow();
        if (firstRow <= (lastRow = dre.getLastRow())) {
            KDTable kDTable = this.tblMain;
            synchronized (kDTable) {
                StringBuffer strBuf = new StringBuffer();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (int i = firstRow; i <= lastRow; ++i) {
                    String procinstid = (String)this.tblMain.getRow(i).getCell("FPROCINSTID").getValue();
                    if (i == firstRow) {
                        strBuf.append("('" + procinstid + "'");
                    } else {
                        strBuf.append(",'" + procinstid + "'");
                    }
                    map.put(procinstid, i);
                }
                strBuf.append(")");
                HashMap<Integer, String> executorMap = new HashMap<Integer, String>();
                try {
                    String local = SysContext.getSysContext().getLocale().toString();
                    String userName = "fpersonUsername_" + local;
                    String qrySql = "select fprocinstid," + userName + " from t_wfr_assign where fstate=1 and fprocinstid in " + strBuf.toString();
                    IRowSet rs = new SQLExecutor(qrySql).executeSQL();
                    while (rs.next()) {
                        String procinstid = rs.getString("fprocinstid");
                        String executor = rs.getString(userName);
                        int positionIndex = (Integer)map.get(procinstid);
                        String executorName = (String)executorMap.get(positionIndex);
                        if (StringUtil.isEmpty((String)executorName)) {
                            executorMap.put(positionIndex, executor);
                            continue;
                        }
                        if (this.checkExit(executorName.split(","), executor)) continue;
                        executorMap.put(positionIndex, executorName + "," + executor);
                    }
                    for (Map.Entry entry : executorMap.entrySet()) {
                        this.tblMain.getRow(((Integer)entry.getKey()).intValue()).getCell("EXECUTORNAMES").setValue(entry.getValue());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("remote\u83b7\u53d6\u6267\u884c\u4eba\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5!" + e));
                }
            }
        }
    }

    public boolean checkExit(String[] sources, String checkString) {
        boolean flag = false;
        for (String sour : sources) {
            if (!sour.equalsIgnoreCase(checkString)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void execQuery() {
        FilterInfo filter = this.mainQuery.getFilter();
        if (null != filter) {
            FilterItemCollection fiCol = filter.getFilterItems();
            FilterItemInfo executor = null;
            String whereSql = "";
            int filterSize = fiCol.size();
            String local = SysContext.getSysContext().getLocale().toString();
            String userName = "fpersonUsername_" + local;
            for (int i = 0; i < filterSize; ++i) {
                if (!fiCol.get(i).getPropertyName().equalsIgnoreCase("EXECUTORNAMES")) continue;
                executor = fiCol.get(i);
                whereSql = executor.toString();
                String qrySql = "FPROCINSTID in (select fprocinstid from t_wfr_assign where fstate=1 and " + whereSql.replace("EXECUTORNAMES", userName) + ")";
                if ("EXECUTORNAMES IS EMPTY".equalsIgnoreCase(whereSql)) {
                    qrySql = "FPROCINSTID not in (select fprocinstid from t_wfr_assign where fstate=1)";
                } else if ("EXECUTORNAMES IS NOT EMPTY".equalsIgnoreCase(whereSql)) {
                    qrySql = "FPROCINSTID in (select fprocinstid from t_wfr_assign where fstate=1)";
                } else if (whereSql.indexOf("EXECUTORNAMES not like") > -1) {
                    whereSql = whereSql.replace("not like", "like");
                    qrySql = "FPROCINSTID not in (select fprocinstid from t_wfr_assign where fstate=1 and " + whereSql.replace("EXECUTORNAMES", userName) + "))";
                } else if (whereSql.indexOf("EXECUTORNAMES <>") > -1) {
                    whereSql = whereSql.replace("<>", "=");
                    qrySql = "FPROCINSTID not in (select fprocinstid from t_wfr_assign where fstate=1 and " + whereSql.replace("EXECUTORNAMES", userName) + "))";
                }
                executor = new FilterItemInfo(qrySql);
                fiCol.set(i, executor);
            }
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
    }

    private void resetBtnText() {
        String local = SysContext.getSysContext().getLocale().toString();
        if (local.equalsIgnoreCase("l1") || local.equalsIgnoreCase("en_us")) {
            this.showAutoFixRecord.setText("autoFix");
        } else if (local.equalsIgnoreCase("l2") || local.equalsIgnoreCase("zh_cn")) {
            this.showAutoFixRecord.setText("\u81ea\u52a8\u4fee\u590d");
        } else {
            this.showAutoFixRecord.setText("\u81ea\u52d5\u4fee\u5fa9");
        }
    }

    class DataFillListener
    implements KDTDataFillListener {
        DataFillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ProcessInstanceListUI.this.afterTableDataFill(e);
        }
    }
}

