/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.caldate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncMange;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class CalworkCalenderInfo {
    private static Logger log = Logger.getLogger(CalworkCalenderInfo.class);
    private Context ctx;
    private String calenderId;
    private java.util.Date bTimeAm = null;
    private java.util.Date eTimeAm = null;
    private java.util.Date bTimePm = null;
    private java.util.Date eTimePm = null;
    private java.util.Date startWorkDate = null;
    private java.util.Date endWorkDate = null;
    private static final SimpleDateFormat sdfHOURandMINUTE = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat sdfHHMMSS = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat sdfYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DecimalFormat dfDecimal = new DecimalFormat("#.00");
    private static final long defaultMSTime = 1000L;
    private Map<String, Integer> calendarentryMap = new ConcurrentHashMap<String, Integer>();
    private long morningWorkTimems;
    private long afternoonWorkTimems;
    private long oneDayWorkTimems;
    private List<String> morningWorkDateList = new ArrayList<String>();
    private List<String> afternoonWorkDateList = new ArrayList<String>();

    public CalworkCalenderInfo(String calenderId, Context ctx) throws Exception {
        this.calenderId = calenderId;
        this.ctx = ctx;
        this.init();
    }

    private void init() throws EASBizException, BOSException, ParseException, SQLException {
        String sql = "select fstartWorkDate,fendWorkDate,fbeginTimeAM,fendTimeAM,fbeginTimePM,fendTimePM from T_WorkCalendar  where  fid = '" + this.calenderId + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        if (!rs.next()) {
            throw new BOSException(this.calenderId + " \u5bf9\u5e94\u7684\u5de5\u4f5c\u65e5\u5386\u5df2\u4e0d\u5b58\u5728");
        }
        this.startWorkDate = rs.getDate("fstartWorkDate");
        this.endWorkDate = rs.getDate("fendWorkDate");
        this.bTimeAm = this.constructHHMMDate(rs.getString("fbeginTimeAM"));
        this.eTimeAm = this.constructHHMMDate(rs.getString("fendTimeAM"));
        this.bTimePm = this.constructHHMMDate(rs.getString("fbeginTimePM"));
        this.eTimePm = this.constructHHMMDate(rs.getString("fendTimePM"));
        this.morningWorkTimems = this.eTimeAm.getTime() - this.bTimeAm.getTime();
        this.afternoonWorkTimems = this.eTimePm.getTime() - this.bTimePm.getTime();
        this.oneDayWorkTimems = this.morningWorkTimems + this.afternoonWorkTimems;
        this.initWorkDateList();
    }

    private void initWorkDateList() throws BOSException {
        try {
            String sql = "select fdatetype,fworkdate from t_workcalendardayentry where fworkcanlendarid = '" + this.calenderId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowSet.next()) {
                int dateType = rowSet.getInt("fDateType");
                Date workDate = rowSet.getDate("fworkDate");
                this.calendarentryMap.put(sdfYMMDD.format(workDate), dateType);
            }
            java.util.Date currentDate = this.startWorkDate;
            while (currentDate.before(this.endWorkDate)) {
                String date = sdfYMMDD.format(currentDate);
                if (this.calendarentryMap.get(date) == null) {
                    if (!this.isWeekend(currentDate)) {
                        this.morningWorkDateList.add(date);
                        this.afternoonWorkDateList.add(date);
                    }
                } else {
                    int dateType = this.calendarentryMap.get(date);
                    if (dateType == 1) {
                        this.morningWorkDateList.add(date);
                        this.afternoonWorkDateList.add(date);
                    } else if (dateType == 4) {
                        this.morningWorkDateList.add(date);
                    }
                }
                currentDate = this.addOneDate(currentDate);
            }
        }
        catch (SQLException e) {
            log.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u96c6\u5408\u51fa\u9519", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private java.util.Date addOneDate(java.util.Date date) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(5, 1);
        return calender.getTime();
    }

    private java.util.Date subOneDate(java.util.Date date) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(5, -1);
        return calender.getTime();
    }

    private boolean isWeekend(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    private java.util.Date constructHHMMDate(String time) throws ParseException {
        String[] valuesBA = StringUtil.split((String)time, (String)"-");
        return sdfHOURandMINUTE.parse(String.valueOf(valuesBA[0] + ":" + valuesBA[1]));
    }

    private java.util.Date constructHHMMSSDate(java.util.Date time) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return sdfHHMMSS.parse(String.valueOf(hour + ":" + minute + ":" + second));
    }

    public BigDecimal calWorkTime(java.util.Date startDate, java.util.Date endDate, String timeType) throws BOSException {
        long msecends;
        block8: {
            msecends = 1000L;
            try {
                if (startDate != null && endDate != null) {
                    msecends = this.calWorkTime(startDate, endDate);
                }
            }
            catch (Exception e) {
                if (SAProcessDATASyncMange.logIsClose) break block8;
                log.error((Object)("\u5de5\u4f5c\u65f6\u95f4\u8ba1\u7b97\u51fa\u9519startDate\uff1a" + sdfDate.format(startDate) + " endDate:" + sdfDate.format(endDate)), (Throwable)e);
            }
        }
        if ("MS".equals(timeType)) {
            return new BigDecimal(msecends);
        }
        if ("S".equals(timeType)) {
            return new BigDecimal((double)msecends / 1000.0).setScale(2, 4);
        }
        if ("M".equals(timeType)) {
            return new BigDecimal((double)msecends / 60000.0).setScale(2, 4);
        }
        if ("H".equals(timeType)) {
            return new BigDecimal((double)msecends / 3600000.0).setScale(2, 4);
        }
        if ("D".equals(timeType)) {
            return new BigDecimal((double)msecends / ((double)this.oneDayWorkTimems * 1.0)).setScale(2, 4);
        }
        throw new BOSException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u5355\u4f4d");
    }

    private long calWorkTime(java.util.Date startDate, java.util.Date endDate) throws BOSException, ParseException {
        if (startDate.after(endDate)) {
            return 0L;
        }
        String startDateStr = sdfYMMDD.format(startDate);
        String endDateStr = sdfYMMDD.format(endDate);
        java.util.Date startTime = this.constructHHMMSSDate(startDate);
        java.util.Date endTime = this.constructHHMMSSDate(endDate);
        if (DateUtils.isSameDay((java.util.Date)startDate, (java.util.Date)endDate)) {
            long startTimes = this.calWorkTimeForOneDay(startTime, startDateStr);
            long endTimes = this.calWorkTimeForOneDay(endTime, endDateStr);
            return endTimes - startTimes;
        }
        long dayTimes = this.calWorkTimeForMorninAndAfternoon(this.addOneDate(startDate), this.subOneDate(endDate));
        long firstDayTimes = this.calFirstDayTimes(startTime, startDateStr);
        long lastDayTimes = this.calWorkTimeForOneDay(endTime, endDateStr);
        return dayTimes + firstDayTimes + lastDayTimes;
    }

    private long calFirstDayTimes(java.util.Date currentTime, String startDateStr) {
        if (!this.morningWorkDateList.contains(startDateStr)) {
            return 0L;
        }
        long calTime = this.calWorkTimeForOneDay(currentTime, startDateStr);
        if (!this.afternoonWorkDateList.contains(startDateStr)) {
            return this.morningWorkTimems - calTime;
        }
        return this.oneDayWorkTimems - this.calWorkTimeForOneDay(currentTime, startDateStr);
    }

    private long calWorkTimeForOneDay(java.util.Date currentTime, String startDateStr) {
        long longTime = 0L;
        if (this.morningWorkDateList.contains(startDateStr)) {
            if (currentTime.before(this.eTimeAm)) {
                longTime = currentTime.getTime() - this.bTimeAm.getTime();
                longTime = longTime > 0L ? longTime : 0L;
            } else if (currentTime.after(this.eTimeAm) && currentTime.before(this.bTimePm)) {
                longTime = this.morningWorkTimems;
            } else if (currentTime.after(this.bTimePm)) {
                longTime = this.afternoonWorkDateList.contains(startDateStr) ? ((longTime = this.morningWorkTimems + currentTime.getTime() - this.bTimePm.getTime()) > this.oneDayWorkTimems ? this.oneDayWorkTimems : longTime) : this.morningWorkTimems;
            }
        }
        return longTime;
    }

    private long calWorkTimeForMorninAndAfternoon(java.util.Date startDateAddOne, java.util.Date endDateSubOne) throws BOSException {
        int startMorningIndex = this.getIndexFromWorkDateList(startDateAddOne, 0, this.morningWorkDateList);
        int endMorningIndex = this.getIndexFromWorkDateList(endDateSubOne, 1, this.morningWorkDateList);
        long morningTime = (long)(endMorningIndex - startMorningIndex + 1) * this.morningWorkTimems;
        if (morningTime < 0L) {
            morningTime = 0L;
        }
        int startAfternoonIndex = this.getIndexFromWorkDateList(startDateAddOne, 0, this.afternoonWorkDateList);
        int endAfternoonIndex = this.getIndexFromWorkDateList(endDateSubOne, 1, this.afternoonWorkDateList);
        long afternoonTime = (long)(endAfternoonIndex - startAfternoonIndex + 1) * this.afternoonWorkTimems;
        if (afternoonTime < 0L) {
            afternoonTime = 0L;
        }
        return morningTime + afternoonTime;
    }

    private int getIndexFromWorkDateList(java.util.Date date, int type, List workDateList) throws BOSException {
        int index = -1;
        if (date.before(this.startWorkDate) || date.after(this.endWorkDate)) {
            throw new BOSException("\u4f20\u5165\u7684\u65e5\u671f" + sdfYMMDD.format(date) + "\u4e0d\u518d\u5de5\u4f5c\u65e5\u5386\u8303\u56f4\u5185");
        }
        index = workDateList.indexOf(sdfYMMDD.format(date));
        for (int count = 0; index == -1 && count < workDateList.size() && (index = workDateList.indexOf(sdfYMMDD.format(date = type == 0 ? this.addOneDate(date) : this.subOneDate(date)))) <= -1; ++count) {
        }
        return index;
    }
}

