/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bigobjectcache;

import com.kingdee.bos.bigobjectcache.CloseListener;
import com.kingdee.bos.bigobjectcache.ValueObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class BigObjectCacheMap {
    private ReentrantLock[] locks;
    private Map<Object, ValueObject>[] maps;
    private final int cc;
    private MyCloseListener myCloseListener = new MyCloseListener();

    public BigObjectCacheMap() {
        this(16);
    }

    public BigObjectCacheMap(int cc) {
        this.cc = cc;
        this.locks = new ReentrantLock[cc];
        this.maps = new HashMap[cc];
        for (int i = 0; i < cc; ++i) {
            this.locks[i] = new ReentrantLock();
            this.maps[i] = new HashMap<Object, ValueObject>();
        }
    }

    private int index(Object key) {
        return Math.abs(key.hashCode() % this.cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        int index = this.index(key);
        try {
            this.locks[index].lock();
            boolean bl = this.maps[index].containsKey(key);
            return bl;
        }
        finally {
            this.locks[index].unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Serializable value) {
        ValueObject vo = new ValueObject(key, value);
        vo.closeListener = this.myCloseListener;
        int index = this.index(key);
        try {
            this.locks[index].lock();
            this.maps[index].put(key, vo);
        }
        finally {
            this.locks[index].unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Serializable value, int timeout) {
        ValueObject vo = new ValueObject(key, value, timeout);
        vo.closeListener = this.myCloseListener;
        int index = this.index(key);
        try {
            this.locks[index].lock();
            this.maps[index].put(key, vo);
        }
        finally {
            this.locks[index].unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable remove(Object key) {
        int index = this.index(key);
        ValueObject vo = null;
        try {
            this.locks[index].lock();
            vo = this.maps[index].remove(key);
        }
        finally {
            this.locks[index].unlock();
        }
        if (vo != null) {
            return vo.removeObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable get(Object key) {
        int index = this.index(key);
        ValueObject vo = null;
        try {
            this.locks[index].lock();
            vo = this.maps[index].get(key);
        }
        finally {
            this.locks[index].unlock();
        }
        if (vo == null) {
            return null;
        }
        return vo.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.cc; ++i) {
            try {
                this.locks[i].lock();
                ValueObject[] vos = this.maps[i].values().toArray(new ValueObject[this.maps[i].size()]);
                this.maps[i].clear();
                for (int j = 0; j < vos.length; ++j) {
                    vos[j].removeObject();
                }
                continue;
            }
            finally {
                this.locks[i].unlock();
            }
        }
    }

    private class MyCloseListener
    implements CloseListener {
        private MyCloseListener() {
        }

        @Override
        public void close(Object key) {
            int index = BigObjectCacheMap.this.index(key);
            try {
                BigObjectCacheMap.this.locks[index].lock();
                BigObjectCacheMap.this.maps[index].remove(key);
            }
            finally {
                BigObjectCacheMap.this.locks[index].unlock();
            }
        }
    }
}

