/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bigobjectcache;

import com.kingdee.bos.bigobjectcache.FileCacheObject;
import com.kingdee.bos.bigobjectcache.ValueObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class FileCacheManager {
    private static Logger logger;
    private static String cacheDir;
    private static int max_size;
    private static int objecttimeout;
    private static Map<ValueObject, Serializable> inMemoryMap;
    private static Map<ValueObject, FileCacheObject> inDiskMap;

    FileCacheManager() {
    }

    private static void initStatic() {
        File dir;
        String path = System.getProperty("bigObjectStorePath");
        if (null != path && path.length() > 1) {
            try {
                String serverName;
                try {
                    serverName = new File("bigobjectcache").getParentFile().getParentFile().getParentFile().getName();
                }
                catch (Exception e) {
                    serverName = "";
                }
                cacheDir = path + File.separator + "bigobjectcache_" + serverName;
                dir = new File(cacheDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            }
            catch (Exception e) {
                logger.error((Object)("cacheDir:" + cacheDir));
                logger.error((Object)e);
                dir = new File("bigobjectcache");
                cacheDir = dir.getAbsolutePath();
            }
        } else {
            dir = new File("bigobjectcache");
            cacheDir = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            dir.mkdirs();
        } else {
            File[] files = dir.listFiles();
            FileCacheManager.delete(files);
        }
        String s = System.getProperty("bigobjectcache_memorymap_maxsize");
        if (s != null) {
            try {
                max_size = Integer.parseInt(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        inMemoryMap = new ConcurrentHashMap<ValueObject, Serializable>(max_size);
        inDiskMap = new ConcurrentHashMap<ValueObject, FileCacheObject>();
        s = System.getProperty("bigobjectcache_objecttimeout");
        if (s != null) {
            try {
                objecttimeout = Integer.parseInt(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        new Thread((Runnable)new TimeoutWorker(), "BigObjectCache.FileCacheManager.TimeoutWorker").start();
    }

    private static void delete(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isFile()) {
                FileCacheManager.delete(file.listFiles());
            }
            file.delete();
        }
    }

    private static String makeFile(ValueObject vo, Serializable object) {
        long l = vo.timestamp;
        String subdir = Long.toHexString(l / 100000L);
        String dir = cacheDir + File.separator + subdir;
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = null;
        long ll = l;
        while (true) {
            fileName = Long.toHexString(ll) + Long.toHexString(object.hashCode());
            fileName = dir + File.separator + fileName;
            if (!new File(fileName).exists()) {
                return fileName;
            }
            ll -= 37L;
        }
    }

    public static void put(ValueObject vo, Serializable object) {
        vo.timestamp = System.currentTimeMillis();
        if (inMemoryMap.size() < max_size) {
            inMemoryMap.put(vo, object);
            vo.inMemory = true;
        } else {
            String fileName = FileCacheManager.makeFile(vo, object);
            FileCacheObject cacheObject = new FileCacheObject(fileName, object);
            inDiskMap.put(vo, cacheObject);
            vo.inMemory = false;
        }
        if (vo.timeout <= 0) {
            vo.timeout = objecttimeout;
        }
    }

    public static Serializable get(ValueObject vo) {
        vo.timestamp = System.currentTimeMillis();
        if (vo.inMemory) {
            return inMemoryMap.get(vo);
        }
        FileCacheObject cacheObject = inDiskMap.get(vo);
        return cacheObject.getObject();
    }

    public static Serializable remove(ValueObject vo) {
        if (vo.inMemory) {
            return inMemoryMap.remove(vo);
        }
        FileCacheObject cacheObject = inDiskMap.remove(vo);
        Serializable object = cacheObject.getObject();
        cacheObject.remove();
        return object;
    }

    private static void doTimeoutMemory(ArrayList keyList) {
        if (inMemoryMap.isEmpty()) {
            return;
        }
        keyList.clear();
        keyList.addAll(inMemoryMap.keySet());
        for (ValueObject vo : keyList) {
            Serializable object;
            if (vo.timestamp + (long)vo.timeout < System.currentTimeMillis()) {
                inMemoryMap.remove(vo);
                vo.timeout();
                continue;
            }
            if (System.currentTimeMillis() - vo.timestamp <= (long)(vo.timeout / 2) || (object = inMemoryMap.get(vo)) == null) continue;
            String fileName = FileCacheManager.makeFile(vo, object);
            FileCacheObject cacheObject = new FileCacheObject(fileName, object);
            inDiskMap.put(vo, cacheObject);
            vo.inMemory = false;
            inMemoryMap.remove(vo);
        }
    }

    private static void doTimeoutDisk(ArrayList keyList) {
        if (inDiskMap.isEmpty()) {
            return;
        }
        keyList.clear();
        keyList.addAll(inDiskMap.keySet());
        for (ValueObject vo : keyList) {
            FileCacheObject cacheObject;
            if (vo.timestamp + (long)vo.timeout >= System.currentTimeMillis() || (cacheObject = inDiskMap.remove(vo)) == null) continue;
            cacheObject.remove();
            vo.timeout();
        }
    }

    static {
        FileCacheManager.initStatic();
        logger = Logger.getLogger(FileCacheManager.class);
        max_size = 5;
        objecttimeout = 1200000;
    }

    static class TimeoutWorker
    implements Runnable {
        TimeoutWorker() {
        }

        @Override
        public void run() {
            ArrayList keyList = new ArrayList();
            while (true) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    FileCacheManager.doTimeoutDisk(keyList);
                    FileCacheManager.doTimeoutMemory(keyList);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

