/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache;

import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.ServiceAttributes;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.util;

public class CacheEngine {
    public static final int DEFAULT_NAME_SEPERATOR = 46;

    public static boolean isServiceStarted() {
        return ServiceImpl.isServiceStarted();
    }

    public static ServiceAttributes getServiceAttributes() {
        return ServiceImpl.getServiceAttributes();
    }

    public static void startService(ServiceAttributes config) {
        ServiceImpl.startService(config);
    }

    public static void stopService() {
        ServiceImpl.stopService();
    }

    public static void addDistributeService(String serverUrl) {
        ServiceImpl.addDistributeService(serverUrl);
    }

    public static void removeDistributeService(String serverUrl) {
        ServiceImpl.removeDistributeService(serverUrl);
    }

    public static CacheRegion getRootRegion() {
        return ServiceImpl.getRootRegion();
    }

    public static CacheRegion getLocalRootRegion() {
        return ServiceImpl.getLocalRootRegion();
    }

    public static String getServiceName() {
        return ServiceImpl.getIdentity();
    }

    public static Object getRootRegionName() {
        return ServiceImpl.getRootRegion().getName();
    }

    public static CacheRegion getRegion(Object[] names) {
        return ServiceImpl.getRegion(names);
    }

    public static CacheRegion getRegion(String path) {
        return CacheEngine.getRegion(path, 46);
    }

    public static CacheRegion getRegion(String path, int seperator) {
        return CacheEngine.getRegion(util.splitString(path, seperator));
    }

    public static CacheObject getObject(Object[] names) {
        return ServiceImpl.getObject(names);
    }

    public static CacheObject getObject(String path) {
        return CacheEngine.getObject(util.splitString(path, 46));
    }

    public static CacheObject getObject(String path, int seperator) {
        return ServiceImpl.getObject(util.splitString(path, seperator));
    }

    public static void addMonitor(ObjectMonitor monitor) {
        ServiceImpl.addMonitor(monitor);
    }

    public static void remoteMonitor(ObjectMonitor monitor) {
        ServiceImpl.remoteMonitor(monitor);
    }
}

