/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class AttributesBase
implements Serializable {
    protected HashMap attrs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributesBase(AttributesBase source) {
        if (source != null) {
            AttributesBase attributesBase = source;
            synchronized (attributesBase) {
                this.attrs.putAll(source.attrs);
            }
        }
    }

    public synchronized Object get(int index) {
        return this.get(index, null);
    }

    public synchronized Object get(int index, Object defaultValue) {
        Integer key = index;
        if (this.attrs.containsKey(key)) {
            return this.attrs.get(key);
        }
        return defaultValue;
    }

    public synchronized void set(int index, Object value) {
        this.attrs.put(index, value);
    }

    public synchronized void remove(int index) {
        this.attrs.remove(index);
    }

    public synchronized boolean isSet(int index) {
        return this.attrs.containsKey(index);
    }

    public boolean getBoolean(int index) {
        return this.getBoolean(index, false);
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        Boolean val = (Boolean)this.get(index);
        if (val != null) {
            return val;
        }
        return defaultValue;
    }

    public void setBoolean(int index, boolean value) {
        this.set(index, value);
    }

    public int getInt(int index) {
        return this.getInt(index, 0);
    }

    public int getInt(int index, int defaultValue) {
        Number val = (Number)this.get(index);
        if (val != null) {
            return val.intValue();
        }
        return defaultValue;
    }

    public void setInt(int index, int value) {
        this.set(index, value);
    }

    public long getLong(int index) {
        return this.getLong(index, 0L);
    }

    public long getLong(int index, long defaultValue) {
        Number val = (Number)this.get(index);
        if (val != null) {
            return val.longValue();
        }
        return defaultValue;
    }

    public void setLong(int index, long value) {
        this.set(index, value);
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        return (String)this.get(index, defaultValue);
    }

    public void setString(int index, String value) {
        this.set(index, value);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object[] keys = this.attrs.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = this.attrs.get(key);
            if (!AttributesBase.isSerialable(value)) continue;
            out.writeObject(key);
            out.writeObject(value);
        }
        out.writeObject(null);
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.attrs = new HashMap();
        while (true) {
            Object key = in.readObject();
            Object value = in.readObject();
            if (key == null) break;
            this.attrs.put(key, value);
        }
    }

    private static boolean isSerialable(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof Serializable;
    }
}

