/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.LockHandle;
import com.kingdee.bos.cache.impl.util;
import java.util.Vector;

class MultiAccess
implements LockHandle {
    private long timeout;
    private Vector handles = new Vector();
    private Object releaseTrace;
    private long startTime = System.currentTimeMillis();
    private Vector objectHandler = new Vector();

    MultiAccess(long _timeout) {
        this.timeout = _timeout;
        this.releaseTrace = util.traceRelease("Lock Handle ");
    }

    synchronized long getTimeout() {
        long t = this.timeout - (System.currentTimeMillis() - this.startTime);
        if (t < 0L) {
            t = 0L;
        }
        return t;
    }

    synchronized void addObjectHandle(Object x) {
        this.objectHandler.addElement(x);
    }

    synchronized void addLockHandle(LockHandle h) {
        this.handles.addElement(h);
    }

    @Override
    public synchronized void unlock() {
        for (int i = this.handles.size() - 1; i >= 0; --i) {
            try {
                ((LockHandle)this.handles.elementAt(i)).unlock();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.handles.removeAllElements();
    }

    protected void finalize() {
        if (this.handles.size() > 0) {
            this.unlock();
            util.logError(this.releaseTrace.toString());
        }
    }
}

