/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cache.impl;

import com.kingdee.bos.cache.CacheReference;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.impl.ObjectBase;
import com.kingdee.bos.cache.impl.ServiceImpl;
import com.kingdee.bos.cache.impl.util;

class ServiceMonitor
extends Thread {
    private boolean toStop = false;

    ServiceMonitor() {
        super.setName("Cache Service Monitor");
        super.setDaemon(true);
    }

    void shutdown() {
        this.toStop = true;
        try {
            super.interrupt();
            super.join();
        }
        catch (Throwable e) {
            util.logError(e);
        }
    }

    @Override
    public void run() {
        while (!this.toStop) {
            long loopTime = 30000L;
            if (ServiceImpl.config != null) {
                loopTime = ServiceImpl.config.getMonitorLoopTime();
            }
            if (loopTime < 10000L) {
                loopTime = 10000L;
            }
            try {
                ServiceMonitor.sleep(loopTime);
                ObjectBase[] objs = ServiceImpl.getObjects();
                ObjectMonitor[] monitors = ServiceImpl.getMonitors();
                for (int i = 0; i < objs.length; ++i) {
                    for (int j = 0; j < monitors.length; ++j) {
                        CacheReference ref = objs[i].getReference();
                        try {
                            monitors[j].check(ref);
                        }
                        catch (Throwable e) {
                            util.logError(e);
                        }
                        ref.release();
                    }
                    try {
                        objs[i].monitorCheck();
                        continue;
                    }
                    catch (Throwable e) {
                        util.logError(e);
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) continue;
                util.logError(e);
            }
        }
    }
}

