/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache;

import com.kingdee.bos.jcache.CacheException;
import java.io.Serializable;

public class Path
implements Serializable {
    public static final char SEPERATOR = '/';
    public final Object[] names;
    public final boolean isRegion;
    public final Path parent;
    private final int hashCode;

    public Path(Object name, boolean isRegion) {
        this(null, name, isRegion);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof Path) {
            Path p = (Path)x;
            if (p.isRegion != this.isRegion) {
                return false;
            }
            if (p.names.length != this.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (Path.equals(this.names[i], p.names[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public Path(Object[] names, boolean isRegion) {
        this((Path)null, names, isRegion);
    }

    private Path(Path parent, Object[] names, boolean isRegion) {
        if (names == null || names.length == 0) {
            throw new CacheException(102, "empty name.");
        }
        this.names = names;
        this.isRegion = isRegion;
        this.parent = Path._parent(parent, names);
        int h = isRegion ? 0 : 1;
        for (int i = 0; i < names.length; ++i) {
            h <<= 5 + h + names[i].hashCode();
        }
        this.hashCode = h;
    }

    private static Path _parent(Path parent, Object[] names) {
        if (parent != null) {
            return parent;
        }
        if (names.length == 1) {
            return null;
        }
        Object[] ns = new Object[names.length - 1];
        System.arraycopy(names, 0, ns, 0, names.length - 1);
        return new Path(ns, true);
    }

    public Path(Path parent, Object name, boolean isRegion) {
        this(parent, Path.getNames(parent, name), isRegion);
    }

    private static Object[] getNames(Path parent, Object name) {
        if (parent != null && !parent.isRegion) {
            throw new CacheException(101, "'" + parent.toString() + "' is not a region.");
        }
        Object[] names = null;
        if (parent != null) {
            names = parent.getNames();
        }
        if (names == null || names.length == 0) {
            return new Object[]{name};
        }
        Object[] ns = new Object[names.length + 1];
        System.arraycopy(names, 0, ns, 0, names.length);
        ns[names.length] = name;
        return ns;
    }

    public Object getName() {
        return this.names[this.names.length - 1];
    }

    public Object[] getNames() {
        return this.names;
    }

    public boolean isRegion() {
        return this.isRegion;
    }

    public Path getParent() {
        return this.parent;
    }

    public boolean isChild(Path root) {
        if (!root.isRegion) {
            return false;
        }
        Object[] rootNames = root.getNames();
        Object[] names = this.getNames();
        if (names.length >= rootNames.length) {
            return false;
        }
        for (int i = 0; i < rootNames.length; ++i) {
            if (rootNames[i].equals(names[i])) continue;
            return false;
        }
        return true;
    }

    public Path getRelativePath(Path root) {
        if (root == null) {
            return this;
        }
        if (this.equals(root)) {
            return null;
        }
        if (!this.isChild(root)) {
            throw new CacheException(104, this.toString() + " is not a child of " + root.toString());
        }
        Object[] ns = new Object[this.names.length - root.names.length];
        System.arraycopy(this.names, root.names.length, ns, 0, ns.length);
        return new Path(ns, this.isRegion);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(this.names[i]);
        }
        if (this.isRegion) {
            sb.append('/');
        }
        return sb.toString();
    }

    public static Path parse(String fullName) {
        return Path.parse(fullName, '/');
    }

    public static Path parse(String fullName, char seperator) {
        int i = fullName.lastIndexOf(seperator);
        if (i < 0) {
            return new Path(fullName, false);
        }
        if (i == fullName.length() - 1) {
            i = fullName.substring(0, fullName.length() - 1).lastIndexOf(seperator);
            if (i < 0) {
                return new Path(fullName.substring(0, fullName.length() - 1), true);
            }
            return new Path(Path.parse(fullName.substring(0, i + 1), seperator), fullName.substring(i + 1, fullName.length() - 1), true);
        }
        return new Path(Path.parse(fullName.substring(0, i + 1), seperator), fullName.substring(i + 1), false);
    }
}

