/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.Attributes;
import com.kingdee.bos.jcache.CacheException;
import com.kingdee.bos.jcache.DistributeNotifier;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.Path;
import com.kingdee.bos.jcache.Region;
import com.kingdee.bos.jcache.impl.CacheRefImpl;
import com.kingdee.bos.jcache.impl.DelayTasks;
import com.kingdee.bos.jcache.impl.DistributeMonitorImpl;
import com.kingdee.bos.jcache.impl.EventManager;
import com.kingdee.bos.jcache.impl.MonitorThread;
import com.kingdee.bos.jcache.impl.RegionImpl;
import com.kingdee.bos.jcache.impl.SmartWeakMap;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CacheEngineImpl {
    private static final Logger logger = Logger.getLogger(CacheEngineImpl.class);
    static DistributeMonitorImpl distributeMonitor = null;
    public static final EventManager eventManager = new EventManager();
    private static final SmartWeakMap regions = new SmartWeakMap();
    private static final DelayTasks delayTasks = new DelayTasks("Cache-Delay-Tasks");

    public static synchronized void initDistributeNotifier(DistributeNotifier notifier) throws Exception {
        if (distributeMonitor != null) {
            throw new CacheException(105, "DistributeNotifier alerdy initialized.");
        }
        distributeMonitor = new DistributeMonitorImpl(notifier);
    }

    public static void postDistributeEvent(Event event) throws Exception {
        if (distributeMonitor == null) {
            throw new IOException("Distribute notifier not start.");
        }
        distributeMonitor.postEvent(event);
    }

    public static synchronized void distributeNotifyChange(Path path) {
        try {
            if (distributeMonitor != null) {
                distributeMonitor.notifyChange(path);
            } else {
                logger.warn((Object)"Distribute notifier not start.");
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    public static void fireEvent(Event event) {
        eventManager.processEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] listRegionNames() {
        SmartWeakMap smartWeakMap = regions;
        synchronized (smartWeakMap) {
            return regions.listKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionImpl[] listRegions() {
        SmartWeakMap smartWeakMap = regions;
        synchronized (smartWeakMap) {
            return (RegionImpl[])regions.listValues(RegionImpl.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteRegion(Object name) {
        RegionImpl region;
        SmartWeakMap smartWeakMap = regions;
        synchronized (smartWeakMap) {
            region = (RegionImpl)regions.remove(name);
        }
        if (region != null) {
            region.destroy();
        }
        return region != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionImpl createRegion(Object name, Attributes initAttrs) {
        SmartWeakMap smartWeakMap = regions;
        synchronized (smartWeakMap) {
            RegionImpl region = (RegionImpl)regions.get(name);
            if (region != null) {
                throw new CacheException(113, "region '" + name + "' already exists.");
            }
            region = RegionImpl.create(name, null, initAttrs);
            regions.put(name, region, region.isWeak());
            CacheEngineImpl.fireEvent(new Event(101, region, null));
            return region;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionImpl getRegion(Object name, boolean autoCreate, Attributes initAttrs) {
        SmartWeakMap smartWeakMap = regions;
        synchronized (smartWeakMap) {
            RegionImpl region = (RegionImpl)regions.get(name);
            if (region == null && autoCreate) {
                region = CacheEngineImpl.createRegion(name, initAttrs);
            }
            return region;
        }
    }

    public static RegionImpl getRegion(Object name) {
        return CacheEngineImpl.getRegion(name, false, null);
    }

    public static CacheRefImpl getRef(Path path) {
        if (path == null) {
            return null;
        }
        if (path.getParent() == null) {
            return CacheEngineImpl.getRegion(path.getName());
        }
        Region region = (Region)((Object)CacheEngineImpl.getRef(path.getParent()));
        if (region == null) {
            return null;
        }
        CacheRefImpl ref = (CacheRefImpl)region.getRef(path.getName());
        if (ref != null && ref.isRegion() != path.isRegion()) {
            ref = null;
        }
        return ref;
    }

    public static void invokeLater(Runnable task) {
        delayTasks.addTask(task);
    }

    static {
        new MonitorThread().start();
    }
}

