/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.jcache.impl;

import com.kingdee.bos.jcache.CacheEngine;
import com.kingdee.bos.jcache.CacheRef;
import com.kingdee.bos.jcache.DistributeMonitor;
import com.kingdee.bos.jcache.DistributeNotifier;
import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.Path;
import com.kingdee.bos.jcache.impl.CacheEngineImpl;
import com.kingdee.bos.jcache.impl.DelayTasks;
import org.apache.log4j.Logger;

class DistributeMonitorImpl
implements DistributeMonitor {
    private static final Logger logger = Logger.getLogger(DistributeMonitorImpl.class);
    private final DistributeNotifier notifier;
    private final DelayTasks notifyThread = new DelayTasks("Distribute-Notifier");

    DistributeMonitorImpl(DistributeNotifier notifier) throws Exception {
        this.notifier = notifier;
        notifier.open(this);
    }

    private static String servers(Object[] servers) {
        StringBuffer sb = new StringBuffer();
        sb.append("Server(");
        for (int i = 0; i < servers.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(servers[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public void shutdown() {
        try {
            this.notifier.close();
        }
        catch (Throwable e) {
            logger.info((Object)e, e);
        }
    }

    @Override
    public void onServerView(String[] servers) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)DistributeMonitorImpl.servers(servers));
        }
    }

    @Override
    public void onEvent(Object _event) {
        if (_event == null || !(_event instanceof Event)) {
            return;
        }
        try {
            Event event = (Event)_event;
            if (event.id == 301) {
                CacheRef ref;
                Path path = (Path)event.parameter;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("distribute_notify_change " + path));
                }
                if ((ref = CacheEngine.getRef(path)) != null && ref.attributes().getBoolean("distributed", false)) {
                    ref.fireEvent(new Event(302, ref, ref.path()));
                    ref.discard(false);
                }
            } else {
                CacheEngineImpl.fireEvent(event);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    void notifyChange(Path path) {
        this.postEvent(new Event(301, null, path));
    }

    void postEvent(final Event event) {
        this.notifyThread.addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributeMonitorImpl.this.notifier.notifiyEvent(event);
                    CacheEngineImpl.fireEvent(event);
                }
                catch (Throwable e) {
                    logger.error((Object)"event notify failed.", e);
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        this.notifier.close();
        super.finalize();
    }
}

