/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.mdCache.memcached.client;

import com.kingdee.bos.mdCache.memcached.MemcachedException;
import com.kingdee.bos.mdCache.memcached.client.ByteBufArrayInputStream;
import com.kingdee.bos.mdCache.memcached.client.ContextObjectInputStream;
import com.kingdee.bos.mdCache.memcached.client.ErrorHandler;
import com.kingdee.bos.mdCache.memcached.client.LineInputStream;
import com.kingdee.bos.mdCache.memcached.client.NativeHandler;
import com.kingdee.bos.mdCache.memcached.client.NestedIOException;
import com.kingdee.bos.mdCache.memcached.client.SockIOPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class MemCachedClient {
    private static Logger log = Logger.getLogger((String)MemCachedClient.class.getName());
    private static final String VALUE = "VALUE";
    private static final String STATS = "STAT";
    private static final String ITEM = "ITEM";
    private static final String DELETED = "DELETED";
    private static final String NOTFOUND = "NOT_FOUND";
    private static final String STORED = "STORED";
    private static final String NOTSTORED = "NOT_STORED";
    private static final String OK = "OK";
    private static final String END = "END";
    private static final String ERROR = "ERROR";
    private static final String CLIENT_ERROR = "CLIENT_ERROR";
    private static final String SERVER_ERROR = "SERVER_ERROR";
    private static final String NULL_STORED = "NULL_STORED";
    private static final byte[] B_END = "END\r\n".getBytes();
    private static final byte[] B_NOTFOUND = "NOT_FOUND\r\n".getBytes();
    private static final byte[] B_DELETED = "DELETED\r\r".getBytes();
    private static final byte[] B_STORED = "STORED\r\r".getBytes();
    private static final byte[] B_RETURN = "\r\n".getBytes();
    private static final int COMPRESS_THRESH = 30720;
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 8192;
    public static final int MARKER_INTEGER = 4;
    public static final int MARKER_LONG = 16384;
    public static final int MARKER_CHARACTER = 16;
    public static final int MARKER_STRING = 32;
    public static final int MARKER_STRINGBUFFER = 64;
    public static final int MARKER_FLOAT = 128;
    public static final int MARKER_SHORT = 256;
    public static final int MARKER_DOUBLE = 512;
    public static final int MARKER_DATE = 1024;
    public static final int MARKER_STRINGBUILDER = 2048;
    public static final int MARKER_BYTEARR = 4096;
    public static final int F_COMPRESSED = 2;
    public static final int F_SERIALIZED = 8;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding;
    private SockIOPool pool;
    private String poolName;
    private ClassLoader classLoader;
    private ErrorHandler errorHandler;
    private Map localCache;

    public MemCachedClient() {
        this.init();
    }

    public MemCachedClient(String poolName) {
        this.poolName = poolName;
        this.init();
    }

    public MemCachedClient(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init();
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler) {
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        this.init();
    }

    public MemCachedClient(ClassLoader classLoader, ErrorHandler errorHandler, String poolName) {
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        this.poolName = poolName;
        this.init();
    }

    private void init() {
        this.sanitizeKeys = true;
        this.primitiveAsString = false;
        this.compressEnable = true;
        this.compressThreshold = 30720L;
        this.defaultEncoding = "UTF-8";
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.localCache = new ConcurrentHashMap();
        this.pool = SockIOPool.getInstance(this.poolName);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setCompressEnable(boolean compressEnable) {
        this.compressEnable = compressEnable;
    }

    public void setCompressThreshold(long compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    public boolean keyExists(String key) {
        return this.get(key, null, true) != null;
    }

    public boolean delete(String key) {
        return this.delete(key, null, null);
    }

    public boolean delete(String key, Date expiry) {
        return this.delete(key, null, expiry);
    }

    public boolean delete(String key, Integer hashCode, Date expiry) {
        if (key == null) {
            log.error((Object)"null value for key passed to delete()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return false;
        }
        SockIOPool.SockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        StringBuffer command = new StringBuffer("delete ").append(key);
        if (expiry != null) {
            command.append(" ").append(expiry.getTime() / 1000L);
        }
        command.append("\r\n");
        try {
            sock.write(command.toString().getBytes());
            sock.flush();
            String line = sock.readLine();
            if (DELETED.equals(line)) {
                sock.close();
                sock = null;
                return true;
            }
            if (NOTFOUND.equals(line)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ deletion of key: ").append(key).append(" from cache failed as the key was not found").toString());
                }
            } else {
                log.error((Object)new StringBuffer().append("++++ error deleting key: ").append(key).toString());
                log.error((Object)new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, e, key);
            }
            log.error((Object)"++++ exception thrown while writing bytes to server on delete");
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error((Object)new StringBuffer().append("++++ failed to close socket : ").append(sock.toString()).toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
            sock = null;
        }
        return false;
    }

    public boolean set(String key, Object value) {
        return this.set("set", key, value, null, null, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Integer hashCode) {
        return this.set("set", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Date expiry) {
        return this.set("set", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("set", key, value, expiry, hashCode, this.primitiveAsString);
    }

    public boolean add(String key, Object value) {
        return this.set("add", key, value, null, null, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Integer hashCode) {
        return this.set("add", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Date expiry) {
        return this.set("add", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean add(String key, Object value, long expiry) {
        return this.set("add", key, value, new Date(expiry), null, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("add", key, value, expiry, hashCode, this.primitiveAsString);
    }

    public boolean replace(String key, Object value) {
        return this.set("replace", key, value, null, null, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Integer hashCode) {
        return this.set("replace", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Date expiry) {
        return this.set("replace", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("replace", key, value, expiry, hashCode, this.primitiveAsString);
    }

    private boolean set(String cmdname, String key, Object value, Date expiry, Integer hashCode, boolean asString) {
        ByteArrayOutputStream bos;
        byte[] val;
        if (cmdname == null || cmdname.trim().equals("") || key == null) {
            log.error((Object)"key is null or cmd is null/empty for set()");
            return false;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return false;
        }
        if (value == null) {
            return false;
        }
        SockIOPool.SockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return false;
        }
        if (expiry == null) {
            expiry = new Date(0L);
        }
        int flags = 0;
        if (NativeHandler.isHandled(value)) {
            if (asString) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)new StringBuffer().append("++++ storing data as a string for key: ").append(key).append(" for class: ").append(value.getClass().getName()).toString());
                    }
                    val = value.toString().getBytes(this.defaultEncoding);
                }
                catch (UnsupportedEncodingException ue) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, ue, key);
                    }
                    log.error((Object)new StringBuffer().append("invalid encoding type used: ").append(this.defaultEncoding).toString(), (Throwable)ue);
                    sock.close();
                    sock = null;
                    return false;
                }
            } else {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Storing with native handler...");
                    }
                    flags |= NativeHandler.getMarkerFlag(value);
                    val = NativeHandler.encode(value);
                }
                catch (Exception e) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnSet(this, e, key);
                    }
                    log.error((Object)"Failed to native handle obj", (Throwable)e);
                    sock.close();
                    sock = null;
                    return false;
                }
            }
        } else {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ serializing for key: ").append(key).append(" for class: ").append(value.getClass().getName()).toString());
                }
                bos = new ByteArrayOutputStream();
                new ObjectOutputStream(bos).writeObject(value);
                val = bos.toByteArray();
                flags |= 8;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)"failed to serialize obj", (Throwable)e);
                log.error((Object)value.toString());
                sock.close();
                sock = null;
                return false;
            }
        }
        if (this.compressEnable && (long)val.length > this.compressThreshold) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"++++ trying to compress data");
                    log.info((Object)new StringBuffer().append("++++ size prior to compression: ").append(val.length).toString());
                }
                bos = new ByteArrayOutputStream(val.length);
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                gos.write(val, 0, val.length);
                gos.finish();
                val = bos.toByteArray();
                flags |= 2;
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ compression succeeded, size after: ").append(val.length).toString());
                }
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, e, key);
                }
                log.error((Object)new StringBuffer().append("IOException while compressing stream: ").append(e.getMessage()).toString());
                log.error((Object)"storing data uncompressed");
            }
        }
        try {
            String cmd = new StringBuffer().append(cmdname).append(" ").append(key).append(" ").append(flags).append(" ").append(expiry.getTime() / 1000L).append(" ").append(val.length).append("\r\n").toString();
            sock.write(cmd.getBytes());
            sock.write(val);
            sock.write(B_RETURN);
            sock.flush();
            String line = sock.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)new StringBuffer().append("++++ memcache cmd (result code): ").append(cmd).append(" (").append(line).append(")").toString());
            }
            if (STORED.equals(line)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ data successfully stored for key: ").append(key).toString());
                }
                sock.close();
                sock = null;
                return true;
            }
            if (NOTSTORED.equals(line)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ data not stored in cache for key: ").append(key).toString());
                }
            } else {
                log.error((Object)new StringBuffer().append("++++ error storing data in cache for key: ").append(key).append(" -- length: ").append(val.length).toString());
                log.error((Object)new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, e, key);
            }
            log.error((Object)"++++ exception thrown while writing bytes to server on set");
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error((Object)new StringBuffer().append("++++ failed to close socket : ").append(sock.toString()).toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
            sock = null;
        }
        return false;
    }

    public boolean storeCounter(String key, long counter) {
        return this.set("set", key, counter, null, null, true);
    }

    public boolean storeCounter(String key, Long counter) {
        return this.set("set", key, counter, null, null, true);
    }

    public boolean storeCounter(String key, Long counter, Integer hashCode) {
        return this.set("set", key, counter, null, hashCode, true);
    }

    public long getCounter(String key) {
        return this.getCounter(key, null);
    }

    public long getCounter(String key, Integer hashCode) {
        if (key == null) {
            log.error((Object)"null key for getCounter()");
            return -1L;
        }
        long counter = -1L;
        try {
            String value = (String)this.get(key, hashCode, true);
            if (value != null && !value.equals("")) {
                counter = Long.parseLong(value.trim());
            }
        }
        catch (Exception ex) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)ex, key);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)new StringBuffer().append("Failed to parse Long value for key: ").append(key).toString());
            }
            throw new MemcachedException(ex);
        }
        return counter;
    }

    public long addOrIncr(String key) {
        return this.addOrIncr(key, 0L, null);
    }

    public long addOrIncr(String key, long inc) {
        return this.addOrIncr(key, inc, null);
    }

    public long addOrIncr(String key, long inc, Integer hashCode) {
        boolean isExist = false;
        if (this.localCache.get(key) != null) {
            try {
                if (System.currentTimeMillis() - Long.valueOf(this.localCache.get(key) + "") < 5000L) {
                    isExist = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.localCache.put(key, System.currentTimeMillis());
        if (isExist) {
            long result = this.incrdecr("incr", key, inc, hashCode);
            if (result != -1L) {
                return result;
            }
            this.set("add", key, inc, null, hashCode, true);
            return inc;
        }
        boolean ret = this.set("add", key, inc, null, hashCode, true);
        if (ret) {
            return inc;
        }
        return this.incrdecr("incr", key, inc, hashCode);
    }

    public long addOrDecr(String key) {
        return this.addOrDecr(key, 0L, null);
    }

    public long addOrDecr(String key, long inc) {
        return this.addOrDecr(key, inc, null);
    }

    public long addOrDecr(String key, long inc, Integer hashCode) {
        boolean isExist = false;
        if (this.localCache.get(key) != null) {
            try {
                if (System.currentTimeMillis() - Long.valueOf(this.localCache.get(key) + "") < 5000L) {
                    isExist = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.localCache.put(key, System.currentTimeMillis());
        if (isExist) {
            long result = this.incrdecr("decr", key, inc, hashCode);
            if (result != -1L) {
                return result;
            }
            this.set("add", key, inc, null, hashCode, true);
            return inc;
        }
        boolean ret = this.set("add", key, inc, null, hashCode, true);
        if (ret) {
            return inc;
        }
        return this.incrdecr("decr", key, inc, hashCode);
    }

    public long incr(String key) {
        return this.incrdecr("incr", key, 1L, null);
    }

    public long incr(String key, long inc) {
        return this.incrdecr("incr", key, inc, null);
    }

    public long incr(String key, long inc, Integer hashCode) {
        return this.incrdecr("incr", key, inc, hashCode);
    }

    public long decr(String key) {
        return this.incrdecr("decr", key, 1L, null);
    }

    public long decr(String key, long inc) {
        return this.incrdecr("decr", key, inc, null);
    }

    public long decr(String key, long inc, Integer hashCode) {
        return this.incrdecr("decr", key, inc, hashCode);
    }

    private long incrdecr(String cmdname, String key, long inc, Integer hashCode) {
        if (key == null) {
            log.error((Object)"null key for incrdecr()");
            return -1L;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
            }
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return -1L;
        }
        SockIOPool.SockIO sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), key);
            }
            return -1L;
        }
        try {
            String cmd = new StringBuffer().append(cmdname).append(" ").append(key).append(" ").append(inc).append("\r\n").toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("++++ memcache incr/decr command: " + cmd));
            }
            sock.write(cmd.getBytes());
            sock.flush();
            String line = sock.readLine();
            if (line.matches("\\d+")) {
                sock.close();
                try {
                    return Long.parseLong(line);
                }
                catch (Exception ex) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnGet(this, (Throwable)ex, key);
                    }
                    log.error((Object)new StringBuffer().append("Failed to parse Long value for key: ").append(key).toString());
                }
            } else if (NOTFOUND.equals(line)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)new StringBuffer().append("++++ key not found to incr/decr for key: ").append(key).toString());
                }
            } else {
                log.error((Object)new StringBuffer().append("++++ error incr/decr key: ").append(key).toString());
                log.error((Object)new StringBuffer().append("++++ server response: ").append(line).toString());
            }
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
            }
            log.error((Object)"++++ exception thrown while writing bytes to server on incr/decr");
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error((Object)new StringBuffer().append("++++ failed to close socket : ").append(sock.toString()).toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
            sock = null;
        }
        return -1L;
    }

    public Object get(String key) {
        return this.get(key, null, false);
    }

    public Object get(String key, Integer hashCode) {
        return this.get(key, hashCode, false);
    }

    /*
     * Unable to fully structure code
     */
    public Object get(String key, Integer hashCode, boolean asString) {
        if (key == null) {
            MemCachedClient.log.error((Object)"key is null for get()");
            return null;
        }
        try {
            key = this.sanitizeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
            }
            MemCachedClient.log.error((Object)"failed to sanitize your key!", (Throwable)e);
            throw new MemcachedException(e);
        }
        sock = this.pool.getSock(key, hashCode);
        if (sock == null) {
            return null;
        }
        o = null;
        try {
            cmd = new StringBuffer("get ").append(key).append("\r\n").toString();
            if (MemCachedClient.log.isDebugEnabled()) {
                MemCachedClient.log.debug((Object)("++++ memcache get command: " + cmd));
            }
            sock.write(cmd.getBytes());
            sock.flush();
            while (true) lbl-1000:
            // 6 sources

            {
                if ((line = sock.readLine()) != null && line.startsWith("\r\n")) {
                    line = line.substring(2);
                }
                if (MemCachedClient.log.isDebugEnabled()) {
                    MemCachedClient.log.debug((Object)new StringBuffer().append("++++ line: ").append(line).toString());
                }
                if (line.startsWith("VALUE")) {
                    res = line.substring(0, line.lastIndexOf(" "));
                    flag = Integer.parseInt(res.substring(res.lastIndexOf(" ") + 1));
                    length = Integer.parseInt(line.substring(line.lastIndexOf(" ") + 1));
                    if (MemCachedClient.log.isDebugEnabled()) {
                        MemCachedClient.log.debug((Object)new StringBuffer().append("++++ key: ").append(key).toString());
                        MemCachedClient.log.debug((Object)new StringBuffer().append("++++ flags: ").append(flag).toString());
                        MemCachedClient.log.debug((Object)new StringBuffer().append("++++ length: ").append(length));
                    }
                    buf = sock.readBytes(length);
                    if ((flag & 2) == 2) {
                        try {
                            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                            bos = new ByteArrayOutputStream(buf.length);
                            tmp = new byte[2048];
                            while ((count = gzi.read(tmp)) != -1) {
                                bos.write(tmp, 0, count);
                            }
                            buf = bos.toByteArray();
                            gzi.close();
                        }
                        catch (IOException e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                            }
                            MemCachedClient.log.error((Object)new StringBuffer().append("++++ IOException thrown while trying to uncompress input stream for key: ").append(key).toString());
                            MemCachedClient.log.error((Object)e.getMessage(), (Throwable)e);
                            throw new NestedIOException("++++ IOException thrown while trying to uncompress input stream for key: " + key, e);
                        }
                    }
                    if ((flag & 8) != 8) {
                        if (this.primitiveAsString || asString) {
                            if (MemCachedClient.log.isInfoEnabled()) {
                                MemCachedClient.log.info((Object)"++++ retrieving object and stuffing into a string.");
                            }
                            o = new String(buf, this.defaultEncoding);
                            continue;
                        }
                        try {
                            o = NativeHandler.decode(buf, flag);
                        }
                        catch (Exception e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                            }
                            MemCachedClient.log.error((Object)new StringBuffer().append("++++ Exception thrown while trying to deserialize for key: ").append(key).toString(), (Throwable)e);
                            throw new NestedIOException(e);
                        }
                    }
                    ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                    try {
                        o = ois.readObject();
                        if (!MemCachedClient.log.isInfoEnabled()) ** GOTO lbl-1000
                        MemCachedClient.log.info((Object)new StringBuffer().append("++++ deserializing ").append(o.getClass()).toString());
                    }
                    catch (ClassNotFoundException e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                        }
                        MemCachedClient.log.error((Object)new StringBuffer().append("++++ ClassNotFoundException thrown while trying to deserialize for key: ").append(key).toString(), (Throwable)e);
                        throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                    }
                }
                if ("END".equals(line)) break;
            }
            if (MemCachedClient.log.isDebugEnabled()) {
                MemCachedClient.log.debug((Object)"++++ finished reading from cache server");
            }
            sock.close();
            sock = null;
            line = o;
            return line;
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
            }
            MemCachedClient.log.error((Object)new StringBuffer().append("++++ exception thrown while trying to get object from cache for key: ").append(key).toString());
            MemCachedClient.log.error((Object)e.getMessage(), (Throwable)e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                MemCachedClient.log.error((Object)new StringBuffer().append("++++ failed to close socket : ").append(sock.toString()).toString());
            }
            sock = null;
            throw new MemcachedException(e);
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    public Object[] getMultiArray(String[] keys) {
        return this.getMultiArray(keys, null, false);
    }

    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        return this.getMultiArray(keys, hashCodes, false);
    }

    public Object[] getMultiArray(String[] keys, Integer[] hashCodes, boolean asString) {
        Map data = this.getMulti(keys, hashCodes, asString);
        if (data == null) {
            return null;
        }
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    public Map getMulti(String[] keys) {
        return this.getMulti(keys, null, false);
    }

    public Map getMulti(String[] keys, Integer[] hashCodes) {
        return this.getMulti(keys, hashCodes, false);
    }

    public Map getMulti(String[] keys, Integer[] hashCodes, boolean asString) {
        if (keys == null || keys.length == 0) {
            log.error((Object)"missing keys for getMulti()");
            return null;
        }
        HashMap<String, StringBuffer> cmdMap = new HashMap<String, StringBuffer>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key == null) {
                log.error((Object)"null key, so skipping");
                continue;
            }
            Integer hash = null;
            if (hashCodes != null && hashCodes.length > i) {
                hash = hashCodes[i];
            }
            String cleanKey = key;
            try {
                cleanKey = this.sanitizeKey(key);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                continue;
            }
            SockIOPool.SockIO sock = this.pool.getSock(cleanKey, hash);
            if (sock == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet(this, (Throwable)new IOException("no socket to server available"), key);
                continue;
            }
            if (!cmdMap.containsKey(sock.getHost())) {
                cmdMap.put(sock.getHost(), new StringBuffer("get"));
            }
            new StringBuffer(cmdMap.get(sock.getHost()).toString()).append(" " + cleanKey);
            sock.close();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)new StringBuffer().append("multi get socket count : ").append(cmdMap.size()).toString());
        }
        HashMap ret = new HashMap(keys.length);
        new NIOLoader(this).doMulti(asString, cmdMap, keys, ret);
        for (int i = 0; i < keys.length; ++i) {
            String cleanKey = keys[i];
            try {
                cleanKey = this.sanitizeKey(keys[i]);
            }
            catch (UnsupportedEncodingException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet(this, (Throwable)e, keys[i]);
                }
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                continue;
            }
            if (!keys[i].equals(cleanKey) && ret.containsKey(cleanKey)) {
                ret.put(keys[i], ret.get(cleanKey));
                ret.remove(cleanKey);
            }
            if (ret.containsKey(keys[i])) continue;
            ret.put(keys[i], null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("++++ memcache: got back " + ret.size() + " results"));
        }
        return ret;
    }

    private void loadMulti(LineInputStream input, Map hm, boolean asString) throws IOException {
        block21: {
            while (true) {
                String line = input.readLine();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("++++ line: " + line));
                }
                if (line.startsWith(VALUE)) {
                    Object o;
                    String[] info = line.split(" ");
                    String key = info[1];
                    int flag = Integer.parseInt(info[2]);
                    int length = Integer.parseInt(info[3]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("++++ key: " + key));
                        log.debug((Object)("++++ flags: " + flag));
                        log.debug((Object)("++++ length: " + length));
                    }
                    byte[] buf = new byte[length];
                    input.read(buf);
                    input.clearEOL();
                    if ((flag & 2) == 2) {
                        try {
                            int count;
                            GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                            ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                            byte[] tmp = new byte[2048];
                            while ((count = gzi.read(tmp)) != -1) {
                                bos.write(tmp, 0, count);
                            }
                            buf = bos.toByteArray();
                            gzi.close();
                        }
                        catch (IOException e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                            }
                            log.error((Object)new StringBuffer().append("++++ IOException thrown while trying to uncompress input stream for key: ").append(key).toString());
                            log.error((Object)e.getMessage(), (Throwable)e);
                            throw new NestedIOException("++++ IOException thrown while trying to uncompress input stream for key: " + key, e);
                        }
                    }
                    if ((flag & 8) != 8) {
                        if (this.primitiveAsString || asString) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"++++ retrieving object and stuffing into a string.");
                            }
                            o = new String(buf, this.defaultEncoding);
                        } else {
                            try {
                                o = NativeHandler.decode(buf, flag);
                            }
                            catch (Exception e) {
                                if (this.errorHandler != null) {
                                    this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                                }
                                log.error((Object)new StringBuffer().append("++++ Exception thrown while trying to deserialize for key: ").append(key).toString(), (Throwable)e);
                                throw new NestedIOException(e);
                            }
                        }
                    } else {
                        ContextObjectInputStream ois = new ContextObjectInputStream(new ByteArrayInputStream(buf), this.classLoader);
                        try {
                            o = ois.readObject();
                            if (log.isInfoEnabled()) {
                                log.info((Object)new StringBuffer().append("++++ deserializing ").append(o.getClass()).toString());
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (this.errorHandler != null) {
                                this.errorHandler.handleErrorOnGet(this, (Throwable)e, key);
                            }
                            log.error((Object)new StringBuffer().append("++++ ClassNotFoundException thrown while trying to deserialize for key: ").append(key).toString(), (Throwable)e);
                            throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                        }
                    }
                    hm.put(key, o);
                    continue;
                }
                if (END.equals(line)) break;
            }
            if (!log.isDebugEnabled()) break block21;
            log.debug((Object)"++++ finished reading from cache server");
        }
    }

    private String sanitizeKey(String key) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(key, "UTF-8") : key;
    }

    public boolean flushAll() {
        return this.flushAll(null);
    }

    public boolean flushAll(String[] servers) {
        if (this.pool == null) {
            log.error((Object)"++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            log.error((Object)"++++ no servers to flush");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SockIOPool.SockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                log.error((Object)("++++ unable to get connection to : " + servers[i]));
                success = false;
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                continue;
            }
            String command = "flush_all\r\n";
            try {
                sock.write(command.getBytes());
                sock.flush();
                String line = sock.readLine();
                success = OK.equals(line) ? success : false;
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, e);
                }
                log.error((Object)"++++ exception thrown while writing bytes to server on flushAll");
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ failed to close socket : " + sock.toString()));
                }
                success = false;
                sock = null;
            }
            if (sock == null) continue;
            sock.close();
            sock = null;
        }
        return success;
    }

    public Map stats() {
        return this.stats(null);
    }

    public Map stats(String[] servers) {
        return this.stats(servers, "stats\r\n", STATS);
    }

    public Map statsItems() {
        return this.statsItems(null);
    }

    public Map statsItems(String[] servers) {
        return this.stats(servers, "stats items\r\n", STATS);
    }

    public Map statsSlabs() {
        return this.statsSlabs(null);
    }

    public Map statsSlabs(String[] servers) {
        return this.stats(servers, "stats slabs\r\n", STATS);
    }

    public Map statsSize() {
        return this.statsSize(null);
    }

    public Map statsSize(String[] servers) {
        return this.stats(servers, "stats sizes\r\n", STATS);
    }

    public Map statsSettings() {
        return this.statsSettings(null);
    }

    public Map statsSettings(String[] servers) {
        return this.stats(servers, "stats settings\r\n", STATS);
    }

    public Map statsCacheDump(int slabNumber, int limit) {
        return this.statsCacheDump(null, slabNumber, limit);
    }

    public Map statsCacheDump(String[] servers, int slabNumber, int limit) {
        return this.stats(servers, "stats cachedump " + slabNumber + " " + limit + "\r\n", ITEM);
    }

    private Map stats(String[] servers, String command, String lineStart) {
        if (command == null || command.trim().equals("")) {
            log.error((Object)"++++ invalid / missing command for stats()");
            return null;
        }
        String[] stringArray = servers = servers == null ? this.pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            log.error((Object)"++++ no servers to check stats");
            return null;
        }
        HashMap statsMaps = new HashMap();
        for (int i = 0; i < servers.length; ++i) {
            SockIOPool.SockIO sock = this.pool.getConnection(servers[i]);
            if (sock == null) {
                log.error((Object)("++++ unable to get connection to : " + servers[i]));
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                sock.write(command.getBytes());
                sock.flush();
                HashMap<String, String> stats = new HashMap<String, String>();
                while (true) {
                    String line = sock.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("++++ line: " + line));
                    }
                    if (line.startsWith(lineStart)) {
                        String[] info = line.split(" ", 3);
                        String key = info[1];
                        String value = info[2];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("++++ key  : " + key));
                            log.debug((Object)("++++ value: " + value));
                        }
                        stats.put(key, value);
                    } else {
                        if (END.equals(line)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"++++ finished reading from cache server");
                            }
                            break;
                        }
                        if (line.startsWith(ERROR) || line.startsWith(CLIENT_ERROR) || line.startsWith(SERVER_ERROR)) {
                            log.error((Object)"++++ failed to query stats");
                            log.error((Object)("++++ server response: " + line));
                            break;
                        }
                    }
                    statsMaps.put(servers[i], stats);
                }
            }
            catch (IOException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnStats(this, e);
                }
                log.error((Object)"++++ exception thrown while writing bytes to server on stats");
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error((Object)("++++ failed to close socket : " + sock.toString()));
                }
                sock = null;
            }
            if (sock == null) continue;
            sock.close();
            sock = null;
        }
        return statsMaps;
    }

    public Set getKeySet(boolean fast) {
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, String> dumps = new HashMap<String, String>();
        Map slabs = this.statsItems();
        if (slabs != null && slabs.keySet() != null) {
            Iterator itemsItr = slabs.keySet().iterator();
            while (itemsItr.hasNext()) {
                String server = itemsItr.next().toString();
                Map itemNames = (Map)slabs.get(server);
                Iterator itemNameItr = itemNames.keySet().iterator();
                while (itemNameItr.hasNext()) {
                    String itemName = itemNameItr.next().toString();
                    String[] itemAtt = itemName.split(":");
                    if (!itemAtt[2].startsWith("number")) continue;
                    dumps.put(itemAtt[1], itemAtt[1]);
                }
            }
            if (!dumps.values().isEmpty()) {
                for (String obj : dumps.values()) {
                    int dump = Integer.valueOf(obj);
                    Map cacheDump = this.statsCacheDump(dump, 0);
                    for (Map items : cacheDump.values()) {
                        for (String k : items.keySet()) {
                            try {
                                k = URLDecoder.decode(k, "UTF-8");
                            }
                            catch (Exception ex) {
                                log.error((Object)ex.getMessage());
                            }
                            if (k == null || k.trim().equals("")) continue;
                            if (fast) {
                                keys.add(k);
                                continue;
                            }
                            if (!this.keyExists(k)) continue;
                            keys.add(k);
                        }
                    }
                }
            }
        }
        return keys;
    }

    protected final class NIOLoader {
        protected Selector selector;
        protected int numConns = 0;
        protected MemCachedClient mc;
        protected Connection[] conns;

        public NIOLoader(MemCachedClient mc) {
            this.mc = mc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doMulti(boolean asString, Map sockKeys, String[] keys, Map ret) {
            long timeRemaining = 0L;
            try {
                long timeout;
                this.selector = Selector.open();
                this.conns = new Connection[sockKeys.keySet().size()];
                this.numConns = 0;
                for (Map.Entry entry : sockKeys.entrySet()) {
                    String host = (String)entry.getKey();
                    SockIOPool.SockIO sock = MemCachedClient.this.pool.getConnection(host);
                    if (sock == null) {
                        if (MemCachedClient.this.errorHandler != null) {
                            MemCachedClient.this.errorHandler.handleErrorOnGet(this.mc, (Throwable)new IOException("no socket to server available"), keys);
                        }
                        return;
                    }
                    this.conns[this.numConns++] = new Connection(sock, (StringBuffer)entry.getValue());
                }
                long startTime = System.currentTimeMillis();
                timeRemaining = timeout = MemCachedClient.this.pool.getMaxBusy();
                while (this.numConns > 0 && timeRemaining > 0L) {
                    int n = this.selector.select(Math.min(timeout, 5000L));
                    if (n > 0) {
                        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            this.handleKey(key);
                        }
                    } else {
                        log.error((Object)"selector timed out waiting for activity");
                    }
                    timeRemaining = timeout - (System.currentTimeMillis() - startTime);
                }
            }
            catch (IOException e) {
                this.handleError(e, keys);
                return;
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Disconnecting; numConns=" + this.numConns + "  timeRemaining=" + timeRemaining));
                }
                try {
                    this.selector.close();
                }
                catch (IOException entry) {}
                for (int i = 0; i < this.conns.length; ++i) {
                    if (this.conns[i] == null) continue;
                    this.conns[i].close();
                }
            }
            for (int i = 0; i < this.conns.length; ++i) {
                try {
                    if (this.conns[i].incoming.size() <= 0 || !this.conns[i].isDone()) continue;
                    MemCachedClient.this.loadMulti(new ByteBufArrayInputStream(this.conns[i].incoming), ret, asString);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Caught the aforementioned exception on " + this.conns[i]));
                }
            }
        }

        private void handleError(Throwable e, String[] keys) {
            if (MemCachedClient.this.errorHandler != null) {
                MemCachedClient.this.errorHandler.handleErrorOnGet(MemCachedClient.this, e, keys);
            }
            log.error((Object)"++++ exception thrown while getting from cache on getMulti");
            log.error((Object)e.getMessage());
        }

        private void handleKey(SelectionKey key) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("handling selector op " + key.readyOps() + " for key " + key));
            }
            if (key.isReadable()) {
                this.readResponse(key);
            } else if (key.isWritable()) {
                this.writeRequest(key);
            }
        }

        public void writeRequest(SelectionKey key) throws IOException {
            ByteBuffer buf = ((Connection)key.attachment()).outgoing;
            SocketChannel sc = (SocketChannel)key.channel();
            if (buf.hasRemaining()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writing " + buf.remaining() + "B to " + ((SocketChannel)key.channel()).socket().getInetAddress()));
                }
                sc.write(buf);
            }
            if (!buf.hasRemaining()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("switching to read mode for server " + ((SocketChannel)key.channel()).socket().getInetAddress()));
                }
                key.interestOps(1);
            }
        }

        public void readResponse(SelectionKey key) throws IOException {
            Connection conn = (Connection)key.attachment();
            ByteBuffer buf = conn.getBuffer();
            int count = conn.channel.read(buf);
            if (count > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("read  " + count + " from " + conn.channel.socket().getInetAddress()));
                }
                if (conn.isDone()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("connection done to  " + conn.channel.socket().getInetAddress()));
                    }
                    key.cancel();
                    --this.numConns;
                    return;
                }
            }
        }

        private final class Connection {
            public List incoming = new ArrayList();
            public ByteBuffer outgoing;
            public SockIOPool.SockIO sock;
            public SocketChannel channel;
            private boolean isDone = false;

            public Connection(SockIOPool.SockIO sock, StringBuffer request) throws IOException {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("setting up connection to " + sock.getHost()));
                }
                this.sock = sock;
                this.outgoing = ByteBuffer.wrap(request.append("\r\n").toString().getBytes());
                this.channel = sock.getChannel();
                if (this.channel == null) {
                    throw new IOException("dead connection to: " + sock.getHost());
                }
                this.channel.configureBlocking(false);
                this.channel.register(NIOLoader.this.selector, 4, this);
            }

            public void close() {
                try {
                    if (this.isDone) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("++++ gracefully closing connection to " + this.sock.getHost()));
                        }
                        this.channel.configureBlocking(true);
                        this.sock.close();
                        return;
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"++++ memcache: unexpected error closing normally");
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("forcefully closing connection to " + this.sock.getHost()));
                    }
                    this.channel.close();
                    this.sock.trueClose();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public boolean isDone() {
                if (this.isDone) {
                    return true;
                }
                int strPos = B_END.length - 1;
                for (int bi = this.incoming.size() - 1; bi >= 0 && strPos >= 0; --bi) {
                    ByteBuffer buf = (ByteBuffer)this.incoming.get(bi);
                    int pos = buf.position() - 1;
                    while (pos >= 0 && strPos >= 0) {
                        if (buf.get(pos--) == B_END[strPos--]) continue;
                        return false;
                    }
                }
                this.isDone = strPos < 0;
                return this.isDone;
            }

            public ByteBuffer getBuffer() {
                int last = this.incoming.size() - 1;
                if (last >= 0 && ((ByteBuffer)this.incoming.get(last)).hasRemaining()) {
                    return (ByteBuffer)this.incoming.get(last);
                }
                ByteBuffer newBuf = ByteBuffer.allocate(8192);
                this.incoming.add(newBuf);
                return newBuf;
            }

            public String toString() {
                return new StringBuffer().append("Connection to ").append(this.sock.getHost()).append(" with ").append(this.incoming.size()).append(" bufs; done is ").append(this.isDone).toString();
            }
        }
    }
}

