/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event;

import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.IEventExtendedData;
import com.kingdee.bos.event.exception.EventValidationException;
import com.kingdee.util.StringUtils;

public class EventExtendedData
implements IEventExtendedData {
    private static final long serialVersionUID = -2163776781996586674L;
    private String name = null;
    private String alias = null;
    private String description = null;
    private EventDataType dataType = null;
    private String mappingParameterName;
    private Object value = null;

    public EventExtendedData() {
    }

    public EventExtendedData(String name, EventDataType dataType, Object value) {
        this.name = name;
        this.dataType = dataType;
        this.value = value;
    }

    public EventExtendedData(String name, EventDataType dataType, Object value, String mappingParameterName) {
        this(name, dataType, value);
        this.mappingParameterName = mappingParameterName;
    }

    @Override
    public EventDataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setDataType(EventDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void validate() throws EventValidationException {
        if (StringUtils.isEmpty((String)this.name)) {
            throw new EventValidationException("EventExtendedData name can not be null!");
        }
        if (this.dataType == null) {
            throw new EventValidationException("EventExtendedData dataType can not be null!");
        }
    }

    @Override
    public String getMappingParameterName() {
        return this.mappingParameterName;
    }

    @Override
    public void setMappingParameterName(String mappingParameterName) {
        this.mappingParameterName = mappingParameterName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

