/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.adapter.BOSEventServiceConfig;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.core.launcher.EventLauncherFactory;
import com.kingdee.bos.event.model.EventRepositoryServiceFactory;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class BOSEventServiceAdapter
extends AbstractServiceAdapter {
    Logger logger = Logger.getLogger(BOSEventServiceAdapter.class);

    public int getPriority() {
        return 0;
    }

    public String getName() {
        return "BOSEventServiceAdapter";
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (!BOSEventUtils.getEventAdapterStatus()) {
            return;
        }
        if (1 == serviceContext.getExecutionMode() && this.isEntityOrFacadeInvoke(serviceContext)) {
            LowTimer timer = new LowTimer();
            this.executeAfter(serviceContext);
            BOSEventUtils.debugLogger(this.logger, "BOSEventServiceAdapter.execute executeAfter cost:" + timer.msValue());
        }
    }

    private void executeAfter(IServiceContext serviceContext) throws BOSException {
        EventMappingInfo[] eventMappingInfos = BOSEventUtils.getMatchedEventMappingInfos(serviceContext);
        if (eventMappingInfos == null || eventMappingInfos.length <= 0) {
            return;
        }
        for (int i = 0; i < eventMappingInfos.length; ++i) {
            EventMappingInfo info = eventMappingInfos[i];
            this.sendEvent(this.generateCommonEvent(serviceContext, info));
            this.logger.debug((Object)("executeAfter . generated and sended Event:" + info.getName()));
        }
    }

    private void sendEvent(ICommonEvent commonEvent) throws BOSException {
        if (commonEvent == null) {
            BOSEventUtils.debugLogger(this.logger, "BOSEventServiceAdapter.sendEvent,commonEvent is null");
            return;
        }
        BOSEventServiceConfig config = BOSEventServiceConfig.getInstance();
        EventLauncherFactory.getEventLauncher(config.getProtocol(), config.getServerUrl()).sendEvent(commonEvent);
    }

    private ICommonEvent generateCommonEvent(IServiceContext serviceContext, EventMappingInfo eventMappingInfo) throws BOSException {
        ICommonEvent commonEvent = null;
        BOSEventServiceConfig config = BOSEventServiceConfig.getInstance();
        String commonEventName = eventMappingInfo.getName();
        CommonEvent commonEventDef = EventRepositoryServiceFactory.getEventRepositoryService(config.getProtocol(), config.getServerUrl()).getCommonEventByCommonEventName(commonEventName);
        if (commonEventDef == null) {
            throw new BOSException("can't find commonevent define,Event name is : " + commonEventName);
        }
        String producer = StringUtils.isEmpty((String)eventMappingInfo.getProducer()) ? config.getDefaultEventProducer() : eventMappingInfo.getProducer();
        try {
            Class<?> producerClass = Class.forName(producer);
            Object instance = producerClass.newInstance();
            Method m = producerClass.getMethod("produceEvent", CommonEvent.class, ServiceContext.class, EventMappingInfo.class);
            commonEvent = (ICommonEvent)m.invoke(instance, commonEventDef, serviceContext, eventMappingInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return commonEvent;
    }

    private boolean isEntityOrFacadeInvoke(IServiceContext serviceContext) {
        return MetaDataTypeList.ENTITY.equals((Object)serviceContext.getMetaType()) || MetaDataTypeList.FACADE.equals((Object)serviceContext.getMetaType());
    }
}

