/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BOSEventServiceConfig {
    private static Logger logger = Logger.getLogger(BOSEventServiceConfig.class);
    private static final String EAS_DEPLOY = "eas.deploy";
    private static final String CONFIGFILE_NAME = "commonevent.properties";
    private static final String DEFAULE_PROTOCOL = "vm";
    private static final String DEFAULE_SERVERURL = "localhost";
    private static final String DEFAULT_EVENTPRODUCER = "com.kingdee.bos.event.producer.BOSEventProducer";
    private static final String DEFAULT_ENABLE = "true";
    private static final String PROTOCOL_KEY = "protocol";
    private static final String SERVERURL_KEY = "serverUrl";
    private static final String ENABLE_KEY = "enableBOSAdapter";
    private static final String DEFAULTPRODUCER_KEY = "defaultEventProcuder";
    private static final String DEFAULT_CONFIGFILE = "BOS_COMMONEVENT";
    private static final Map cache = new HashMap();
    private Properties properties = new Properties();

    private BOSEventServiceConfig() {
        this.loadConfig(null);
    }

    private BOSEventServiceConfig(File configFile) {
        this.loadConfig(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(File configFile) {
        if (configFile == null && System.getProperty(EAS_DEPLOY) != null && !"".equalsIgnoreCase(System.getProperty(EAS_DEPLOY).trim())) {
            String configFilePath = System.getProperty(EAS_DEPLOY) + "/" + CONFIGFILE_NAME;
            configFile = new File(configFilePath);
        }
        if (configFile != null) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(configFile);
                this.properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"BOSEventServiceConfig.loadConfig error", (Throwable)e);
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error((Object)"BOSEventServiceConfig.loadConfig error", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            logger.error((Object)"can't find the value of 'eas.deploy(system property)',please check the enviroment");
        }
    }

    public static BOSEventServiceConfig getInstance() {
        BOSEventServiceConfig config = (BOSEventServiceConfig)cache.get(DEFAULT_CONFIGFILE);
        if (config == null) {
            config = new BOSEventServiceConfig();
            cache.put(DEFAULT_CONFIGFILE, config);
        }
        return config;
    }

    public static BOSEventServiceConfig getInstance(File configFile) {
        BOSEventServiceConfig config = (BOSEventServiceConfig)cache.get(configFile.getAbsoluteFile().getAbsolutePath());
        if (config == null) {
            config = new BOSEventServiceConfig(configFile);
            cache.put(configFile.getAbsoluteFile().getAbsolutePath(), config);
        }
        return config;
    }

    public String getDefaultEventProducer() {
        return this.properties.getProperty(DEFAULTPRODUCER_KEY, DEFAULT_EVENTPRODUCER);
    }

    public String getProtocol() {
        return this.properties.getProperty(PROTOCOL_KEY, DEFAULE_PROTOCOL);
    }

    public String getServerUrl() {
        return this.properties.getProperty(SERVERURL_KEY, DEFAULE_SERVERURL);
    }

    public boolean isEnable() {
        String value = this.properties.getProperty(ENABLE_KEY, DEFAULT_ENABLE);
        return Boolean.valueOf(value);
    }
}

