/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.adapter.BOSEventServiceConfig;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.adapter.IEventServiceProvider;
import com.kingdee.bos.event.core.launcher.EventLauncherFactory;
import com.kingdee.bos.event.model.EventRepositoryServiceFactory;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class DynamicBillEventServiceProvider
implements IEventServiceProvider {
    private static final Logger logger = Logger.getLogger(DynamicBillEventServiceProvider.class);

    DynamicBillEventServiceProvider() {
    }

    @Override
    public void sendEvent(IServiceContext serviceContext) throws BOSException {
        this.executeAfter(serviceContext);
    }

    private void executeAfter(IServiceContext serviceContext) throws BOSException {
        EventMappingInfo[] eventMappingInfos = BOSEventUtils.getMatchedEventMappingInfos("com.kingdee.bos.event.adapter.DyanmicBillEventMappingRule", serviceContext);
        if (eventMappingInfos == null || eventMappingInfos.length <= 0) {
            return;
        }
        for (int i = 0; i < eventMappingInfos.length; ++i) {
            EventMappingInfo info = eventMappingInfos[i];
            this.sendEvent(this.generateCommonEvent(serviceContext, info));
        }
    }

    private void sendEvent(ICommonEvent commonEvent) throws BOSException {
        if (commonEvent == null) {
            BOSEventUtils.debugLogger(logger, "BOSEventServiceAdapter.sendEvent,commonEvent is null");
            return;
        }
        BOSEventServiceConfig config = BOSEventServiceConfig.getInstance();
        EventLauncherFactory.getEventLauncher(config.getProtocol(), config.getServerUrl()).sendEvent(commonEvent);
    }

    private ICommonEvent generateCommonEvent(IServiceContext serviceContext, EventMappingInfo eventMappingInfo) throws BOSException {
        ICommonEvent commonEvent = null;
        BOSEventServiceConfig config = BOSEventServiceConfig.getInstance();
        String commonEventName = eventMappingInfo.getName();
        CommonEvent commonEventDef = EventRepositoryServiceFactory.getEventRepositoryService(config.getProtocol(), config.getServerUrl()).getCommonEventByCommonEventName(commonEventName);
        if (commonEventDef == null) {
            throw new BOSException("can't find commonevent define,Event name is : " + commonEventName);
        }
        String producer = StringUtils.isEmpty((String)eventMappingInfo.getProducer()) ? config.getDefaultEventProducer() : eventMappingInfo.getProducer();
        try {
            Class<?> producerClass = Class.forName(producer);
            Object instance = producerClass.newInstance();
            Method m = producerClass.getMethod("produceEvent", CommonEvent.class, ServiceContext.class, EventMappingInfo.class);
            commonEvent = (ICommonEvent)m.invoke(instance, commonEventDef, serviceContext, eventMappingInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return commonEvent;
    }
}

